#!/usr/bin/env bash

# aCO WEB CERTIFICATES updater script
#
# parameter:
#           * url where to get the file .akkadian_keystore
#           * md5 code


wget $1 -O '/opt/akkadian/data/tmp/.akkadian_keystore'

check=$(awk -F ': ' '{print $2}' <<< $(md5sum -c <<< "$2 /opt/akkadian/data/tmp/.akkadian_keystore"))
if [ "$check" != "OK" ]; then
    echo "ERROR: no properly formatted MD5 checksum lines found"; exit;
fi

sh scripts/stop_kestrel.sh
sh scripts/stop_tomcat.sh

cp /opt/akkadian/data/tmp/.akkadian_keystore /opt/akkadian/aco-server/certificates/aco-web/

sh scripts/start_kestrel.sh
sh scripts/start_tomcat.sh
