#!/usr/bin/env bash

LRED='\033[1;31m'
LBLUE='\033[1;34m'
LGREEN='\033[1;32m'
YELLOW='\033[1;33m'
NC='\033[0m' # No Color

echo -e "${LBLUE}Setting the environment...${NC}'"
APP_DIRECTORY=$1
SOURCE_UPDATE_FILE_PATH=$2

APP_GIT_CMD="git --work-tree=$APP_DIRECTORY --git-dir=$APP_DIRECTORY/.git"

bn=$(basename $2)
TEMP_UPDATE_FILE_PATH="/tmp/$bn"
TEMP_UPDATE_DIRECTORY="/tmp/akkadian_updator/$(uuidgen)"

if [[ ! -d /tmp/akkadian_updator ]]; then
    sudo mkdir /tmp/akkadian_updator
fi



echo -e "${LBLUE}Getting the installer file...${NC}'"
#If we need to download the file
if [[ ( $SOURCE_UPDATE_FILE_PATH == "http"* ) || ( $SOURCE_UPDATE_FILE_PATH == "ftp"* ) ]]
then
    #Download update file to working directory
    echo -e "${LBLUE}Downloading source file...${NC}"
    wget "$SOURCE_UPDATE_FILE_PATH" -O "$TEMP_UPDATE_FILE_PATH"
else
    #Copy update file to working directory
    sudo cp "$SOURCE_UPDATE_FILE_PATH" "$TEMP_UPDATE_FILE_PATH"
fi

#Unzip
echo -e "${LBLUE}Untar update file...${NC}'"
mkdir $TEMP_UPDATE_DIRECTORY
tar -zxf "$TEMP_UPDATE_FILE_PATH" -C "$TEMP_UPDATE_DIRECTORY"
BUNDLE_FILE_NAME=$(ls "$TEMP_UPDATE_DIRECTORY/"*.bundle | tail -1)

echo "TEMP_UPDATE_FILE_PATH: $TEMP_UPDATE_FILE_PATH"
echo "TEMP_UPDATE_DIRECTORY: $TEMP_UPDATE_DIRECTORY"
echo "bundle file name: $BUNDLE_FILE_NAME"
BUNDLE_FILE_NAME=$(basename "$BUNDLE_FILE_NAME")


#Verify bundle file exists
if [[ ! -f $TEMP_UPDATE_DIRECTORY/$BUNDLE_FILE_NAME ]]
then
    echo -e "${LRED}Update tar file is missing bundle file.${NC}"
    exit 1
fi

#TODO: take backup /var/www/html/akkadianuniversalupdater
#Unbundle
echo -e "${LBLUE}working with the folders on the installation...${NC}'"

if [[ -d /var/www/html/akkadianuniversalupdater ]]; then
    #mkdir /var/www/html/akkadianuniversalupdater
    date=$(date +%F)
    tar -zcf /home/akkadianuser/backups/akkadianuniversalupdater-$date.tar.gz /var/www/html/akkadianuniversalupdater
    rm -Rf /var/www/html/akkadianuniversalupdater
fi

echo -e "${LBLUE}unbandle installation...${NC}'"
$APP_GIT_CMD clone -n --depth=1 "$TEMP_UPDATE_FILE_PATH" update
$APP_GIT_CMD checkout $BUNDLE_FILE_NAME
