#!/usr/bin/env bash

product_name=${1#"-"}
product_package=$2

version_after=$(jq '.product.version' /var/www/product_update/manifest.json)
j=$(echo $version_after | tr -d ' \r\n')
j=$(echo $j | tr -d '"' )
version_after=$j

build_after=$(jq '.product.build' /var/www/product_update/manifest.json)
j=$(echo $build_after | tr -d ' \r\n')
j=$(echo $j | tr -d '"' )
build_after=$j

if [[ "$product_name" == "apm" ]]; then
    echo "Installing APM... please wait"
    pme_version_before=$(sh /home/akkadianuser/scripts/get_PME_version.sh)
    echo "Old Version: $pme_version_before"
    d=$(date)

    echo "apm,$d,$pme_version_before,$version_after-$build_after" >> /var/www/product_update/installation_history.csv
    echo "sh /home/akkadianuser/scripts/pme_update.sh $pme_version_before /var/www/product_update/${product_package}" >> /var/www/product_update/update.log
    sudo sh /home/akkadianuser/scripts/pme_update.sh $pme_version_before /var/www/product_update/${product_package}

elif [[ "$product_name" == "acm" ]]; then
    echo "Installing ACM... please wait"
    cm_version_before=$(sh /home/akkadianuser/scripts/get_CM_version.sh)
    d=$(date)
    echo "acm,$d,$cm_version_before,$version_after-$build_after" >> /var/www/product_update/installation_history.csv

    sudo sh /home/akkadianuser/scripts/cm_update.sh $product_name

elif [[ "$product_name" == "aco" ]]; then
    echo "Installing ACO... please wait"
    cucm_url=$(node /home/akkadianuser/scripts/universal_updater/getCUCMUrlFromConfig.js)

    #TODO: add a new tuple in the jenkins build in order to prompt both versions/builds
    acoserver_version_before=$(sudo sh /home/akkadianuser/scripts/get_ACOSERVER_version.sh)
    acoweb_version_before=$(sudo sh /home/akkadianuser/scripts/get_ACOWEB_version.sh)
    d=$(date)

    sudo sh /home/akkadianuser/scripts/aco_update.sh /var/www/product_update/${product_package} $cucm_url
    echo "aco_server/aco_web,$d,$acoserver_version_before/$acoweb_version_before,$version_after-$build_after" >> /var/www/product_update/installation_history.csv

elif [[ "$product_name" == "orc" || "$product_name" == "asb" || "$product_name" == "maestro" ]]; then

    #the installation_history.csv file is modified inside the laravel_updater script
    echo "Installing $product_name... please wait"

    if [[ "$product_name" == "orc" ]]; then
        check=$(echo "Akkadian Orchestrator" | shasum -a 256) # | awk '{print $1;}')
    elif [[ "$product_name" == "asb" ]]; then
        check=$(echo "Akkadian Site Builder" | shasum -a 256) # | awk '{print $1;}')
    else
        check=$(echo "Akkadian Maestro" | shasum -a 256) # | awk '{print $1;}')
    fi

    echo "sh /home/akkadianuser/scripts/laravel_updater.sh /var/www/product_update/${product_package} 'V33NEup6YuGC2zdte2sRs' '$check' '/var/www/html/$product_name'" >> /var/www/product_update/update.log
    sudo sh /home/akkadianuser/scripts/laravel_updater.sh /var/www/product_update/${product_package} 'V33NEup6YuGC2zdte2sRs' "$check" '/var/www/html/'$product_name

elif [[ "$product_name" == "hcs" ]]; then
    #manifest.json line: update_product.sh -hcs updates/HCS-5.0.6-5.0.37.2-Update.zip
    #product_package=updates/HCS-5.0.6-5.0.37.2-Update.zip
    unzip -o $product_package -d /var/www/product_update/updates/
    #take APM name
    current_apm_zip_name=$(sudo ls -1 /var/www/product_update/updates/APM*.zip 2>/dev/null | tail -1)
    current_apm_zip_name=$(basename $current_apm_zip_name)
    echo "$current_apm_zip_name, now calling -apm process" >> /var/www/product_update/update.log
    sh /home/akkadianuser/scripts/universal_updater/update_product.sh -apm updates/$current_apm_zip_name

    #take orc name
    current_orc_zip_name=$(sudo ls -1 /var/www/product_update/updates/*Orc*.zip 2>/dev/null | tail -1)
    current_orc_zip_name=$(basename $current_orc_zip_name)
    echo "$current_orc_zip_name, now calling -orc process" >> /var/www/product_update/update.log
    sh /home/akkadianuser/scripts/universal_updater/update_product.sh -orc updates/$current_orc_zip_name

    #take asb name
    current_asb_zip_name=$(sudo ls -1 /var/www/product_update/updates/*ASB*.zip 2>/dev/null | tail -1)
    current_asb_zip_name=$(basename $current_asb_zip_name)
    echo "$current_asb_zip_name, now calling -asb process" >> /var/www/product_update/update.log
    sh /home/akkadianuser/scripts/universal_updater/update_product.sh -asb updates/$current_asb_zip_name

    #take maestro name
    current_maestro_zip_name=$(sudo ls -1 /var/www/product_update/updates/*Maestro*.zip 2>/dev/null | tail -1)
    current_maestro_zip_name=$(basename $current_maestro_zip_name)
    echo "$current_maestro_zip_name, now calling -maestro process" >> /var/www/product_update/update.log
    sh /home/akkadianuser/scripts/universal_updater/update_product.sh -maestro updates/$current_maestro_zip_name

fi