#!/usr/bin/env bash

#sudo openssl enc -d -aes-256-cbc -in /var/www/product_update/$1 -pass pass:'HtBr6QckqJPk4rpatyUNT594' | tar xz -C /var/www/product_update/
function finish {

    echo "Running rollback commands" >> /var/www/product_update/update.log
    IFS=' '
    rollback=$(jq '.rollback' $file)
    temp="${rollback%\]}"
    temp="${temp#\[}"
    rollback=$(echo $temp | tr -d '\r\n')

    for j in $rollback ; do
        echo "[Rollback Script Running] $j" >> /var/www/product_update/update.log
        j=$(echo $j | tr -d ' \r\n')
        j=$(echo $j | tr -d '"' )

        cd /var/www/product_update/scripts
        evaluate=$(echo "$j")
        sh $evaluate
        if [[ "$?" != "0" ]]; then
            echo "[Error] rollback script execution failed" >> /var/www/product_update/update.log
            echo "500 - Error: $1" > /var/www/product_update/installation.progress
        fi
    done
    sudo sh /home/akkadianuser/scripts/universal_updater/check_updater_log_size.sh /var/www/product_update/update.log
    echo "Finishing with Rollback at $(date '+%d%m%Y_%H%M%S')" >> /var/www/product_update/update.log
    echo "500 - Error: Rollback was completed because $1" > /var/www/product_update/installation.progress
    sudo sh /home/akkadianuser/scripts/universal_updater/clean_uu.sh
    exit 1

}

echo "Starting at $(date '+%d%m%Y_%H%M%S')" >> /var/www/product_update/update.log
echo "0" > /var/www/product_update/installation.progress

package_name=$(echo "/var/www/product_update/$1")
use_encryptation=$(cat /home/akkadianuser/global_variables/use_encryption)

echo "use encryptation: $use_encryptation" >> /var/www/product_update/update.log
if [[ "$use_encryptation" == "yes" ]]; then
    package_name_after=${package_name::${#package_name}-7}.zip
    openssl aes-256-cbc -salt -a -d -md sha256 -in $package_name -out $package_name_after -pass pass:'HtBr6QckqJPk4rpatyUNT594'
    #openssl enc -d -aes-256-cbc -md sha256 -in $package_name -pass pass:'HtBr6QckqJPk4rpatyUNT594' | unzip $package_name -d /var/www/product_update/
    unzip -o $package_name_after -d /var/www/product_update/
    rm -Rf $package_name
else
    unzip $package_name -d /var/www/product_update/
    sudo rm -Rf /home/akkadianuser/global_variables/use_encryption
    sudo echo "yes" >> /home/akkadianuser/global_variables/use_encryption
fi


file="/var/www/product_update/manifest.json"

product_name=$(jq '.product.product_name' $file)
echo "Main Product Name: $product_name" >> /var/www/product_update/update.log
product_version=$(jq '.product.version' $file)
echo "Main Product Version: $product_version" >> /var/www/product_update/update.log
product_build=$(jq '.product.build' $file)
echo "Main Product Build: $product_build" >> /var/www/product_update/update.log
###### Installing Packages without Internet Connection #####################################

app_package_list=$(jq '.packages' $file)
temp="${app_package_list%\]}"
temp="${temp#\[}"
app_package_list=$(echo $temp | tr -d '\r\n')


echo "Installing packages: $app_package_list" >> /var/www/product_update/update.log
IFS=","
for j in $app_package_list ; do
    echo "[Package Installation] $j" >> /var/www/product_update/update.log
    j=$(echo $j | tr -d ' \r\n')
    j=$(echo $j | tr -d '"' )

    sudo rpm -Uhv --force /var/www/product_update/packages/$j
    if [[ "$?" != "0" ]]; then
        echo "[Error] package installation failed" >> /var/www/product_update/update.log
        finish "Installing Packages Error"
    fi
done
sleep 5

############################################################################################

###### Installing pre commands #############################################################
echo "Running pre update commands" >> /var/www/product_update/update.log
IFS=','
prescripts=$(jq '.prescripts' $file)
temp="${prescripts%\]}"
temp="${temp#\[}"
prescripts=$(echo $temp | tr -d '\r\n')


echo "pre-scripts list: $prescripts" >> /var/www/product_update/update.log
IFS=" "
for j in $prescripts ; do
    echo "[Pre Script Running] $j" >> /var/www/product_update/update.log
    j=$(echo $j | tr -d '"' )
    j=$(echo $j | tr -d ' \r\n')

    cd /var/www/product_update/scripts
    echo "eval sh $j" >> /var/www/product_update/update.log
    sh $j
    if [[ "$?" != "0" ]]; then
        echo "[Error] script execution failed" >> /var/www/product_update/update.log
        finish "Running pre-scripts failed"
    fi
done
sleep 5

#######################################################################################################
echo "25" > /var/www/product_update/installation.progress

############## Running main updates cli and the product ###############################################

echo "Running CLI Installation" >> /var/www/product_update/update.log
script_to_run=$(jq '.cli_update_command' $file)
if [[ ! -z "$script_to_run" && "$script_to_run" != '""' ]]; then
    script_to_run=$(echo $script_to_run | tr -d '"[]\t\n\r')
    script_to_run="$(echo -e "${script_to_run}" | sed -e 's/^[[:space:]]*//')"
    script_to_run=${script_to_run#"null"}
    script_to_run=${script_to_run%"null"}

    #cd /home/akkadianuser/scripts/universal_updater
    evaluate=$(echo "sh /home/akkadianuser/scripts/universal_updater/$script_to_run")
    echo "[Main CLI Installation] Running Script: $evaluate" >> /var/www/product_update/update.log
    eval $evaluate
    if [ "$?" != "0" ]; then
        echo "[Error] package installation failed" >> /var/www/product_update/update.log
        finish "Installing CLI failed"
    fi
fi

echo "50" > /var/www/product_update/installation.progress

echo "Running Product Installation" >> /var/www/product_update/update.log
script_to_run=$(jq '.product_update_command' $file)
echo "Main Product Installation package: $script_to_run" >> /var/www/product_update/update.log
if [[ ! -z "$script_to_run" && "$script_to_run" != '""' ]]; then
    script_to_run=$(echo $script_to_run | tr -d '"[]\t\n\r')
    script_to_run="$(echo -e "${script_to_run}" | sed -e 's/^[[:space:]]*//')"
    script_to_run=${script_to_run#"null"}
    script_to_run=${script_to_run%"null"}

    #cd /home/akkadianuser/scripts/universal_updater
    evaluate=$(echo "sh /home/akkadianuser/scripts/universal_updater/$script_to_run")
    echo "[Main Product Installation] Running Script: $evaluate" >> /var/www/product_update/update.log
    eval $evaluate
    if [ "$?" != "0" ]; then
        echo "[Error] package installation failed" >> /var/www/product_update/update.log
        finish "Installing main Product failed"
    fi
    sleep 5
fi

########################################################################################################
echo "75" > /var/www/product_update/installation.progress

################ Running Post Commands #################################################################

IFS=','
postscripts=$(jq '.postscripts' $file)
temp="${postscripts%\]}"
temp="${temp#\[}"
postscripts=$(echo $temp | tr -d '\r\n')


echo "Running Post Scripts: $postscripts" >> /var/www/product_update/update.log
IFS=" "
for j in $postscripts ; do
    echo "[Post Script Running] $j" >> /var/www/product_update/update.log
    j=$(echo $j | tr -d ' \r\n')
    j=$(echo $j | tr -d '"' )

    cd /var/www/product_update/scripts
    sh $j
    if [[ "$?" != "0" ]]; then
        echo "[Error] script execution failed" >> /var/www/product_update/update.log
        finish "Running post-scripts error"
    fi
done

sudo sh /home/akkadianuser/scripts/universal_updater/clean_uu.sh
echo "100" > /var/www/product_update/installation.progress

echo "Finishing at $(date '+%d%m%Y_%H%M%S')" >> /var/www/product_update/update.log