#!/usr/bin/env bash

UNIVERSAL_UPDATER_INSTALLER_VERSION=1.0
SOURCE_UPDATE_FILE_PATH=$1
APP_DIRECTORY=$2

SOURCE_UPDATE_FILE_NAME=$(basename $1)
AKKADIAN_SCRIPT_LIB_PATH="/home/akkadianuser/scripts"
TEMP_UPDATE_FILE_PATH="/tmp/$SOURCE_UPDATE_FILE_NAME"
TEMP_UPDATE_DIRECTORY="/tmp/akkadian_updator/$(uuidgen)"

if [[ ! -d /tmp/akkadian_updator ]]; then
    sudo mkdir /tmp/akkadian_updator
fi

mkdir $TEMP_UPDATE_DIRECTORY
#If we need to download the file
if [[ ( $SOURCE_UPDATE_FILE_PATH == "http"* ) || ( $SOURCE_UPDATE_FILE_PATH == "ftp"* ) ]]
then
    #Download update file to working directory
    echo -e "Downloading source file..."
    wget "$SOURCE_UPDATE_FILE_PATH" -O "$TEMP_UPDATE_FILE_PATH"
else
    #Copy update file to working directory
    sudo cp "$SOURCE_UPDATE_FILE_PATH" "$TEMP_UPDATE_FILE_PATH"
fi

#Unzip
echo -e "Unzipping update file..."
tar -zxf "$TEMP_UPDATE_FILE_PATH" -C "$TEMP_UPDATE_DIRECTORY/"
BUNDLE_FILE_NAME=$(ls "$TEMP_UPDATE_DIRECTORY/"*.bundle | tail -1)

BUNDLE_PATH=$(echo "$BUNDLE_FILE_NAME")
echo "The bundle_Path is: $BUNDLE_PATH"

#Install bundle
$AKKADIAN_SCRIPT_LIB_PATH/installBundleUpdate.sh "$BUNDLE_PATH" "$APP_DIRECTORY"
if [[ $? != 0 ]]
then
    echo "Failed to install bundle.";
    exit 1;
fi

#Update permissions
echo "Updating Permissions..."
chown -R root:apache "$APP_DIRECTORY"
chmod -R 2775 "$APP_DIRECTORY"

#Cleanup
echo "Cleaning up..."
#TODO: WRITE ANY CLEANUP CODE NEEDED

echo "Done."