#!/usr/bin/env bash

location=${product_location}

rm -Rf *
mkdir scripts
mkdir packages
mkdir updates

echo "location is: $location"
IFS=','
echo "These are the pre scripts"
if [[ ! -z "$prescripts" ]]; then
	prescriptslist="["
    for j in ${prescripts}; do
        echo "$scripts_location$j"
        wget -P scripts "$scripts_location$j"
        prescriptslist=$(echo "$prescriptslist\"$j\",")
    done
    prescriptslist=${prescriptslist::-1}
	prescriptslist=$(echo "$prescriptslist]")
	echo "This is the variable into the manifest.json: $prescriptslist"
else
	prescriptslist="[]"
fi


echo "These are the post scripts"
if [[ ! -z "$postscripts" ]]; then
  postscriptslist="["
  for j in ${postscripts}; do
      echo "$scripts_location$j"
      wget -P scripts "$scripts_location$j"
      postscriptslist=$(echo "$postscriptslist\"$j\",")
  done
  postscriptslist=${postscriptslist::-1}
  postscriptslist=$(echo "$postscriptslist]")
  echo "This is the variable into the manifest.json: $postscriptslist"
else
  postscriptslist="[]"
fi


if [[ ! -z "$rollback" ]]; then
  echo "These are the rollback script"
  rollbacklist="["
  for j in ${rollback}; do
      echo "$scripts_location$j"
      wget -P scripts "$scripts_location$j"
      rollbacklist=$(echo "$rollbacklist\"$j\",")
  done
  rollbacklist=${rollbacklist::-1}
  rollbacklist=$(echo "$rollbacklist]")
  echo "This is the variable into the manifest.json: $rollbacklist"
else
  rollbacklist="[]"
fi

if [[ ! -z "$packages" ]]; then
  echo "These are the packages"
  packageslist="["
  for j in ${packages}; do
      echo "$scripts_location$j"
      wget -P packages "$scripts_location$j"
      packageslist=$(echo "$packageslist\"$j\",")

  done
  packageslist=${packageslist::-1}
  packageslist=$(echo "$packageslist]")
  echo "This is the variable into the manifest.json: $packageslist"
else
  packageslist="[]"
fi

echo "Product to include: $location${product_package_name}"
wget -P updates "$location${product_package_name}"

if [[ ! "$cli_package_name" == "" ]]; then
	echo "CLI name: ${cli_package_name}"
	wget -P updates "$cli_location${cli_package_name}"
    cli_update_command=$(echo "update_cli.sh $cli_package_name")
fi

yum -y install jq

update_product_command=$(echo "update_product.sh -$product updates/$product_package_name")

echo "pre-scripts: $prescriptslist"
echo "post-scripts: $postscriptslist"
echo "rollback: $rollbacklist"
echo "packages: $packageslist"

jq -n --arg product "$product" --arg version "$version" --arg build "$build" --arg product_file "$product_package_name" --arg cli_package_name "$cli_package_name" --argjson packages "$packageslist" --argjson prescripts "$prescriptslist" --argjson postscripts "$postscriptslist" --argjson rollback "$rollbacklist" --arg cli_update_command "$cli_update_command" --arg update_product_command "$update_product_command" '{
      "product":
      {
        "product_name":$product,
        "version": $version,
        "build": $build
      },
      "files": {
        "product_file_name": $product_file,
        "cli_file_name": $cli_package_name
      },
      "packages": $packages,
      "prescripts": $prescripts,
      "cli_update_command": $cli_update_command,
      "product_update_command": $update_product_command,
      "postscripts": $postscripts,
      "rollback": $rollback

  }' > manifest.json


rm -Rf *.zip

#Building the name of the package ###################################
productfilename=$(basename -- "$product_package_name")
extension="${productfilename##*.}"
productfilename="${productfilename%.*}"

#Remove gz
clifilename=$(basename -- "$cli_package_name")
extension="${clifilename##*.}"
clifilename="${clifilename%.*}"

#Remove tar
clifilename=$(basename -- "$clifilename")
extension="${clifilename##*.}"
clifilename="${clifilename%.*}"

if [[ $productfilename == *"Update"* ]]; then
	productfilename=$(printf '%s\n' "${productfilename//-Update/}")
fi

if [[ "$clifilename" != "" ]]; then
	uu_name=$(echo "Akkadian_Update_${productfilename}_${clifilename}")
else
	uu_name=$(echo "Akkadian_Update_${productfilename}")
fi

if [[ "$encrypted" == "yes" ]]; then
	echo "encripting and zipping..."
	zip -r ${uu_name}.zip .
    sleep 5
    #this line stop working: openssl enc -e -aes-256-cbc -in ${uu_name}.zip -out ${uu_name}-en.zip -pass pass:'HtBr6QckqJPk4rpatyUNT594'
    openssl aes-256-cbc -salt -a -e -md sha256 -in ${uu_name}.zip -out ${uu_name}-en.zip -pass pass:'HtBr6QckqJPk4rpatyUNT594'
    sleep 5
    rm -Rf ${uu_name}.zip
else
	echo "zipping..."
	zip -r ${uu_name}.zip .
fi

####################################################################

rm -Rf scripts
rm -Rf packages
rm -Rf updates
rm -Rf manifest.json

if [[ ! -d /var/www/html/ova/universal_updater/ ]]; then
	mkdir /var/www/html/ova/universal_updater/
fi

cp -Rf *.zip /var/www/html/ova/universal_updater/