#!/usr/bin/env bash
echo "Synchronizing Database"

MASTER=$(pcs status | grep RS_VIP_Akkadian | awk -F ' ' '{print $4}')
NODES=$(pcs status | grep Online: | awk -F : '{print $2}')

mysqldump --defaults-extra-file=/home/akkadianuser/.my.cnf -u root pme > /home/akkadianuser/dbstosync/dbtosync_pme.sql
mysqldump --defaults-extra-file=/home/akkadianuser/.my.cnf -u root asb > /home/akkadianuser/dbstosync/dbtosync_asb.sql
mysqldump --defaults-extra-file=/home/akkadianuser/.my.cnf -u root call_manager > /home/akkadianuser/dbstosync/dbtosync_call_manager.sql
mysqldump --defaults-extra-file=/home/akkadianuser/.my.cnf -u root orc > /home/akkadianuser/dbstosync/dbtosync_orc.sql
mysqldump --defaults-extra-file=/home/akkadianuser/.my.cnf -u root ucce > /home/akkadianuser/dbstosync/dbtosync_ucce.sql
mysqldump --defaults-extra-file=/home/akkadianuser/.my.cnf -u root unity_connection > /home/akkadianuser/dbstosync/dbtosync_unity_connection.sql

gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_pme_cm.gpg > /home/akkadianuser/.sshpass

IFS=$' '
echo "Database Synchronization source: $MASTER"
for j in $NODES
do
        if [[ ( "$j" != "[" ) && ( "$j" != "]" ) && ("$j" != "$MASTER") ]]
        then
                #copying files
                sshpass -f /home/akkadianuser/.sshpass scp -o StrictHostKeyChecking=no /home/akkadianuser/dbstosync/dbtosync_pme.sql root@$j:/home/akkadianuser/dbstosync/dbtosync_pme.sql
                sshpass -f /home/akkadianuser/.sshpass scp -o StrictHostKeyChecking=no /home/akkadianuser/dbstosync/dbtosync_asb.sql root@$j:/home/akkadianuser/dbstosync/dbtosync_asb.sql
                sshpass -f /home/akkadianuser/.sshpass scp -o StrictHostKeyChecking=no /home/akkadianuser/dbstosync/dbtosync_call_manager.sql root@$j:/home/akkadianuser/dbstosync/dbtosync_call_manager.sql
                sshpass -f /home/akkadianuser/.sshpass scp -o StrictHostKeyChecking=no /home/akkadianuser/dbstosync/dbtosync_orc.sql root@$j:/home/akkadianuser/dbstosync/dbtosync_orc.sql
                sshpass -f /home/akkadianuser/.sshpass scp -o StrictHostKeyChecking=no /home/akkadianuser/dbstosync/dbtosync_ucce.sql root@$j:/home/akkadianuser/dbstosync/dbtosync_ucce.sql
                sshpass -f /home/akkadianuser/.sshpass scp -o StrictHostKeyChecking=no /home/akkadianuser/dbstosync/dbtosync_unity_connection.sql root@$j:/home/akkadianuser/dbstosync/dbtosync_unity_connection.sql


                sshpass -f /home/akkadianuser/.sshpass ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "SET FOREIGN_KEY_CHECKS=0"'
                sshpass -f /home/akkadianuser/.sshpass ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "drop database pme"'
                sshpass -f /home/akkadianuser/.sshpass ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "drop database asb"'
                sshpass -f /home/akkadianuser/.sshpass ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "drop database call_manager"'
                sshpass -f /home/akkadianuser/.sshpass ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "drop database orc"'
                sshpass -f /home/akkadianuser/.sshpass ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "drop database ucce"'
                sshpass -f /home/akkadianuser/.sshpass ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "drop database unity_connection"'
                sshpass -f /home/akkadianuser/.sshpass ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "SET FOREIGN_KEY_CHECKS=1"'

                sshpass -f /home/akkadianuser/.sshpass ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "create database pme"'
                sshpass -f /home/akkadianuser/.sshpass ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "create database asb"'
                sshpass -f /home/akkadianuser/.sshpass ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "create database call_manager"'
                sshpass -f /home/akkadianuser/.sshpass ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "create database orc"'
                sshpass -f /home/akkadianuser/.sshpass ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "create database ucce"'
                sshpass -f /home/akkadianuser/.sshpass ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "create database unity_connection"'

                sshpass -f /home/akkadianuser/.sshpass ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root pme < /home/akkadianuser/dbstosync/dbtosync_pme.sql'
                sshpass -f /home/akkadianuser/.sshpass ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root asb < /home/akkadianuser/dbstosync/dbtosync_asb.sql'
                sshpass -f /home/akkadianuser/.sshpass ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root call_manager < /home/akkadianuser/dbstosync/dbtosync_call_manager.sql'
                sshpass -f /home/akkadianuser/.sshpass ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root orc < /home/akkadianuser/dbstosync/dbtosync_orc.sql'
                sshpass -f /home/akkadianuser/.sshpass ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root ucce < /home/akkadianuser/dbstosync/dbtosync_ucce.sql'
                sshpass -f /home/akkadianuser/.sshpass ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root unity_connection < /home/akkadianuser/dbstosync/dbtosync_unity_connection.sql'

        fi
done

truncate -s 0 /home/akkadianuser/.sshpass
echo "Database Synchronization Completed"
echo "$(date) $(ls -1 | wc -l)" > /home/akkadianuser/sync_end_at_log