#!/usr/bin/env bash
MASTER=$(sudo pcs status | grep RS_VIP_Akkadian | awk -F ' ' '{print $4}')
MY_HOSTNAME=$(sudo hostname)


OFFLINE_NODES=$(pcs status | grep OFFLINE: | awk -F : '{print $2}')

if [[ "$MASTER" == "$MY_HOSTNAME" ]]; then
    for j in $OFFLINE_NODES
    do
        echo "node: $j is unavailable, data synchronization failed"
    done

    echo "$(date) $(ls -1 | wc -l)" > /home/akkadianuser/sync_start_at_log
    echo "Detecting application synchronization options..."
    if [[ -d /opt/akkadian/aco-server ]]; then
        echo "Initializing ACO Synchronization"
        exec sudo /home/akkadianuser/scripts/sync_aco_db.sh
    elif [[ -d /var/www/html/pme ]]; then
        echo "Initializing APM Synchronization"
        exec sudo /home/akkadianuser/scripts/sync_pme_db.sh
    else
        echo "Initializing ACM Synchronization"
        exec sudo /home/akkadianuser/scripts/sync_acm_db.sh
    fi
fi
exit