#!/usr/bin/env bash
echo "Synchronizing Database"
MASTER=$(pcs status | grep RS_VIP_Akkadian | awk -F ' ' '{print $4}')
NODES=$(pcs status | grep Online: | awk -F : '{print $2}')

#backup mysql
echo 'Dumping...'
mysqldump --defaults-extra-file=/home/akkadianuser/.my_aco.cnf -u root fp > /home/akkadianuser/dbstosync/dbtosync.sql
#backup mongo
mongodump -u $MONGODBUSER -p $MONGODBPASSWORD --authenticationDatabase admin --db AcoServer -o /home/akkadianuser/dbstosync
echo 'compressing mongo file'
tar -zcvf /home/akkadianuser/dbstosync/mongotosync.tar.gz /home/akkadianuser/dbstosync/AcoServer/*

echo 'decrypting file'
gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_aco.gpg > /home/akkadianuser/.sshpass

IFS=$' '
echo "Database Synchronization source: $MASTER"
for j in $NODES
do
        if [[ ( "$j" != "[" ) && ( "$j" != "]" ) && ("$j" != "$MASTER") ]]
        then
                #copying files
                echo 'copying files to '$j
                sshpass -f /home/akkadianuser/.sshpass scp -o StrictHostKeyChecking=no /home/akkadianuser/dbstosync/dbtosync.sql root@$j:/home/akkadianuser/dbstosync/dbtosync.sql
                sshpass -f /home/akkadianuser/.sshpass scp -o StrictHostKeyChecking=no /home/akkadianuser/dbstosync/mongotosync.tar.gz root@$j:/home/akkadianuser/dbstosync/mongotosync.tar.gz

                echo 'stopping services in '$j
                #stopping services
                sshpass -f /home/akkadianuser/.sshpass ssh -o StrictHostKeyChecking=no root@$j 'systemctl stop tomcat'
                sshpass -f /home/akkadianuser/.sshpass ssh -o StrictHostKeyChecking=no root@$j 'systemctl stop aco-server'

                echo 'Restoring dbs in '$j
                #restore mysql
                sshpass -f /home/akkadianuser/.sshpass ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my_aco.cnf -u root -e "drop database fp"'
                sshpass -f /home/akkadianuser/.sshpass ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my_aco.cnf -u root -e "create database fp"'
                sshpass -f /home/akkadianuser/.sshpass ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my_aco.cnf -u root fp < /home/akkadianuser/dbstosync/dbtosync.sql'

                #restore mongo
                sshpass -f /home/akkadianuser/.sshpass ssh -o StrictHostKeyChecking=no root@$j 'tar -zxvf /home/akkadianuser/dbstosync/mongotosync.tar.gz -C /home/akkadianuser/dbstosync/ --strip-components=3'
                sshpass -f /home/akkadianuser/.sshpass ssh -o StrictHostKeyChecking=no root@$j 'mongo -u $MONGODBUSER -p $MONGODBPASSWORD --authenticationDatabase admin AcoServer --eval "db.dropDatabase()"'
                sshpass -f /home/akkadianuser/.sshpass ssh -o StrictHostKeyChecking=no root@$j 'mongo -u $MONGODBUSER -p $MONGODBPASSWORD --authenticationDatabase admin AcoServer --eval "db.createCollection('AcoServer')"'
                sshpass -f /home/akkadianuser/.sshpass ssh -o StrictHostKeyChecking=no root@$j 'mongorestore -u $MONGODBUSER -p $MONGODBPASSWORD --authenticationDatabase admin --db AcoServer /home/akkadianuser/dbstosync/AcoServer'


                echo 'Restart services in '$j
                sshpass -f /home/akkadianuser/.sshpass ssh -o StrictHostKeyChecking=no root@$j 'systemctl start aco-server'
                sshpass -f /home/akkadianuser/.sshpass ssh -o StrictHostKeyChecking=no root@$j 'systemctl start tomcat'
        fi
done

truncate -s 0 /home/akkadianuser/.sshpass
echo "Synchronizing Database Completed"
echo "$(date) $(ls -1 | wc -l)" > /home/akkadianuser/sync_end_at_log