#!/usr/bin/env bash

# aCO SERVER CERTIFICATES updater script
#
# parameter:
#           * url where to get the file server_certificates.tar.gz
#           * md5 code


wget $1 -O '/opt/akkadian/data/tmp/server_certificates.tar.gz'

check=$(awk -F ': ' '{print $2}' <<< $(md5sum -c <<< "$2 /opt/akkadian/data/tmp/server_certificates.tar.gz"))
if [ "$check" != "OK" ]; then
    echo "ERROR: no properly formatted MD5 checksum lines found"; exit;
fi

tar -xvzf /opt/akkadian/data/tmp/server_certificates.tar.gz -C /opt/akkadian/data/tmp/

if [[ ! -e /opt/akkadian/data/tmp/aco-server.crt ]]; then
    echo "ERROR: Couldn't download server certificates!"; exit;
fi

if [[ ! -e /opt/akkadian/data/tmp/aco-server.key ]]; then
    echo "ERROR: Couldn't download server certificates!"; exit;
fi

sh scripts/stop_kestrel.sh
sh scripts/stop_tomcat.sh
sh scripts/stop_nginx.sh

cp /opt/akkadian/data/tmp/aco-server.crt /opt/akkadian/aco-server/certificates/
cp /opt/akkadian/data/tmp/aco-server.key /opt/akkadian/aco-server/certificates/

sh scripts/start_kestrel.sh
sh scripts/start_tomcat.sh
sh scripts/start_nginx.sh
