#!/usr/bin/env bash
sudo crontab -u akkadianuser -l | grep -v '/home/akkadianuser/scripts/sync_dbs.sh'  | crontab -u akkadianuser -

echo "Updating crontab in other nodes..."
NODES=$(pcs status | grep Online: | awk -F : '{print $2}')
MY_HOSTNAME=$(sudo hostname)

if [[ -d /opt/akkadian/aco-server ]]; then
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_aco.gpg > /home/akkadianuser/.sshpass
else
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_pme_cm.gpg > /home/akkadianuser/.sshpass
fi

IFS=$' '
for j in $NODES
do
        if [[ ( "$j" != "[" ) && ( "$j" != "]" ) && ("$j" != "$MY_HOSTNAME") ]]
        then
            echo "Updating Node: $j"
            sshpass -f /home/akkadianuser/.sshpass ssh -o StrictHostKeyChecking=no root@$j "sudo crontab -u akkadianuser -l | grep -v '/home/akkadianuser/scripts/sync_dbs.sh'  | crontab -u akkadianuser -"
        fi
done

truncate -s 0 /home/akkadianuser/.sshpass