#!/usr/bin/env bash
ran=$(( ( RANDOM % 100 )  + 1 ))
if [[ -d /opt/akkadian/aco-server ]]; then
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_aco.gpg > /home/akkadianuser/.sshpass_$ran
else
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_pme_cm.gpg > /home/akkadianuser/.sshpass_$ran
fi


pcsd_status=$(pcs status 2>&1)
if [[ "$pcsd_status" != "Error: cluster is not currently running on this node" ]]
then
    NODES=$(sudo pcs status | grep Online: | awk -F : '{print $2}')
else
    NODES=$(head -n 1 /home/akkadianuser/load_balancer.config)
fi

IFS=$' '
for j in $NODES
do
    if [[ ( "$j" != "[" ) && ( "$j" != "]" ) ]]
    then
        #remove in master

        sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo crontab -u akkadianuser -l | grep -v '/home/akkadianuser/scripts/master_replication.sh'  | crontab -u akkadianuser -"
        sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo crontab -u akkadianuser -l | grep -v '/home/akkadianuser/scripts/ha_getmasterdb_toslave.sh'  | crontab -u akkadianuser -"
        sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "truncate -s 0 /home/akkadianuser/master"

        sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "systemctl enable supervisord"
        sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "systemctl start supervisord"
    fi
done

sudo rm -Rf /home/akkadianuser/.sshpass_$ran