#!/usr/bin/env bash
ran=$(( ( RANDOM % 100 )  + 1 ))
if [[ -d /opt/akkadian/aco-server ]]; then
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_aco.gpg > /home/akkadianuser/.sshpass_$ran
else
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_pme_cm.gpg > /home/akkadianuser/.sshpass_$ran
fi

pcsd_status=$(pcs status 2>&1)
if [[ "$pcsd_status" != "Error: cluster is not currently running on this node" ]]
then
    NODES=$(sudo pcs status | grep Online: | awk -F : '{print $2}')
else
    NODES=$(head -n 1 /home/akkadianuser/load_balancer.config)
fi

IFS=$' '
for j in $NODES
do
    if [[ ( "$j" != "[" ) && ( "$j" != "]" ) ]]
    then

        sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "STOP SLAVE;"'
        sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "RESET SLAVE;"'

        sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'sudo cp -Rf /home/akkadianuser/my-original.cnf /etc/my.cnf'
        sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'firewall-cmd --zone=public --remove-port=3306/tcp'
        sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'firewall-cmd --runtime-to-permanent'
        sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'firewall-cmd --reload'

        sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'sudo systemctl restart mariadb'
        sleep 5
        sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'sudo rm -Rf /home/akkadianuser/load_balancer.config'
    fi
done

sudo rm -Rf /home/akkadianuser/.sshpass_$ran