#!/usr/bin/env bash

NODES=$(pcs status | grep Online: | awk -F : '{print $2}')


if [[ -d /opt/akkadian/aco-server ]]; then
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_aco.gpg > /home/akkadianuser/.sshpass
else
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_pme_cm.gpg > /home/akkadianuser/.sshpass
fi

for j in $NODES
do
    if [[ ( "$j" != "[" ) && ( "$j" != "]" )  ]]; then
        sshpass -f /home/akkadianuser/.sshpass ssh -o StrictHostKeyChecking=no root@$j "sudo pcs cluster kill"
        sshpass -f /home/akkadianuser/.sshpass ssh -o StrictHostKeyChecking=no root@$j "sudo pcs cluster destroy"
    fi
done

truncate -s 0 /home/akkadianuser/.sshpass
