#   PME installer scrip
#   parameters:
#           number of current release
#           number of the previous release (release to backup)
#           path and name of the zip installer file


#!/bin/bash
#paramas current release version

old_release=$1

current_tmp_release_folder=/home/akkadianuser/tmp/pme_installation
current_release_zip_name=`echo $2 | sed -r "s/\x1B\[([0-9]{1,3}((;[0-9]{1,3})*)?)?[m|K]//g"`;

backup_directory=/home/backups/pme
backup_release_directory=$backup_directory"/"$old_release

if [ ! -e $backup_directory ]
then
    mkdir $backup_directory
fi

if [ ! -e $backup_release_directory ]
then
    mkdir $backup_release_directory
fi

if [ -e $current_tmp_release_folder ]
then
    rm -Rf $current_tmp_release_folder
fi

if [ ! -e $current_tmp_release_folder ]
then
    mkdir $current_tmp_release_folder
fi


#taking db backups
mysqldump --defaults-extra-file=/home/akkadianuser/.my.cnf -u root pme > $backup_release_directory/$old_release".sql"

#taking pme backups
echo 'making pme software backup...'
sudo tar -zcf $backup_release_directory/$old_release".tar.gz" -C / var/www/html/pme


#Do we need to download the file?
if [[ ( $current_release_zip_name == "http"* ) || ( $current_release_zip_name == "ftp"* ) ]]
then
    echo 'getting external file'
    sudo wget $current_release_zip_name -P $current_tmp_release_folder/
    echo 'unzipping current file'
    sudo unzip $current_tmp_release_folder/$(basename $current_release_zip_name) -d $current_tmp_release_folder/

else
    echo $current_release_zip_name
    sudo cp -Rf $current_release_zip_name $current_tmp_release_folder
    sudo unzip -qo $current_tmp_release_folder/$(basename $current_release_zip_name) -d $current_tmp_release_folder/
fi

sudo yes | cp -rf $current_tmp_release_folder/PME/* /var/www/html/pme/

sudo php /var/www/html/pme/migrations.php