#!/usr/bin/env bash

COUNTER=0
while [  $COUNTER -lt 1 ]; do
    pcsd_status=$(systemctl is-active --quiet pcsd && echo Service is running)
    pacemaker_status=$(systemctl is-active --quiet pacemaker && echo Service is running)
    corosync_status=$(systemctl is-active --quiet corosync && echo Service is running)

    if [[ "$pcsd_status" == "Service is running" && "$pacemaker_status" == "Service is running" && "$corosync_status" == "Service is running" ]]; then
        let COUNTER=COUNTER+1
    fi
    sleep 1
done

MASTER=$(sudo pcs status | grep RS_VIP_Akkadian | awk -F ' ' '{print $4}')
NODES=$(sudo pcs status | grep Online: | awk -F : '{print $2}')
hostname=$(sudo hostname)

ran=$(( ( RANDOM % 100 )  + 1 ))
gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_aco.gpg > /home/akkadianuser/.sshpass_$ran


# Get MASTER db and replicate to all nodes, to start all at same point
# checksum to see if the file is correctly passed into slaves.
# no matter who is master, just ensure db is same in all slaves.

sudo rm -Rf /opt/akkadian/data/restore/AcoServer
sudo rm -Rf acoServer_base.tar.gz
sudo mongodump -u mongoDBuser -p X46kTVmongo --authenticationDatabase admin --db AcoServer -o /opt/akkadian/data/restore/
sudo tar -zcvf /opt/akkadian/data/restore/acoServer_base.tar.gz -C /opt/akkadian/data/restore/AcoServer/ .

nodes_len=0
initialization_string=""
IFS=$' '
for j in $NODES
    do
        if [[ ( "$j" != "[" ) && ( "$j" != "]" ) ]]
        then
            nodes_len=$(($nodes_len+1))
            echo "processing start configs for: $j"

            #Ensuring slaves have always same data
            if [[ "$j" != "$hostname" ]]
            then
                sshpass -f /home/akkadianuser/.sshpass_$ran scp -o StrictHostKeyChecking=no /opt/akkadian/data/restore/acoServer_base.tar.gz root@$j:/opt/akkadian/data/restore/acoServer_base.tar.gz
                sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo rm -Rf /opt/akkadian/data/restore/AcoServer"
                sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo mkdir /opt/akkadian/data/restore/AcoServer"
                sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "tar -zxvf /opt/akkadian/data/restore/acoServer_base.tar.gz -C /opt/akkadian/data/restore/AcoServer"
                sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sh /opt/akkadian/aco-server/scripts/mongoacorestore.sh"
            fi
            sleep 5

            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo systemctl stop mongodb"
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo echo replicapass > /opt/akkadian/data/mongokey "
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo chmod 600 /opt/akkadian/data/mongokey "
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo cp -Rf /home/akkadianuser/scripts/mongo_replica_scripts/start-mongo-replica.sh /opt/akkadian/aco-server/scripts/start-mongodb.sh"
            sleep 5
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo systemctl start mongodb"
            sleep 10

            if [[ "$initialization_string" == "" ]]
            then
                initialization_string=$j
            else
                initialization_string="$initialization_string,$j"
            fi
        fi
done

echo "Waiting mongo starts..."
sleep 5

echo "initiate master node: $MASTER running "
sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$MASTER 'date' >> /home/akkadianuser/mongo_replica.log
sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$MASTER 'mongo admin -u mongoDBuser -p X46kTVmongo --eval "rs.initiate()"' >> /home/akkadianuser/mongo_replica.log
IFS=$' '
for j in $NODES
    do
        if [[ ( "$j" != "[" ) && ( "$j" != "]" ) ]]
        then
            echo "processing string for $j"

            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo echo '$j' > /opt/akkadian/data/replica"
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo chmod 666 /opt/akkadian/data/replica"

            tmp=$j
            if [[ "$MASTER" != "$j" ]]
            then
                echo "adding node: $j"
                j="\"$j\""
                sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$MASTER "mongo admin -u mongoDBuser -p X46kTVmongo --eval 'rs.add($j)'"  >> /home/akkadianuser/mongo_replica.log
            fi
            echo "restarting aco-server in $j"
            sleep 15
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$tmp "sudo systemctl restart aco-server"
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$tmp "sudo systemctl restart tomcat"
            sleep 2
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$tmp "sudo echo '$MASTER' > /home/akkadianuser/master"
        fi
done

sudo rm -Rf /home/akkadianuser/.sshpass_$ran