#!/usr/bin/env bash

COUNTER=0
while [  $COUNTER -lt 1 ]; do
    pcsd_status=$(systemctl is-active --quiet pcsd && echo Service is running)
    pacemaker_status=$(systemctl is-active --quiet pacemaker && echo Service is running)
    corosync_status=$(systemctl is-active --quiet corosync && echo Service is running)

    if [[ "$pcsd_status" == "Service is running" && "$pacemaker_status" == "Service is running" && "$corosync_status" == "Service is running" ]]; then
        let COUNTER=COUNTER+1
    fi
    sleep 1
done


NODES=$(sudo pcs status | grep Online: | awk -F : '{print $2}')
MASTER=$(sudo pcs status | grep RS_VIP_Akkadian | awk -F ' ' '{print $4}')
MY_HOSTNAME=$(sudo hostname)
old_master=$(cat /home/akkadianuser/master)
ran=$(( ( RANDOM % 100 )  + 1 ))

if [[ -d /opt/akkadian/aco-server ]]; then
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_aco.gpg > /home/akkadianuser/.sshpass_$ran
else
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_pme_cm.gpg > /home/akkadianuser/.sshpass_$ran
fi
IFS=$' '

#ensure the change between replication is when there are more than 1 up and running
nodes_len=0
for j in $NODES
    do
        if [[ ( "$j" != "[" ) && ( "$j" != "]" ) ]]
        then
            nodes_len=$(($nodes_len+1))
        fi
done

i=2
echo "$MASTER, $MY_HOSTNAME, $old_master,$nodes_len,$inactivity_flag"

# if I'm master and I don't have the configs:
file="/etc/my.cnf"
ismycnfconfiguredasmaster=$(grep -q "log-basename" $file; [ $? -eq 0 ] && echo "yes" || echo "no")


# enabling/ disabling supervisord
if [[ "$MASTER" == "$MY_HOSTNAME" ]]; then
    sudo systemctl enable supervisord

    for j in $NODES
    do
        if [[ ( "$j" != "[" ) && ( "$j" != "]" ) && ("$j" != "$MASTER") ]]
        then
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "systemctl disable supervisord"
        fi
    done
fi

if [[ "$MASTER" == "$MY_HOSTNAME" && "$ismycnfconfiguredasmaster" == "no" && $nodes_len>1 ]]; then
    #echo "$MASTER" > /home/akkadianuser/master

    if [[ -d /var/www/html/pme ]]; then
        yes | sudo cp -rf /home/akkadianuser/my-master-pm.cnf /etc/my.cnf
    fi
    if [[ -d /var/www/html/acm ]]; then
        yes | sudo cp -rf /home/akkadianuser/my-master-cm.cnf /etc/my.cnf
    fi

    echo "Restarting mariadb"
    sudo systemctl restart mariadb

    echo "Running mysql needed commands on master"
    mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "STOP SLAVE;"
    mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "RESET SLAVE;"
    mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "RESET MASTER;"
    mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "GRANT REPLICATION SLAVE ON *.* TO 'sk'@'%' IDENTIFIED BY 'centos';"
    mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "FLUSH PRIVILEGES;"
    mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "FLUSH TABLES WITH READ LOCK;"

    echo "Getting sync information on master"
    file=$(mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -ANe "SHOW MASTER STATUS;" | awk '{print $1}')
    pos=$(mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -ANe "SHOW MASTER STATUS;" | awk '{print $2}')

    echo "Dumping db"
    mysqldump --defaults-extra-file=/home/akkadianuser/.my.cnf --all-databases  --master-data --events > /home/akkadianuser/masterdatabase.sql

    echo "unlocking tables"
    mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "UNLOCK TABLES;"

    for j in $NODES
    do
        if [[ ( "$j" != "[" ) && ( "$j" != "]" ) && ("$j" != "$MASTER") ]]
        then
            #sshpass -f /home/akkadianuser/.sshpass ssh -o StrictHostKeyChecking=no root@$j "echo "$MASTER" > /home/akkadianuser/master"

            server_id=$(echo "server_id=$i")
            if [[ -d /var/www/html/pme ]]; then
                sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sed -i '/^server_id/d' /home/akkadianuser/my-slave-pm.cnf"
                sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sed -i '/\[mysqld\]/a server_id=$i' /home/akkadianuser/my-slave-pm.cnf"
                sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "yes | cp -rf /home/akkadianuser/my-slave-pm.cnf /etc/my.cnf"
            fi
            if [[ -d /var/www/html/acm ]]; then
                sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sed -i '/^server_id/d' /home/akkadianuser/my-slave-cm.cnf"
                sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sed -i '/\[mysqld\]/a server_id=$i' /home/akkadianuser/my-slave-cm.cnf"
                sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "yes | cp -rf /home/akkadianuser/my-slave-cm.cnf /etc/my.cnf"
            fi

            echo "Restarting mariadb"
            sudo systemctl restart mariadb

            sshpass -f /home/akkadianuser/.sshpass_$ran scp -o StrictHostKeyChecking=no /home/akkadianuser/masterdatabase.sql root@$j:/home/akkadianuser/dbstosync/masterdatabase.sql

            sleep 3

            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "STOP SLAVE;"'
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "RESET SLAVE;"'
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "RESET MASTER;"'
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root < /home/akkadianuser/dbstosync/masterdatabase.sql'

            sleep 10
            echo "Restarting mariadb"
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'systemctl restart mariadb'

            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "STOP SLAVE;"'
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "RESET SLAVE;"'
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "RESET MASTER;"'
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "CHANGE MASTER TO MASTER_HOST='\'$MASTER\'', MASTER_USER='\'sk\', MASTER_PASSWORD=\'centos\', MASTER_LOG_FILE=''\'$file\'', MASTER_LOG_POS='$pos';"'
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "START SLAVE;"'
        fi
        i=$((i+1))
    done
fi

#Ultra defensive approach, check and try almost everything to get replication back up.
#&& "$inactivity_flag" == "True"
ismycnfconfiguredasmaster=$(grep -q "log-basename" $file; [ $? -eq 0 ] && echo "yes" || echo "no")
if [[ "$MASTER" == "$MY_HOSTNAME" && "$ismycnfconfiguredasmaster" == "yes" && $nodes_len>1 ]]; then
    echo "Getting sync information on master"
    file=$(mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -ANe "SHOW MASTER STATUS;" | awk '{print $1}')
    pos=$(mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -ANe "SHOW MASTER STATUS;" | awk '{print $2}')

    for j in $NODES
    do
        if [[ ( "$j" != "[" ) && ( "$j" != "]" ) && ("$j" != "$MASTER") ]]
        then
            slave_running=$(sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "SHOW SLAVE STATUS\G;" | grep 'Slave_IO_Running'')
            if [[ "$slave_running" != "Slave_IO_Running: Yes" ]]; then
               sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "STOP SLAVE;"'
               sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "RESET SLAVE;"'
               sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "RESET MASTER;"'
               sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "CHANGE MASTER TO MASTER_HOST='\'$MASTER\'', MASTER_USER='\'sk\', MASTER_PASSWORD=\'centos\', MASTER_LOG_FILE=''\'$file\'', MASTER_LOG_POS='$pos';"'
               sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "START SLAVE;"'
            fi
            sleep 10
            slave_running=$(sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "SHOW SLAVE STATUS\G;" | grep 'Slave_IO_Running'')
            if [[ "$slave_running" != "Slave_IO_Running: Yes" ]]; then
               sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'systemctl restart mariadb'
            fi
        fi
    done
    sleep 10
    must_restart="False"
    for j in $NODES
    do
        if [[ ( "$j" != "[" ) && ( "$j" != "]" ) && ("$j" != "$MASTER") ]]
        then
            slave_running=$(sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "SHOW SLAVE STATUS\G;" | grep 'Slave_IO_Running'')

            if [[ "$slave_running" != "Slave_IO_Running: Yes" ]]; then
               sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'systemctl restart mariadb'
               must_restart="True"
            fi
        fi
    done
    if [[ "$must_restart" != "True" ]]; then
        sudo systemctl restart mariadb
    fi
fi

# wait for 2 minutes until changes effectively
#inactivity_flag=$(sudo sh /home/akkadianuser/scripts/inactivity_match.sh)


truncate -s 0 /home/akkadianuser/.sshpass_$ran
sudo rm -Rf /home/akkadianuser/.sshpass_$ran