#!/usr/bin/env bash

ran=$(( ( RANDOM % 100 )  + 1 ))
if [[ -d /opt/akkadian/aco-server ]]; then
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_aco.gpg > /home/akkadianuser/.sshpass_$ran
else
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_pme_cm.gpg > /home/akkadianuser/.sshpass_$ran
fi

if [[ -d /var/www/html/pme ]]; then
    tar --exclude='var/www/html/pme/application/licenses' -zcvf /home/akkadianuser/package.tar.gz /var/www/html/*
fi
if [[ -d /var/www/html/acm ]]; then
    tar --exclude='var/www/html/acm/application/licenses' -zcvf /home/akkadianuser/package.tar.gz /var/www/html/*
fi

mysqldump --defaults-extra-file=/home/akkadianuser/.my.cnf --all-databases > /home/akkadianuser/masterdatabasetoslave.sql

IFS=$' '
for j in $1
    do
        #Pushing Software
        sshpass -f /home/akkadianuser/.sshpass_$ran scp -o StrictHostKeyChecking=no /home/akkadianuser/package.tar.gz root@$j:/home/akkadianuser/package.tar.gz
        sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'sudo tar -xzvf /home/akkadianuser/package.tar.gz -C /'
        sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'sudo rm -rf /home/akkadianuser/package.tar.gz'
        sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'sudo echo $current_version > /home/akkadianuser/version'

        #Pushing DB
        sshpass -f /home/akkadianuser/.sshpass_$ran scp -o StrictHostKeyChecking=no /home/akkadianuser/masterdatabasetoslave.sql root@$j:/home/akkadianuser/masterdatabasetoslave.sql
        sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root < /home/akkadianuser/masterdatabasetoslave.sql'
        sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'sudo rm -rf /home/akkadianuser/masterdatabasetoslave.sql'

        sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'systemctl restart mariadb'
        sleep 3
        sudo rm -rf /home/akkadianuser/masterdatabasetoslave.sql

done

sudo rm -Rf .sshpass_$ran