#!/usr/bin/env bash

BUNDLE_INSTALLER_VERSION=1.0
AKKADIAN_SCRIPT_LIB_PATH="/home/akkadianuser/scripts"

BUNDLE_PATH=$1
APP_DIRECTORY=$2
APP_GIT_CMD="git --work-tree=$APP_DIRECTORY --git-dir=$APP_DIRECTORY/.git"

#Run this before any failures/exits regardless of the dir existing
#Remove origin to prevent someone from manually doing a fetch and messing things up
echo "Removing remote origin..."
$APP_GIT_CMD remote rm origin
    
#Verify bundle
$APP_GIT_CMD bundle verify "$BUNDLE_PATH"
if [[ $? != 0 ]]
then
    echo "Unable to verify bundle.";
    exit 1;
fi

#Create and init directory if it does not exist
if [[ ! -d "$APP_DIRECTORY/.git" ]]
then
    git init $APP_DIRECTORY
    INSTALLED_RELEASE_VERSION_FULL_TAG='0.0.0.0'

else
    #Get current local version
    INSTALLED_RELEASE_VERSION_FULL_TAG=$($APP_GIT_CMD describe --tags --exact-match)
fi

#Remove the branch prefix: turn release/1.0.26.1 to 1.0.26.1
INSTALLED_RELEASE_VERSION=$(basename "$INSTALLED_RELEASE_VERSION_FULL_TAG")

#Get update file version from bundle file (release/x.x.x.x)
UPDATE_RELEASE_VERSION_FULL_TAG=$($AKKADIAN_SCRIPT_LIB_PATH/getBundleUpdateVersion.sh "$BUNDLE_PATH")

#Remove the branch prefix: turn release/1.0.26.1 to 1.0.26.1
UPDATE_RELEASE_VERSION=$(basename "$UPDATE_RELEASE_VERSION_FULL_TAG")

if [[ ! $INSTALLED_RELEASE_VERSION ]]
then
    echo "Unable to detect installed version.";
    exit 1;
fi

if [[ ! $UPDATE_RELEASE_VERSION ]]
then
    echo "Unable to detect update version.";
    exit 1;
fi

echo "Installed version: ${INSTALLED_RELEASE_VERSION}"
echo "Update version: ${UPDATE_RELEASE_VERSION}"

#Abort if update version <= current installed version
HIGHEST_VERSION=$($AKKADIAN_SCRIPT_LIB_PATH/findHighestVersion.sh $UPDATE_RELEASE_VERSION $INSTALLED_RELEASE_VERSION)

if [[ $UPDATE_RELEASE_VERSION == $INSTALLED_RELEASE_VERSION || $HIGHEST_VERSION != $UPDATE_RELEASE_VERSION ]]
then
    echo "There is no update available."
    exit 1
fi

echo "$(basename $APP_DIRECTORY),$(date),${INSTALLED_RELEASE_VERSION},${UPDATE_RELEASE_VERSION}" >> /var/www/product_update/installation_history.csv

# Delete all tags except current tag
echo "Cleaning up old tags..."
$APP_GIT_CMD tag -d $($APP_GIT_CMD tag -l | grep -v "^$INSTALLED_RELEASE_VERSION_FULL_TAG\$")
        
#Unbundle
echo "Unbundling..."
$APP_GIT_CMD bundle unbundle "$BUNDLE_PATH"
$APP_GIT_CMD fetch --no-tags -f "$BUNDLE_PATH" "refs/tags/$UPDATE_RELEASE_VERSION_FULL_TAG:refs/tags/$UPDATE_RELEASE_VERSION_FULL_TAG"

#Checking out release update
echo "Checking out version..."
$APP_GIT_CMD checkout -f "$UPDATE_RELEASE_VERSION_FULL_TAG"

#Make sure we don't count permission differences as a change in git
echo "Updating file mode..."
$APP_GIT_CMD config core.fileMode false