#!/usr/bin/env bash

COUNTER=0
while [  $COUNTER -lt 1 ]; do
    pcsd_status=$(systemctl is-active --quiet pcsd && echo Service is running)
    pacemaker_status=$(systemctl is-active --quiet pacemaker && echo Service is running)
    corosync_status=$(systemctl is-active --quiet corosync && echo Service is running)

    if [[ "$pcsd_status" == "Service is running" && "$pacemaker_status" == "Service is running" && "$corosync_status" == "Service is running" ]]; then
        let COUNTER=COUNTER+1
    fi
    sleep 1
done

NODES=$(sudo pcs status | grep Online: | awk -F : '{print $2}')
MASTER=$(sudo pcs status | grep RS_VIP_Akkadian | awk -F ' ' '{print $4}')
MY_HOSTNAME=$(sudo hostname)

if [[ -d /opt/akkadian/aco-server ]]; then
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_aco.gpg > /home/akkadianuser/.sshpass_for_slave
else
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_pme_cm.gpg > /home/akkadianuser/.sshpass_for_slave
fi
IFS=$' '

#ensure the change between replication is when there are more than 1 up and running
nodes_len=0
for j in $NODES
    do
        if [[ ( "$j" != "[" ) && ( "$j" != "]" ) ]]
        then
            nodes_len=$(($nodes_len+1))
        fi
done

if [[ "$MASTER" != "$MY_HOSTNAME" && $nodes_len>1 ]]; then
    sshpass -f /home/akkadianuser/.sshpass_for_slave ssh -o StrictHostKeyChecking=no root@$MASTER "mysqldump --defaults-extra-file=/home/akkadianuser/.my.cnf --all-databases > /home/akkadianuser/masterdatabasetoslave.sql"
    sshpass -f /home/akkadianuser/.sshpass_for_slave scp -o StrictHostKeyChecking=no root@$MASTER:/home/akkadianuser/masterdatabasetoslave.sql /home/akkadianuser/masterdatabasetoslave.sql
    sudo mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root < /home/akkadianuser/masterdatabasetoslave.sql
    sudo rm -Rf /home/akkadianuser/masterdatabasetoslave.sql
    sudo systemctl disable supervisord

    #Taking software if needed
    if [[ -d /var/www/html/pme ]]; then
        version=$(grep -w 'version' /var/www/html/pme/application/config/pme.php | awk '{print $3}' | tr -d "'" | tr -d ",")
        build=$(grep -w 'build_number' /var/www/html/pme/application/config/pme.php | awk '{print $3}' | tr -d "'" | tr -d ",")

        current_version=$(echo "$version-$build")

        master_version=$(sshpass -f /home/akkadianuser/.sshpass_for_slave ssh -o StrictHostKeyChecking=no root@$MASTER "./home/akkadianuser/scripts/get_PME_version.sh")
    fi
    if [[ -d /var/www/html/acm ]]; then
        current_version=$(grep -w 'version' /var/www/html/acm/application/config/gd.php | awk '{print $3}' | tr -d "'" | tr -d ",")
        master_version=$(sshpass -f /home/akkadianuser/.sshpass_for_slave ssh -o StrictHostKeyChecking=no root@$MASTER "./home/akkadianuser/scripts/get_CM_version.sh")
    fi

    echo "$current_version != $master_version"

    if [[ "$current_version" != "$master_version" ]]; then
        if [[ -d /var/www/html/pme ]]; then
            sshpass -f /home/akkadianuser/.sshpass_for_slave ssh -o StrictHostKeyChecking=no root@$MASTER "tar --exclude='var/www/html/pme/application/licenses' -zcvf /home/akkadianuser/package.tar.gz /var/www/html/*"
        fi
        if [[ -d /var/www/html/acm ]]; then
            sshpass -f /home/akkadianuser/.sshpass_for_slave ssh -o StrictHostKeyChecking=no root@$MASTER "tar --exclude='var/www/html/acm/application/licenses' -zcvf /home/akkadianuser/package.tar.gz /var/www/html/*"
        fi


        sshpass -f /home/akkadianuser/.sshpass_for_slave scp -o StrictHostKeyChecking=no root@$MASTER:/home/akkadianuser/package.tar.gz /home/akkadianuser/package.tar.gz
        sudo tar -xzvf /home/akkadianuser/package.tar.gz -C /
        sudo rm -rf /home/akkadianuser/package.tar.gz
        sudo echo $current_version > /home/akkadianuser/version
    fi

fi

truncate -s 0 /home/akkadianuser/.sshpass_for_slave
sudo -Rf /home/akkadianuser/.sshpass_for_slave