#!/usr/bin/env bash

ran=$(( ( RANDOM % 100 )  + 1 ))

function finish {
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_aco.gpg > /home/akkadianuser/.sshpass_$ran

    second=""
    for j in $NODES
        do
            if [[ ( "$j" != "[" ) && ( "$j" != "]" ) ]]
            then
                nodes_len=$(($nodes_len+1))
                if [[ "$j" != "$MY_HOSTNAME" ]]; then
                    second=$j
                fi
            fi
    done

    echo "Cleaning lock" >> /home/akkadianuser/cli.log
    sudo rm -Rf /home/akkadianuser/mongo_recovery.lock

    sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second "sudo rm -Rf /home/akkadianuser/mongo_recovery.lock"
}

COUNTER=0
while [  $COUNTER -lt 1 ]; do
    pcsd_status=$(systemctl is-active --quiet pcsd && echo Service is running)
    pacemaker_status=$(systemctl is-active --quiet pacemaker && echo Service is running)
    corosync_status=$(systemctl is-active --quiet corosync && echo Service is running)

    if [[ "$pcsd_status" == "Service is running" && "$pacemaker_status" == "Service is running" && "$corosync_status" == "Service is running" ]]; then
        let COUNTER=COUNTER+1
    fi
    sleep 1
done

NODES=$(sudo pcs status | grep Online: | awk -F : '{print $2}')
MASTER=$(sudo pcs status | grep RS_VIP_Akkadian | awk -F ' ' '{print $4}')
MY_HOSTNAME=$(sudo hostname)
old_master=$(cat /home/akkadianuser/master)


if [[ -d /opt/akkadian/aco-server ]]; then
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_aco.gpg > /home/akkadianuser/.sshpass_$ran
else
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_pme_cm.gpg > /home/akkadianuser/.sshpass_$ran
fi
IFS=$' '

#ensure the change between replication is when there are more than 1 up and running
nodes_len=0
i=2
#initialization_string=""
second=""
for j in $NODES
    do
        if [[ ( "$j" != "[" ) && ( "$j" != "]" ) ]]
        then
            nodes_len=$(($nodes_len+1))
            if [[ "$j" != "$MY_HOSTNAME" ]]; then
                second=$j
            fi
        fi
done

recovering=$(sh /home/akkadianuser/scripts/ha_aco/is_recovering.sh)
recovering_second=$(sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second "sh /home/akkadianuser/scripts/ha_aco/is_recovering.sh")

echo "recovering: $recovering" >> /home/akkadianuser/cli.log
echo "recovering_second: $recovering_second" >> /home/akkadianuser/cli.log

echo "nodes: $NODES" >> /home/akkadianuser/cli.log

if [[ ("$recovering" != "yes") && ("$recovering_second" != "yes") ]]; then
    set -C; 2>/dev/null >/home/akkadianuser/mongo_recovery.lock
    sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second "set -C; 2>/dev/null >/home/akkadianuser/mongo_recovery.lock"
    trap finish EXIT
    echo "Setting trap" >> /home/akkadianuser/cli.log
elif [[ nodes_len -eq 1 ]]; then
    sudo rm -Rf /home/akkadianuser/mongo_recovery.lock
else
    echo "Lock file exists… exiting" >> /home/akkadianuser/cli.log
    exit
fi


echo "##### start processing heartbeat actions #####" >> /home/akkadianuser/cli.log
aco_version=$(cat /opt/akkadian/aco-server/wwwroot/version.js)

date >> /home/akkadianuser/cli.log
echo "node len: $nodes_len" >> /home/akkadianuser/cli.log

startMongoWithReplicaConfigs=$(sh /home/akkadianuser/scripts/ha_aco/mongo_replica_status_in_config_file.sh)
isReplicaRunning=$(sh /home/akkadianuser/scripts/ha_aco/mongo_replica_status.sh)
remote_mongo_status=$(sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second "/home/akkadianuser/scripts/ha_aco/mongo_replica_status.sh")

echo "is replica running: $isReplicaRunning" >> /home/akkadianuser/cli.log
echo "replica config are in file: $startMongoWithReplicaConfigs" >> /home/akkadianuser/cli.log
echo "node list: $nodes_len" >> /home/akkadianuser/cli.log
echo "Remote mongo status is: $remote_mongo_status" >> /home/akkadianuser/cli.log



if [[ $nodes_len > 1 && "$startMongoWithReplicaConfigs" = "yes" && "$isReplicaRunning" = "no" ]]; then

    echo "replica config set, mongo not running" >> /home/akkadianuser/cli.log
    isNecessaryRm="False"
    the_other=""
    for j in $NODES
    do
        if [[ ( "$j" != "[" ) && ( "$j" != "]" ) && ("$j" != "$MY_HOSTNAME") && "$isNecessaryRm" = "False" ]]
        then
            echo "Trying to connect to $j" >> /home/akkadianuser/cli.log
            remote_mongo_status_config=$(sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "/home/akkadianuser/scripts/ha_aco/mongo_replica_status_in_config_file.sh")
            remote_mongo_status=$(sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "/home/akkadianuser/scripts/ha_aco/mongo_replica_status.sh")

            echo "remote_mongo_status_config: $remote_mongo_status_config" >> /home/akkadianuser/cli.log
            echo "remote_mongo_status: $remote_mongo_status" >> /home/akkadianuser/cli.log

            if [[ ("$remote_mongo_status_config" == "yes") && ("$remote_mongo_status" == "yes") ]]; then
                echo "Inside the if that enables the removing" >> /home/akkadianuser/cli.log
                isNecessaryRm="True"
                the_other=$j
            elif [[ ("$remote_mongo_status_config" == "yes") && ("$remote_mongo_status" == "no") ]]; then
                #means Other side is down also. So set this to standalone to start recovery
                echo "Reverting configs to be standalone" >> /home/akkadianuser/cli.log
                sudo systemctl stop mongodb
                sleep 5
                sudo cp -Rf /home/akkadianuser/scripts/mongo_replica_scripts/start-mongo.sh /opt/akkadian/aco-server/scripts/start-mongodb.sh
                echo "starting mongo without replication"
                sudo systemctl start mongodb
                sleep 10
                sudo truncate -s 0 /opt/akkadian/data/replica

                sudo systemctl restart aco-server
                sudo systemctl restart tomcat
            fi
        fi
    done

    if [[ "$isNecessaryRm" == "True" ]]; then

        echo "Removing local folder so it get latest data" >> /home/akkadianuser/cli.log
        sudo systemctl stop mongodb
        sleep 3
        sudo rm -Rf /opt/akkadian/data/db/*
        sleep 2
        sudo systemctl start mongodb
        sudo sh /home/akkadianuser/scripts/ha_aco/send_hostname_to_replica.sh
        sleep 2

        sudo systemctl restart aco-server
        sudo systemctl restart tomcat

    fi

#In fact I don't know if replication is down because user request
elif [[ $nodes_len > 1 && "$startMongoWithReplicaConfigs" = "no" ]]; then
    # This means we need to start mongo with replicaSet in it
    # configure all again???
    # sh /home/akkadianuser/scripts/mongo_replica_scripts/set_mongo_replication.sh

    echo "Reverting back standalone config, because both  nodes are up" >> /home/akkadianuser/cli.log
    isnecessarychange="True"
    #isnecessarychange="False"

    #for j in $NODES
    #do
    #    if [[ ( "$j" != "[" ) && ( "$j" != "]" ) && ("$j" != "$MY_HOSTNAME") && "$isnecessarychange" = "False" ]]
    #    then
    #        echo "Trying to connect to $j" >> /home/akkadianuser/cli.log
    #        remote_mongo_status_config=$(sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "/home/akkadianuser/scripts/ha_aco/mongo_replica_status_in_config_file.sh")

    #        echo "remote_mongo_status_config: $remote_mongo_status_config" >> /home/akkadianuser/cli.log

    #        if [[ "$remote_mongo_status_config" == "yes" ]]; then
    #            isnecessarychange="True"
    #            echo "it is needed to convert this into part of replica" >> /home/akkadianuser/cli.log
    #        fi
    #    fi
    #done

    #means the other node has replica configured => the configuration in this node was turned off by this script
    if [[ "$isnecessarychange" = "True" ]];
    then

        echo "converting this node into part of replica" >> /home/akkadianuser/cli.log
        echo "stopping mongo" >> /home/akkadianuser/cli.log
        sudo systemctl stop mongodb
        echo "copying mongo file" >> /home/akkadianuser/cli.log
        sudo cp -Rf /home/akkadianuser/scripts/mongo_replica_scripts/start-mongo-replica.sh /opt/akkadian/aco-server/scripts/start-mongodb.sh
        sleep 5
        echo "starting mongo" >> /home/akkadianuser/cli.log
        sudo systemctl start mongodb

        sleep 3
        echo "hostname into /opt/akkadian/data/replica" >> /home/akkadianuser/cli.log

        sudo sh /home/akkadianuser/scripts/ha_aco/send_hostname_to_replica.sh

        echo "Restarting aco-server" >> /home/akkadianuser/cli.log

        sudo systemctl restart aco-server
        sleep 3
        sudo systemctl restart tomcat

        #this was master, and the other side can have un-sync the folder
        sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second "rm -Rf /opt/akkadian/data/db/*"

    fi

elif [[ $nodes_len = 1 && "$startMongoWithReplicaConfigs" = "yes" ]]; then
    #revert every replica configuration in this node\

    echo "Reverting configs to be standalone" >> /home/akkadianuser/cli.log
    sudo systemctl stop mongodb
    sleep 5
    sudo cp -Rf /home/akkadianuser/scripts/mongo_replica_scripts/start-mongo.sh /opt/akkadian/aco-server/scripts/start-mongodb.sh
    echo "starting mongo without replication"
    sudo systemctl start mongodb
    sleep 10
    sudo truncate -s 0 /opt/akkadian/data/replica

    sudo systemctl restart aco-server
    sudo systemctl restart tomcat

    echo "yes" > /home/akkadinauser/recovering

elif [[ "$MASTER" == "$MY_HOSTNAME" && $nodes_len > 1 ]]; then

    echo "Checking if at least two nodes are up and running, if so, switch master" >> /home/akkadianuser/cli.log

    isnecessarychange="False"

    for j in $NODES
    do
        if [[ ( "$j" != "[" ) && ( "$j" != "]" ) && ("$j" != "$MY_HOSTNAME") && "$isnecessarychange" = "False" ]]
        then
            echo "Trying to connect to $j" >> /home/akkadianuser/cli.log
            remote_mongo_status_config=$(sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "/home/akkadianuser/scripts/ha_aco/mongo_replica_status.sh")

            echo "remote_mongo_status_config: $remote_mongo_status_config" >> /home/akkadianuser/cli.log

            if [[ "$remote_mongo_status_config" == "yes" ]]; then
                isnecessarychange="True"
                echo "it is needed to convert this into part of replica" >> /home/akkadianuser/cli.log
            fi
        fi
    done

    if [[ "$isnecessarychange" == "True" ]]; then
            wasDifferent=$(mongo /home/akkadianuser/scripts/ha_aco/change_primary_node.js | tail -1)
            temp="${wasDifferent%\"}"
            temp="${temp#\"}"

            echo "hostname!==primary: $temp." >> /home/akkadianuser/cli.log
            if [[ "$temp" == "True" ]]; then
                echo "Master was not Primary, needed restart..." >> /home/akkadianuser/cli.log

                sudo systemctl restart aco-server
                sudo systemctl restart tomcat

            else
                echo "Everything is good, do nothing" >> cli.log
                sudo sh /home/akkadianuser/scripts/ha_aco/send_hostname_to_replica.sh
            fi

    elif [[ "$isReplicaRunning" = "yes" ]]; then
        echo "I'm Master, nodes>1, other nodes are not part of this cluster, trying to recovery them..." >> /home/akkadianuser/cli.log
        for j in $NODES
        do
            if [[ ( "$j" != "[" ) && ( "$j" != "]" ) && ("$j" != "$MY_HOSTNAME") ]]
            then
                echo "Trying to connect recover $j" >> /home/akkadianuser/cli.log
                sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "systemctl stop mongodb"
                sleep 3
                sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "rm -Rf /opt/akkadian/data/db/*"
                sleep 2
                sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "systemctl start mongodb"
                sleep 2

                sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "systemctl restart aco-server"
                sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "systemctl restart tomcat"
            fi
        done
    fi


elif [[ "$MASTER" != "$MY_HOSTNAME" && $nodes_len > 1 ]]; then
    echo "I am not master, all is good, it means I need to get last data just in case" >> /home/akkadianuser/cli.log

    sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$MASTER "tar -zcvf /home/akkadianuser/data.tar.gz /opt/akkadian/data/updates /opt/akkadian/data/template"
    sshpass -f /home/akkadianuser/.sshpass_$ran scp -o StrictHostKeyChecking=no root@$MASTER:/home/akkadianuser/data.tar.gz /home/akkadianuser/data.tar.gz
    sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$MASTER "rm -Rf /home/akkadianuser/data.tar.gz"
    sudo tar -zxvf /home/akkadianuser/data.tar.gz -C /
    sudo rm -Rf /home/akkadianuser/data.tar.gz

    sudo sh /home/akkadianuser/scripts/ha_aco/send_hostname_to_replica.sh
fi


sudo rm -Rf /home/akkadianuser/.sshpass_$ran

echo "removing lock file" >> /home/akkadianuser/cli.log

#move log file if needed.
sh /home/akkadianuser/scripts/ha_aco/check_ha_log_size.sh /home/akkadianuser/cli.log

echo "##### stop processing heartbeat actions #####" >> /home/akkadianuser/cli.log