#!/usr/bin/env bash

echo "Waiting until pcs is functional" >> /home/akkadianuser/cli.log
COUNTER=0
while [  $COUNTER -lt 1 ]; do
    pcsd_status=$(systemctl is-active --quiet pcsd && echo Service is running)
    pacemaker_status=$(systemctl is-active --quiet pacemaker && echo Service is running)
    corosync_status=$(systemctl is-active --quiet corosync && echo Service is running)

    if [[ "$pcsd_status" == "Service is running" && "$pacemaker_status" == "Service is running" && "$corosync_status" == "Service is running" ]]; then
        let COUNTER=COUNTER+1
    fi
    sleep 1
done

NODES=$(sudo pcs status | grep Online: | awk -F : '{print $2}')
MASTER=$(sudo pcs status | grep RS_VIP_Akkadian | awk -F ' ' '{print $4}')
MY_HOSTNAME=$(sudo hostname)
old_master=$(cat /home/akkadianuser/master)
ran=$(( ( RANDOM % 100 )  + 1 ))


if [[ -d /opt/akkadian/aco-server ]]; then
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_aco.gpg > /home/akkadianuser/.sshpass_$ran
else
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_pme_cm.gpg > /home/akkadianuser/.sshpass_$ran
fi
IFS=$' '


echo "Getting the hostname of the second node" >> /home/akkadianuser/cli.log
nodes_len=0
i=2

second=""
for j in $NODES
    do
        if [[ ( "$j" != "[" ) && ( "$j" != "]" ) ]]
        then
            nodes_len=$(($nodes_len+1))
            if [[ "$j" != "$MY_HOSTNAME" ]]; then
                second=$j
            fi
        fi
done


if [[ "$MASTER" = "$MY_HOSTNAME" ]]; then
    echo "##### start processing heartbeat actions #####" >> /home/akkadianuser/cli.log
    date >> /home/akkadianuser/cli.log
    echo "node len: $nodes_len" >> /home/akkadianuser/cli.log

    ############ VERIFYING REPLICA STATUS ##############################################################################
    startMongoWithReplicaConfigs=$(sh /home/akkadianuser/scripts/ha_aco/mongo_replica_status_in_config_file.sh)
    startMongoWithReplicaConfigs_second=$(sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second "sh /home/akkadianuser/scripts/ha_aco/mongo_replica_status_in_config_file.sh")

    isReplicaRunning=$(sh /home/akkadianuser/scripts/ha_aco/mongo_replica_status.sh)
    isReplicaRunning_second=$(sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second "sh /home/akkadianuser/scripts/ha_aco/mongo_replica_status.sh")

    echo "is replica running: $isReplicaRunning" >> /home/akkadianuser/cli.log
    echo "replica config are in file: $startMongoWithReplicaConfigs" >> /home/akkadianuser/cli.log
    echo "node list: $nodes_len" >> /home/akkadianuser/cli.log
    ####################################################################################################################

    if [[ $nodes_len = 1 && "$startMongoWithReplicaConfigs" = "yes" ]]; then
        #revert every replica configuration in this node\

        echo "Reverting configs to be standalone" >> /home/akkadianuser/cli.log
        sudo systemctl stop mongodb
        sleep 5
        sudo cp -Rf /home/akkadianuser/scripts/mongo_replica_scripts/start-mongo.sh /opt/akkadian/aco-server/scripts/start-mongodb.sh
        echo "starting mongo without replication"
        sudo systemctl start mongodb
        sleep 10
        sudo truncate -s 0 /opt/akkadian/data/replica
        sudo systemctl restart aco-server
        sudo systemctl restart tomcat

    elif [[ $nodes_len > 1 && "$startMongoWithReplicaConfigs" = "no" ]]; then
        # This means we need to start mongo with replicaSet in it
        # configure all again???
        # sh /home/akkadianuser/scripts/mongo_replica_scripts/set_mongo_replication.sh

        echo "Reverting back standalone config, because both  nodes are up" >> /home/akkadianuser/cli.log
        isnecessarychange="False"

        for j in $NODES
        do
            if [[ ( "$j" != "[" ) && ( "$j" != "]" ) && ("$j" != "$MY_HOSTNAME") && "$isnecessarychange" = "False" ]]
            then
                nodewas1=$(sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "grep -R aco_replica /opt/akkadian/aco-server/scripts/start-mongodb.sh")
                if [[ "$nodewas1" != "" ]]; then
                    isnecessarychange="True"
                    echo "it is needed to convert this into part of replica" >> /home/akkadianuser/cli.log
                fi
            fi
        done

        #means the other node has replica configured => the configuration in this node was turned off by this script
        if [[ "$isnecessarychange" = "True" ]];
        then
            echo "converting this node into part of replica" >> /home/akkadianuser/cli.log
            echo "stopping mongo" >> /home/akkadianuser/cli.log
            sudo systemctl stop mongodb
            echo "copying mongo file" >> /home/akkadianuser/cli.log
            sudo cp -Rf /home/akkadianuser/scripts/mongo_replica_scripts/start-mongo-replica.sh /opt/akkadian/aco-server/scripts/start-mongodb.sh
            sleep 5
            echo "starting mongo" >> /home/akkadianuser/cli.log
            sudo systemctl start mongodb

            sleep 3
            echo "hostname into /opt/akkadian/data/replica" >> /home/akkadianuser/cli.log
            echo "$MY_HOSTNAME" > /opt/akkadian/data/replica

            echo "Restarting aco-server" >> /home/akkadianuser/cli.log
            sudo systemctl restart aco-server
            sleep 3
            sudo systemctl restart tomcat

        fi
    #looking for mongo failures =>
    elif [[ $nodes_len > 1 && "$startMongoWithReplicaConfigs" = "yes" && "$isReplicaRunning" = "no" ]]; then

        echo "replica config set, mongo not running" >> /home/akkadianuser/cli.log
        isNecessaryRm="False"
        for j in $NODES
        do
            if [[ ( "$j" != "[" ) && ( "$j" != "]" ) && ("$j" != "$MY_HOSTNAME") && "$isNecessaryRm" = "False" ]]
            then
                nodewas1=$(sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "grep -R aco_replica /opt/akkadian/aco-server/scripts/start-mongodb.sh")
                if [[ "$nodewas1" != "" ]]; then
                    isNecessaryRm="True"
                fi
            fi
        done

        if [[ "$isNecessaryRm" = "True" ]]; then
            echo "The status is OTHER, trying to recover it" >> /home/akkadianuser/cli.log
            sudo systemctl restart mongodb
            sleep 3

            other=$(cat /home/akkadianuser/amount_other)
            if [[ "$other" == "yes" ]]; then
                echo "OTHER was not recovered, trying deleting db" >> /home/akkadianuser/cli.log
                sudo systemctl stop mongodb
                sleep 3
                sudo rm -Rf /opt/akkadian/data/db/*
                sleep 3
                sudo systemctl start mongodb
                sleep 3
                other="no"
            else
                other="yes"
            fi

            sudo systemctl restart aco-server
            sudo systemctl restart tomcat

    #If everything else is ok, then =>
    elif [[ $nodes_len > 1 ]]; then
        echo "Checking if vip master is same than mongo primary, if not, revert" >> /home/akkadianuser/cli.log

        sudo mongo admin -u mongoDBuser -p X46kTVmongo --eval "rs.isMaster()" > /home/akkadianuser/isMaster
        isMaster=$(grep -w 'ismaster' /home/akkadianuser/isMaster | awk {'print $3'} | tr -d ",")

        if [[ "$isMaster" = "false" ]]; then
            echo "VIP Master is not the primary, trying to recover..." >> /home/akkadianuser/cli.log
            primary=$(mongo /home/akkadianuser/get_mongo_primary_node.js | tail -1)
            primary="${primary%\"}"
            primary="${primary#\"}"
            sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$primary "sudo mongo admin -u mongoDBuser -p X46kTVmongo --eval 'rs.stepDown(60)'"
            for j in $NODES
            do
                if [[ ( "$j" != "[" ) && ( "$j" != "]" ) && ("$j" != "$MY_HOSTNAME") ]]
                then
                   sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$primary "sudo mongo admin -u mongoDBuser -p X46kTVmongo --eval 'rs.freeze(60)'"
                fi
            done

            sudo systemctl restart aco-server
        fi

        sudo systemctl restart tomcat
        other="no"

        #here add process to get data folder in slave
    fi

fi




#elif [[ "$MASTER" != "$MY_HOSTNAME" && $nodes_len > 1 ]]; then
#    echo "I am not master, all is good, it means I need to get last data just in case" >> /home/akkadianuser/cli.log
#
#    sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$MASTER "tar -zcvf /home/akkadianuser/data.tar.gz /opt/akkadian/data/updates /opt/akkadian/data/template"
#    sshpass -f /home/akkadianuser/.sshpass_$ran scp -o StrictHostKeyChecking=no root@$MASTER:/home/akkadianuser/data.tar.gz /home/akkadianuser/data.tar.gz
#    sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$MASTER "rm -Rf /home/akkadianuser/data.tar.gz"
#    sudo tar -zxvf /home/akkadianuser/data.tar.gz -C /
#    sudo rm -Rf /home/akkadianuser/data.tar.gz
#    other="no"
#fi


sudo rm -Rf /home/akkadianuser/.sshpass_$ran

echo "removing lock file" >> /home/akkadianuser/cli.log
sudo rm -Rf /home/akkadianuser/mongo_replication_flag

echo "$other" > /home/akkadianuser/amount_other

echo "##### stop processing heartbeat actions #####" >> /home/akkadianuser/cli.log