#!/usr/bin/env bash

MY_HOSTNAME=$(sudo hostname)
pcsd_status=$(sudo pcs status 2>&1)

if [[ "$pcsd_status" != "Error: cluster is not currently running on this node" ]]
then
    STATUS=$(sudo pcs status | grep pcsd | awk -F ' ' '{print $2}')

    if [[ "$STATUS" == "active/enabled" ]]; then
        MASTER=$(sudo pcs status | grep RS_VIP_Akkadian | awk -F ' ' '{print $4}')

        if [[ "$MASTER" == "$MY_HOSTNAME" ]]; then
            sudo echo "$MASTER" > /var/www/html/ha/master
        else
            sudo truncate -s 0 /var/www/html/ha/master
        fi
    fi
else
    #if there is an external load balancer
    if [[ -f /home/akkadianuser/load_balancer.config ]]; then
        fake_master=$(head -n 1 /home/akkadianuser/load_balancer.config | awk '{print $1;}')
        if [[ "$fake_master" == "$MY_HOSTNAME" ]]; then
            sudo echo "$fake_master" > /var/www/html/ha/master
        else
            sudo truncate -s 0 /var/www/html/ha/master
        fi
    else
        echo "non-ha-env" > /var/www/html/ha/master
    fi

fi