#!/usr/bin/env bash
#$1 node 1
#$2 node 2

hostname=$(sudo hostname)
nodes=$(head -n 1 /home/akkadianuser/load_balancer.config)

for node in $nodes; do
    if [[ "$node" != "$hostname" ]]
    then
        second_master=$node
    fi
done

echo "second is: $second_master"
ran=$(( ( RANDOM % 100 )  + 1 ))
gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_pme_cm.gpg > /home/akkadianuser/.sshpass_$ran

if [[ -d /var/www/html/pme ]]; then
    yes | sudo cp -rf /home/akkadianuser/my-master-noha-1-pme.cnf /etc/my.cnf
#    echo "copying fiile into second: $second_master"
    sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second_master "yes | sudo cp -rf /home/akkadianuser/my-master-noha-2-pme.cnf /etc/my.cnf"
fi
if [[ -d /var/www/html/acm ]]; then
    yes | sudo cp -rf /home/akkadianuser/my-master-noha-1-cm.cnf /etc/my.cnf
    sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second_master "yes | sudo cp -rf /home/akkadianuser/my-master-noha-2-cm.cnf /etc/my.cnf"
fi

sudo systemctl restart mariadb
sleep 5
mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "GRANT REPLICATION SLAVE ON *.* TO 'sk'@'%' IDENTIFIED BY 'centos';"
mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "FLUSH PRIVILEGES;"

echo "Getting sync information on master"
file=$(mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -ANe "SHOW MASTER STATUS;" | awk '{print $1}')
pos=$(mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -ANe "SHOW MASTER STATUS;" | awk '{print $2}')

echo "Dumping DB"
mysqldump --defaults-extra-file=/home/akkadianuser/.my.cnf --all-databases --events > /home/akkadianuser/masterdatabasetomaster.sql
sshpass -f /home/akkadianuser/.sshpass_$ran scp -o StrictHostKeyChecking=no /home/akkadianuser/masterdatabasetomaster.sql root@$second_master:/home/akkadianuser/masterdatabasetomaster.sql
sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second_master 'sudo mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root < /home/akkadianuser/masterdatabasetomaster.sql'

echo "Restarting mariadb in second"
sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second_master 'sudo systemctl restart mariadb'
sleep 5

sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second_master 'sh /home/akkadianuser/scripts/ha/grant_slave_permissions.sh'
sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second_master 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "FLUSH PRIVILEGES"'
sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second_master 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "STOP SLAVE;"'
sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second_master 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "CHANGE MASTER TO MASTER_HOST='\'$hostname\'', MASTER_USER='\'sk\', MASTER_PASSWORD=\'centos\', MASTER_LOG_FILE=''\'$file\'', MASTER_LOG_POS='$pos';"'
sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second_master 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "START SLAVE;"'

echo "Getting information on second"
file=$(sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second_master 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -ANe "SHOW MASTER STATUS;"' | awk '{print $1}')
pos=$(sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second_master 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -ANe "SHOW MASTER STATUS;"' | awk '{print $2}')

mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "STOP SLAVE;"
mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "CHANGE MASTER TO MASTER_HOST='$second_master', MASTER_USER='sk', MASTER_PASSWORD='centos', MASTER_LOG_FILE='$file', MASTER_LOG_POS=$pos;"
mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "START SLAVE;"


if [[ -d /var/www/html/pme ]]; then
    version=$(grep -w 'version' /var/www/html/pme/application/config/pme.php | awk '{print $3}' | tr -d "'" | tr -d ",")
    build=$(grep -w 'build_number' /var/www/html/pme/application/config/pme.php | awk '{print $3}' | tr -d "'" | tr -d ",")

    current_version=$(echo "$version-$build")
fi
if [[ -d /var/www/html/acm ]]; then
    current_version=$(grep -w 'version' /var/www/html/acm/application/config/gd.php | awk '{print $3}' | tr -d "'" | tr -d ",")
fi
> /home/akkadianuser/version
echo $current_version > /home/akkadianuser/version
sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second_master '> /home/akkadianuser/version'
sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second_master "echo "$current_version" > /home/akkadianuser/version"

sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second_master "systemctl stop supervisord"
sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second_master "systemctl disable supervisord"

truncate -s 0 /home/akkadianuser/.sshpass_$ran
sudo rm -Rf /home/akkadianuser/.sshpass_$ran