#!/usr/bin/env bash

COUNTER=0
while [  $COUNTER -lt 1 ]; do
    mariadb_status=$(systemctl is-active --quiet mariadb && echo Service is running)
    if [[ "$mariadb_status" == "Service is running" ]]; then
        let COUNTER=COUNTER+1
        echo "mariadb is running" >> /home/akkadianuser/redundancy.log
    fi
    sleep 1
done

hostname=$(sudo hostname)
nodes=$(head -n 1 /home/akkadianuser/load_balancer.config)

for node in $nodes; do
    if [[ "$node" != "$hostname" ]]
    then
        second_master=$node
    fi
done

ran=$(( ( RANDOM % 100 )  + 1 ))
if [[ -d /opt/akkadian/aco-server ]]; then
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_aco.gpg > /home/akkadianuser/.sshpass_$ran
else
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_pme_cm.gpg > /home/akkadianuser/.sshpass_$ran
fi

#Taking software if needed
if [[ -d /var/www/html/pme ]]; then
    version=$(grep -w 'version' /var/www/html/pme/application/config/pme.php | awk '{print $3}' | tr -d "'" | tr -d ",")
    build=$(grep -w 'build_number' /var/www/html/pme/application/config/pme.php | awk '{print $3}' | tr -d "'" | tr -d ",")

    current_version=$(echo "$version-$build")

fi
if [[ -d /var/www/html/acm ]]; then
    current_version=$(grep -w 'version' /var/www/html/acm/application/config/gd.php | awk '{print $3}' | tr -d "'" | tr -d ",")
fi

echo "current_version: $current_version" >> /home/akkadianuser/redundancy.log
redundancy_version=$(sudo head -n 1 /home/akkadianuser/version)
echo "redundancy_version: $redundancy_version" >> /home/akkadianuser/redundancy.log

if [[ "$current_version" != "$redundancy_version" ]]; then
    sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second_master "rm -rf /home/akkadianuser/package.tar.gz "

    if [[ -d /var/www/html/pme ]]; then
        sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second_master "tar --exclude='var/www/html/pme/application/licenses' -zcvf /home/akkadianuser/package.tar.gz /var/www/html/*"
    fi
    if [[ -d /var/www/html/acm ]]; then
        sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second_master "tar --exclude='var/www/html/acm/application/licenses' -zcvf /home/akkadianuser/package.tar.gz /var/www/html/*"
    fi

    sshpass -f /home/akkadianuser/.sshpass_$ran scp -o StrictHostKeyChecking=no root@$second_master:/home/akkadianuser/package.tar.gz /home/akkadianuser/package.tar.gz
    sudo tar -xzvf /home/akkadianuser/package.tar.gz -C /
    sudo rm -rf /home/akkadianuser/package.tar.gz
    sudo echo $current_version > /home/akkadianuser/version
fi


COUNTER_2=0
while [  $COUNTER_2 -lt 1 ]; do
    error_=$(mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "SHOW SLAVE STATUS\G;" | grep "Last_Errno" | awk -F ' ' '{print $2}')
    echo "Error Found: $error_ initiating error recovery" >> /home/akkadianuser/redundancy.log
    if [[ "$error_" == "1062" ]]; then

        echo "Error Found: $error_ stopping slave Database" >> /home/akkadianuser/redundancy.log
        mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "stop slave;"
        echo "Error Found: $error_ setting sql_slave_counter to 1" >> /home/akkadianuser/redundancy.log
        mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "set global SQL_SLAVE_SKIP_COUNTER = 1;"
        echo "Error Found: $error_ starting slave Database" >> /home/akkadianuser/redundancy.log
        mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "start slave;"
        sleep 5
    elif [[ "$error_" == "1236" ]]; then
        mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "STOP SLAVE;"
        mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "RESET SLAVE;"

        file=$(sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second_master "sh /home/akkadianuser/scripts/externally_accessed/show_master_status_binfile.sh")
        pos=$(sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second_master "sh /home/akkadianuser/scripts/externally_accessed/show_master_status_posinfile.sh")

        echo "Error Found: $error_ setting new master_log_file to $file, and master_log_pos to $pos" >> /home/akkadianuser/redundancy.log
        mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "change master to master_log_file='$file',master_log_pos=$pos;"
        mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "START SLAVE;"

        let COUNTER_2=COUNTER_2+1
        sleep 5
    #in case it is on io error
    elif [[ "$error_" == "0" ]]; then
        error_IO=$(mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "SHOW SLAVE STATUS\G;" | grep "Last_IO_Errno" | awk -F ' ' '{print $2}')
        echo "Error Found: $error_IO initiating error recovery" >> /home/akkadianuser/redundancy.log
        if [[ "$error_IO" == "1062" ]]; then

            mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "stop slave;"
            echo "Error Found: $error_IO setting sql_slave_counter to 1" >> /home/akkadianuser/redundancy.log
            mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "set global SQL_SLAVE_SKIP_COUNTER = 1;"
            mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "start slave;"
            sleep 5

        elif [[ "$error_IO" == "1236" ]]; then
            mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "STOP SLAVE;"
            mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "RESET SLAVE;"

            file=$(sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second_master "sh /home/akkadianuser/scripts/externally_accessed/show_master_status_binfile.sh")
            pos=$(sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second_master "sh /home/akkadianuser/scripts/externally_accessed/show_master_status_posinfile.sh")

            echo "Error Found: $error_IO setting new master_log_file to $file, and master_log_pos to $pos" >> /home/akkadianuser/redundancy.log
            mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "change master to master_log_file='$file',master_log_pos=$pos;"
            mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "START SLAVE;"
            let COUNTER_2=COUNTER_2+1
            sleep 5
        else
            echo "Exiting Recovery mode, error code: $error_IO" >> /home/akkadianuser/redundancy.log
            let COUNTER_2=COUNTER_2+1

        fi
    else
        echo "Exiting Recovery mode" >> /home/akkadianuser/redundancy.log
        let COUNTER_2=COUNTER_2+1

    fi
done


#move log file if needed.
sh /home/akkadianuser/scripts/ha_aco/check_ha_log_size.sh /home/akkadianuser/redundancy.log

sudo truncate -s 0 /home/akkadianuser/.sshpass_$ran
sudo rm -rf /home/akkadianuser/.sshpass_$ran