#!/usr/bin/env bash
hostname=$(sudo hostname)
nodes=$(head -n 1 /home/akkadianuser/load_balancer.config)
for node in $nodes; do
    if [[ "$node" != "$hostname" ]]
    then
        second_master=$node
    fi
done

ran=$(( ( RANDOM % 100 )  + 1 ))
if [[ -d /opt/akkadian/aco-server ]]; then
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_aco.gpg > /home/akkadianuser/.sshpass_$ran
else
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_pme_cm.gpg > /home/akkadianuser/.sshpass_$ran
fi

mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "STOP SLAVE;"
mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "RESET SLAVE;"
sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second_master 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "STOP SLAVE;"'
sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second_master 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "RESET SLAVE;"'

yes | sudo cp -rf /home/akkadianuser/my-original.cnf /etc/my.cnf
sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second_master "yes | sudo cp -rf /home/akkadianuser/my-original.cnf /etc/my.cnf"

sudo systemctl restart mariadb
sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second_master "systemctl restart mariadb"

sleep 5
slave_running_here=$(mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "SHOW SLAVE STATUS\G;" | grep 'Slave_IO_Running')
slave_running_there=$(sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j 'mysql --defaults-extra-file=/home/akkadianuser/.my.cnf -u root -e "SHOW SLAVE STATUS\G;" | grep 'Slave_IO_Running'')

if [[ "$slave_running_here" != "Slave_IO_Running: Yes" ]]; then
    sudo systemctl restart mariadb
fi

if [[ "$slave_running_there" != "Slave_IO_Running: Yes" ]]; then
    sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second_master 'systemctl restart mariadb'
fi

sudo firewall-cmd --zone=public --remove-port=3306/tcp
sudo firewall-cmd --runtime-to-permanent
sudo firewall-cmd --reload
sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second_master 'firewall-cmd --zone=public --remove-port=3306/tcp'
sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second_master 'firewall-cmd --runtime-to-permanent'
sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second_master 'firewall-cmd --reload'

sudo crontab -u akkadianuser -l | grep -v '/home/akkadianuser/scripts/ha/get_masterdb_to_master_noha.sh'  | crontab -u akkadianuser -
sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second_master "sudo crontab -u akkadianuser -l | grep -v '/home/akkadianuser/scripts/ha/get_masterdb_to_master_noha.sh'  | crontab -u akkadianuser -"

sudo truncate -s 0 /home/akkadianuser/load_balancer.config
sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second_master "truncate -s 0 /home/akkadianuser/load_balancer.config"

sudo rm -Rf /home/akkadianuser/version
sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$second_master "sudo rm -Rf /home/akkadianuser/version"

sudo rm -Rf /home/akkadianuser/.sshpass_$ran