#!/usr/bin/env bash

# CLI (auto update) updater script
#
# parameter:
#           * path where to save the backup
#           * url where to get the file tui.tar.gz

current_tmp_release_folder=/home/akkadianuser/tmp/akkappmanager_installation
current_release_zip_name=`echo $1 | sed -r "s/\x1B\[([0-9]{1,3}((;[0-9]{1,3})*)?)?[m|K]//g"`;
current_app_folder=/home/akkadianuser
backup_directory=/home/backups/akkappmanager/
backup_release_directory=${backup_directory}

current_app_folder=/home/akkadianuser

updater_file=$(basename "$1")

if [[ $current_release_zip_name == "cli_updates" ]]; then
    current_release_zip_name=$(sudo ls -1 /var/www/cli_updates/AAM_TUI*.tar.gz 2>/dev/null | tail -1)
fi

if [ ! -e ${backup_directory} ]
then
    mkdir ${backup_directory}
fi

if [ ! -e ${backup_release_directory} ]
then
    mkdir ${backup_release_directory}
fi

if [ -e ${current_tmp_release_folder} ]
then
    rm -Rf ${current_tmp_release_folder}
fi

if [ ! -e ${current_tmp_release_folder} ]
then
    mkdir ${current_tmp_release_folder}
fi


# Do we need to download the file?
if [[ ( ${current_release_zip_name} == "http"* ) || ( ${current_release_zip_name} == "ftp"* ) ]]
then
    echo 'Getting update file'
    wget ${current_release_zip_name} -P ${current_tmp_release_folder}/
else
    echo "copying ${current_release_zip_name} file into ${current_tmp_release_folder}"
    sudo cp -Rf ${current_release_zip_name} ${current_tmp_release_folder}
fi

echo 'Authenticating and unzipping update file'

sudo tar -xvzf ${current_tmp_release_folder}/$(basename ${current_release_zip_name}) -C ${current_tmp_release_folder}/
#sudo openssl enc -d -aes-256-cbc -in ${current_tmp_release_folder}/$(basename ${current_release_zip_name}) -pass pass:'HtBr6QckqJPk4rpatyUNT594' | tar xz -C ${current_tmp_release_folder}/

if [[ $? -eq 0 ]]; then

    echo 'copying files...'
    echo ${current_app_folder}
    sudo cp -Rf ${current_app_folder}/sync_start_at_log ${current_app_folder}/sync_end_at_log ${current_tmp_release_folder}
    sudo cp -Rf ${current_tmp_release_folder}/* ${current_tmp_release_folder}/.* ${current_app_folder} &
    BACK_PID=$!

    #TODO:wait until the current_app_folder is modified
    while kill -0 $BACK_PID ; do
        echo "Process is still active..."
        sleep 1
        # You can add a timeout here if you want
    done

    echo 'changing permissions...'
    dos2unix /home/akkadianuser/*
    sudo chown -R akkadianuser:akkadianuser /home/akkadianuser
    sudo chmod +x /home/akkadianuser/scripts/*


    sudo rm -Rf venv/
    sudo rm -Rf netifaces-0.10.4/
    sudo rm -Rf build/
    sudo rm -Rf dist/
    sudo rm -Rf tui.tar.gz
    sudo rm -Rf tui/
    sudo rm -Rf akkadianAppManager.egg-info/
    sudo rm -Rf /usr/lib/python2.7/site-packages/akkadianAppManager-1.0-py2.7.egg


    echo 'compiling...'
    sleep 5

    #TODO: what about non internet connection.
    sudo yum -y install jq

    if [[  ! -d /var/www ]]; then
        sudo mkdir /var/www
        sudo chown -R apache:root /var/www
        sudo chmod -R 755 /var/www
    fi

    if [[  ! -d /var/www/product_update ]]; then
        sudo mkdir /var/www/product_update
        sudo chown -R apache:root /var/www/product_update
        sudo chmod -R 755 /var/www/product_update
    fi

    if [[ ! -d /var/www/html/ha ]]; then
        sudo mkdir /var/www/html/ha
        sudo chown -R apache:root /var/www/html/ha
        sudo chmod -R 755 /var/www/html/ha
    fi


    if [[ ! -d /var/www/cli_updates ]]; then
        sudo mkdir /var/www/cli_updates
        sudo chown -R apache:root /var/www/cli_updates
        sudo chmod -R 755 /var/www/cli_updates
    fi

    if [[ -d /opt/akkadian/aco-server ]]; then

        isNodeInstalled=$(node -v)

        if [[ "$isNodeInstalled" == "" ]]; then
            #If it is aco, then install nodejs
            sudo yum -y install -y gcc-c++ make
            sudo curl -sL https://rpm.nodesource.com/setup_6.x | sudo -E bash -
            sudo yum -y install nodejs
        fi
    fi

    sudo cp -Rf /home/akkadianuser/scripts/universal_updater/update_main.sh /var/www/product_update/
    sudo rm -Rf /var/www/cli_updates/*

    sudo rm -Rf /home/akkadianuser/tui*.tar.gz
    sudo rm -Rf /home/akkadianuser/AAM_TUI*.tar.gz

    cd /home/akkadianuser

    sudo python2.7 setup.py install

    sudo echo "yes" > /home/akkadianuser/global_variables/restart_executor

else
    echo ""
    echo "ERROR - Failed to authenticate CLI Update file, please verify and try again."
    exit 1
fi