#!/usr/bin/env bash

# On build host (has internet access): Download and install NodeJS and NPM

wget http://nodejs.org/dist/node-v0.4.10.tar.gz
tar xvzf node-v0.4.10.tar.gz
cd node-v0.4.11
./configure
make
sudo make install
wget http://npmjs.org/install.sh
sudo sh ./install.sh
npm pack npm

# Prepare rbytes (pre-compile on build host and re-package)

rm -Rf ./package
npm pack rbytes@0.0.2
tar xvzf rbytes-0.0.2.tgz
rm rbytes-0.0.2.tgz
cd package
make
cd ..
npm pack package/
rm -Rf ./package

# Prepare log4js (pre-compile on build host and re-package)

rm -Rf ./package
npm pack log4js@0.3.8
tar xvzf rbytes-0.3.8.tgz
rm rbytes-0.3.8.tgz
cd package
make
cd ..
npm pack package/
rm -Rf ./package

# On build host: Copy nodejs, NPM and all the packages you want to install to the targethost

scp node-v0.4.10.tar.gz root@targethost:~
scp npm-1.0.26.tgz root@targethost:~
scp rbytes-0.0.2.tgz root@targethost:~
scp log4js-0.3.8.tgz root@targethost:~

# Login to the target host (has no internet connection):

ssh root@targethost

# Compile NodeJS (OK, I said you wouldn't need any compiling tools... Simply suppose you installed NodeJS from an RPM.)

cd ~
tar xvzf node-v0.4.10.tar.gz
cd node-v0.4.11
./configure --without-ssl
make
sudo make install

# Now install NPM with itself

cd ~
tar xvzf npm-1.0.26.tgz
./package/bin/npm.js -g install ~/npm-1.0.26.tgz

# Now you can install already build package via NPM on the target host just like so:

npm -g install ~/rbytes-0.0.2.tgz
npm -g install ~/log4js-0.3.8.tgz

# Voila, NPM is installed without the "install.sh" script and without internet access on the target host.
# Now NPM could even be packaged into an RPM.
# Thanks go out to DrMcKay from #node.js his nickname on github is "mmalecki" (https://github.com/mmalecki)


