#!/usr/bin/env bash
#TODO: what about non internet connection.
    sudo yum -y install jq

    if [[  ! -d /var/www ]]; then
        sudo mkdir /var/www
        sudo chown -R apache:root /var/www
        sudo chmod -R 755 /var/www
    fi

    if [[  ! -d /var/www/product_update ]]; then
        sudo mkdir /var/www/product_update
        sudo chown -R apache:root /var/www/product_update
        sudo chmod -R 755 /var/www/product_update

    fi

    sudo cp -Rf /home/akkadianuser/scripts/universal_updater/update_main.sh /var/www/product_update/

    if [[ ! -d /var/www/html/ha ]]; then
        sudo mkdir /var/www/html/ha
        sudo chown -R apache:root /var/www/html/ha
        sudo chmod -R 755 /var/www/html/ha
    fi


    if [[ ! -d /var/www/cli_updates ]]; then
        sudo mkdir /var/www/cli_updates
        sudo chown -R apache:root /var/www/cli_updates
        sudo chmod -R 755 /var/www/cli_updates
    fi

    if [[ -d /var/www/html/asb ]]; then
        if [[ ! -f /home/akkadianuser/scripts/executed_fixes/asb_1x_update_fix.done ]]; then
            sudo sh /home/akkadianuser/scripts/asb/asb_1x_update_fix.sh /var/www/html/asb
        fi
    fi

    ################### root cron ##########################################################################################
    ################ 2019 08 09 Changes in apache cron to support jobs to be run only once if it is part of cluster ########
    #verifying apache jobs, and migrating them to akkadianuser
    root_cron_content=$(sudo crontab -u root -l)
    if [[ "$root_cron_content" != *"write_master.sh"* ]]; then

        root_new_cron_content="*/1 * * * * sh /home/akkadianuser/scripts/ha/write_master.sh"
        (sudo crontab -u root -l; echo "$root_new_cron_content" ) | sudo crontab -u root -
    fi

    if [[ "$root_cron_content" == *"read_and_eval.sh"* ]]; then
         sudo crontab -u root -l | grep -v 'read_and_eval.sh'  | crontab -u root -
    fi

    if [[ "$root_cron_content" != *"PATH="* ]]; then
         root_new_cron_content="PATH=\"/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin\""
        (sudo crontab -u root -l; echo "$root_new_cron_content" ) | sudo crontab -u root -
    fi

    if [[ -d /var/www/html/asb ]]; then
        if [[ "$root_cron_content" != *"@reboot php /var/www/biosuuid.php"* ]]; then
            root_new_cron_content=$"@reboot php /var/www/biosuuid.php"
            (sudo crontab -u root -l; echo "$root_new_cron_content" ) | sudo crontab -u root -
        fi
    fi
    ########################################################################################################################


    ################# akkadianuser cron ####################################################################################
    akkadian_cron_content=$(sudo crontab -u akkadianuser -l)
    if [[ "$akkadian_cron_content" != *"read_and_eval.sh"* ]]; then
        akkadian="*/1 * * * * sh /var/www/product_update/read_and_eval.sh > /var/www/product_update/crontab.log 2>&1"
        (sudo crontab -u akkadianuser -l; echo "$akkadian" ) | sudo crontab -u akkadianuser -
    fi

    ##### Removing unnecessary entries ###################
    if [[ "$akkadian_cron_content" == *"@reboot python2.7 /home/akkadianuser/executor.py"* ]]; then
        sudo crontab -u akkadianuser -l | grep -v 'python2.7 /home/akkadianuser/executor.py'  | crontab -u akkadianuser -
    fi
    ########################################################################################################################

    isNodeInstalled=$(node -v)

    ################## apache cron #########################################################################################
    #### Checking on old versions to add or not the apache cron
    #### DO  NOT MODIFY TABS IN apache_cron_content!!!!!!!!!!!!!!
    if [[ ! -d /opt/akkadian/aco-server ]]; then

        apache_original=$(sudo crontab -u apache -l)
        if [[ -d /var/www/html/pme ]]; then

            if [[ "$apache_original" != *"php /var/www/html/pme/index.php --task=Sync"* ]]; then
                apache=$"5 * * * * sh /home/akkadianuser/scripts/apm_cm_runner.sh \"php /var/www/html/pme/index.php --task=Sync\" "
                (sudo crontab -u apache -l; echo "$apache" ) | sudo crontab -u apache -
            fi


            if [[ "$apache_original" != *"php /var/www/html/pme/index.php --task=Schedule"* ]]; then
                apache=$"5 * * * * sh /home/akkadianuser/scripts/apm_cm_runner.sh \"php /var/www/html/pme/index.php --task=Schedule\" "
                (sudo crontab -u apache -l; echo "$apache" ) | sudo crontab -u apache -
            fi


            if [[ "$apache_original" != *"php /var/www/html/pme/index.php --task=Schedule"* ]]; then
                apache=$"5 * * * * sh /home/akkadianuser/scripts/apm_cm_runner.sh \"php /var/www/html/pme/index.php --task=BackupSchedule\" "
                (sudo crontab -u apache -l; echo "$apache" ) | sudo crontab -u apache -
            fi

            if [[ -f /home/akkadianuser/configs/akkadian_apm.cnf ]]; then
                sudo cp -Rf /home/akkadianuser/configs/akkadian_apm.cnf /etc/my.cnf.d/akkadian.cnf
            fi

        fi

        if [[ -d /var/www/html/asb ]]; then

            if [[ "$apache_original" != *"php /var/www/html/asb/artisan schedule:run"* ]]; then
                apache=$"* * * * * sh /home/akkadianuser/scripts/apm_cm_runner.sh \"php /var/www/html/asb/artisan schedule:run\" "
                (sudo crontab -u apache -l; echo "$apache" ) | sudo crontab -u apache -
            fi

            if [[ "$apache_original" == *"@reboot php /var/www/biosuuid.php"* ]]; then
                sudo crontab -u apache -l | grep -v '@reboot php /var/www/biosuuid.php'  | crontab -u apache -
            fi
        fi

        if [[ -d /var/www/html/orc ]]; then

            if [[ "$apache_original" != *"php /var/www/html/orc/artisan schedule:run"* ]]; then
                apache=$"* * * * * sh /home/akkadianuser/scripts/apm_cm_runner.sh \"php /var/www/html/orc/artisan schedule:run\" "
                (sudo crontab -u apache -l; echo "$apache" ) | sudo crontab -u apache -
            fi
        fi

        if [[ -d /var/www/html/acm ]]; then

            if [[ "$apache_original" != *"/usr/bin/php /var/www/html/acm/scheduler.php"* ]]; then
                apache_cron_content=$"* * * * * sh /home/akkadianuser/scripts/apm_cm_runner.sh \"/usr/bin/php /var/www/html/acm/scheduler.php > /dev/null 2>&1\" "
                (sudo crontab -u apache -l; echo "$apache" ) | sudo crontab -u apache -
            fi
            if [[ -f /home/akkadianuser/configs/akkadian_acm.cnf ]]; then
                sudo cp -Rf /home/akkadianuser/configs/akkadian_acm.cnf /etc/my.cnf.d/akkadian.cnf
            fi
        fi
    elif [[ "$isNodeInstalled" == "" ]]; then
        #If it is aco, then install nodejs
        sudo yum -y install -y gcc-c++ make
        sudo curl -sL https://rpm.nodesource.com/setup_6.x | sudo -E bash -
        sudo yum -y install nodejs
    fi

    sudo chown -Rf apache /etc/openldap/certs/
    sudo chown -Rf apache /etc/pki/ca-trust/extracted/pem/
    sudo chown -Rf apache /etc/pki/tls/certs/
    sudo chown -Rf apache /etc/pki/ca-trust/source/anchors/

    #sudo rm -Rf /var/www/cli_updates/*

    #### Installing executor.py ########
    if [[ ! -f /etc/systemd/system/akkadian-executor.service ]]; then

         sudo cp /home/akkadianuser/scripts/executor/akkadian-executor.service /etc/systemd/system/

         #This is because new openssl version

         sudo echo "/usr/local/lib64" > /etc/ld.so.conf.d/openssl.conf
         sudo ldconfig

         sudo systemctl daemon-reload
         sudo systemctl enable akkadian-executor
         sudo systemctl start akkadian-executor

    fi

    if [[ ! -f /home/backups ]]; then
        sudo mkdir /home/backups
    fi

    if [[ -d /var/log ]]; then
        sudo chmod -Rf 755 /var/log
    fi

    if [[ -d /var/lib/mysql/pme ]]; then
        sudo chmod -Rf 755 /var/lib/mysql/pme
    fi

    if [[ -d /home/akkadianuser/aUU_installer ]]; then

        if [[ ! -d /var/www/html/update ]]; then
            sudo mkdir /var/www/html/update
        fi

        aUUName=$(basename $(ls /home/akkadianuser/aUU_installer/*.tar.gz | tail -1))

        if [[ ! -d /tmp/installer/ ]]; then
            sudo mkdir /tmp/installer/
        fi

        cp -Rf /home/akkadianuser/aUU_installer/$aUUName /tmp/installer/
        sudo sh /home/akkadianuser/scripts/universal_updater/universal_updator_installer.sh /tmp/installer/$aUUName /var/www/html/update

        sudo rm -Rf /home/akkadianuser/aUU_installer

        sudo systemctl stop akkadian-executor
        sleep 3
        sudo systemctl start akkadian-executor
    fi

    if [[ -f /home/akkadianuser/global_variables/restart_executor ]]; then
        needed_restart=$(cat /home/akkadianuser/global_variables/restart_executor)
        if [[ "$needed_restart" == "yes" ]]; then
            sudo systemctl restart akkadian-executor
            sudo echo "no" > /home/akkadianuser/global_variables/restart_executor
        fi
    fi

    FILE_SSHD="/home/akkadianuser/scripts/security/patch_sshd_1.sh"
    FILE_GRUB2="/home/akkadianuser/scripts/security/patch_grub2_1.sh"
    FILE_ENGINEX="/home/akkadianuser/scripts/security/patch_nginex_1.sh"
    FILE_PWD="/home/akkadianuser/scripts/security/patch_pwd_1.sh"

    if test -f $FILE_SSHD; then
    	sh $FILE_SSHD
    fi

    if test -f $FILE_GRUB2; then
    	sh $FILE_GRUB2
    fi

    if test -f $FILE_ENGINEX; then
    	sh $FILE_ENGINEX
    fi

    if test -f $FILE_PWD; then
    	sh $FILE_PWD
    fi
