#!/usr/bin/env bash

COUNTER=0
while [  $COUNTER -lt 1 ]; do
    pcsd_status=$(systemctl is-active --quiet pcsd && echo Service is running)
    pacemaker_status=$(systemctl is-active --quiet pacemaker && echo Service is running)
    corosync_status=$(systemctl is-active --quiet corosync && echo Service is running)

    if [[ "$pcsd_status" == "Service is running" && "$pacemaker_status" == "Service is running" && "$corosync_status" == "Service is running" ]]; then
        let COUNTER=COUNTER+1
    fi
    sleep 1
done

NODES=$(sudo pcs status | grep Online: | awk -F : '{print $2}')
MASTER=$(sudo pcs status | grep RS_VIP_Akkadian | awk -F ' ' '{print $4}')
MY_HOSTNAME=$(sudo hostname)

IFS=$' '
if [[ -d /opt/akkadian/aco-server ]]; then
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_aco.gpg > /home/akkadianuser/.sshpass
else
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_pme_cm.gpg > /home/akkadianuser/.sshpass
fi

for j in $NODES
do
    if [[ ( "$j" != "[" ) && ( "$j" != "]" ) ]]
    then
        sshpass -f /home/akkadianuser/.sshpass ssh -o StrictHostKeyChecking=no root@$j "firewall-cmd --permanent --add-port=3306/tcp"
        sshpass -f /home/akkadianuser/.sshpass ssh -o StrictHostKeyChecking=no root@$j "firewall-cmd --reload"
    fi
done

truncate -s 0 /home/akkadianuser/.sshpass