#!/usr/bin/env bash

COUNTER=0
while [  $COUNTER -lt 1 ]; do
    pcsd_status=$(systemctl is-active --quiet pcsd && echo Service is running)
    pacemaker_status=$(systemctl is-active --quiet pacemaker && echo Service is running)
    corosync_status=$(systemctl is-active --quiet corosync && echo Service is running)

    if [[ "$pcsd_status" == "Service is running" && "$pacemaker_status" == "Service is running" && "$corosync_status" == "Service is running" ]]; then
        let COUNTER=COUNTER+1
    fi
    sleep 1
done

NODES=$(sudo pcs status | grep Online: | awk -F : '{print $2}')
MASTER=$(sudo pcs status | grep RS_VIP_Akkadian | awk -F ' ' '{print $4}')
MY_HOSTNAME=$(sudo hostname)

ran=$(( ( RANDOM % 100 )  + 1 ))

if [[ -d /opt/akkadian/aco-server ]]; then
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_aco.gpg > /home/akkadianuser/.sshpass_$ran
else
    gpg -d -q --batch --passphrase Akkadian /home/akkadianuser/.sshpassword_pme_cm.gpg > /home/akkadianuser/.sshpass_$ran
fi

for j in $NODES
do
    if [[ ( "$j" != "[" ) && ( "$j" != "]" ) ]]
    then
        sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo crontab -u akkadianuser -l | grep -v '/home/akkadianuser/scripts/master_replication.sh'  | crontab -u akkadianuser -"
        sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "(sudo crontab -u akkadianuser -l; echo \"* * * * * /home/akkadianuser/scripts/master_replication.sh\" ) | sudo crontab -u akkadianuser -"

        sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "sudo crontab -u akkadianuser -l | grep -v '/home/akkadianuser/scripts/ha_getmasterdb_toslave.sh'  | crontab -u akkadianuser -"
        sshpass -f /home/akkadianuser/.sshpass_$ran ssh -o StrictHostKeyChecking=no root@$j "(sudo crontab -u akkadianuser -l; echo \"@reboot truncate -s 0 /home/akkadianuser/master && sleep 10 && /home/akkadianuser/scripts/ha_getmasterdb_toslave.sh\" ) | sudo crontab -u akkadianuser -"
    fi
done

truncate -s 0 /home/akkadianuser/.sshpass_$ran
sudo rm -Rf /home/akkadianuser/.sshpass_$ran