#!/usr/bin/env bash

# ACO SERVER and ACO WEB updater script
#
# parameter:
#           * url where to get the file aco.tar.gz with acoserver.tar.gz and acow-webapp.war inside
#           * md5 code


updater_file="aco.tar.gz"
server_updater_file="acoserver.tar.gz"
web_updater_file="acow-webapp.war"

current_tmp_release_folder=/opt/akkadian/data/tmp
current_app_folder=/home/akkadianuser
current_server_folder=/opt/akkadian/aco-server
current_web_folder=/opt/tomcat/webapps
current_tomcat_base_folder=/opt/tomcat

current_release_zip_name=`echo $1 | sed -r "s/\x1B\[([0-9]{1,3}((;[0-9]{1,3})*)?)?[m|K]//g"`;
jtapi_version=`echo $2`;

# Flags variables
server_flag=0
web_flag=0

if [[ ( ${current_release_zip_name} == "http"* ) || ( ${current_release_zip_name} == "ftp"* ) ]]
then
    wget $1 -O ${current_tmp_release_folder}/${updater_file}
    if [[ ! -e ${current_tmp_release_folder}/${updater_file} ]]; then
        echo "ERROR: Couldn't download updater file!"; exit;
    fi
else
    sudo cp -Rf ${current_release_zip_name} ${current_tmp_release_folder}/${updater_file}
    if [[ ! -e ${current_tmp_release_folder}/${updater_file} ]]; then
        echo "ERROR: Couldn't copy media file!"; exit;
    fi
fi

# check=$(awk -F ': ' '{print $2}' <<< $(md5sum -c <<< "$2 ${current_tmp_release_folder}/${updater_file}"))
# if [ "$check" != "OK" ]; then
#    echo "ERROR: no properly formatted MD5 checksum lines found"; exit;
# fi
echo $'\n' "Updating ACO, please wait..."

tar -xvzf ${current_tmp_release_folder}/${updater_file} -C ${current_tmp_release_folder}
if [[ ! -e ${current_tmp_release_folder}/${server_updater_file} ]]; then
    if [[ ! -e ${current_tmp_release_folder}/${web_updater_file} ]]; then
        echo "ERROR: The downloaded files is wrong. Please try again!"; exit;
    else
        echo "WARNING: The downloaded file don't contains the server updater. Only the ACO WEB will be update!";
        web_flag=1
    fi
else
    if [[ ! -e ${current_tmp_release_folder}/${web_updater_file} ]]; then
        echo "WARNING: The downloaded file don't contains the web updater. Only the ACO SERVER will be update!";
        server_flag=1
    else
        server_flag=1
        web_flag=1
    fi
fi


if [[ "${server_flag}" -eq 1 ]]; then
    echo $'\n' "Updating ACO SERVER..."
    sudo yes | cp -Rf /opt/akkadian/aco-server/certificates/aco-server.crt /opt/akkadian/data/tmp/aco-server.crt
    sudo yes | cp -Rf /opt/akkadian/aco-server/certificates/aco-server.csr /opt/akkadian/data/tmp/aco-server.csr
    sudo yes | cp -Rf /opt/akkadian/aco-server/certificates/aco-server.key /opt/akkadian/data/tmp/aco-server.key

    # in case mongo is set with replica
    sudo yes | cp -Rf /opt/akkadian/aco-server/scripts/start-mongodb.sh /opt/akkadian/data/tmp/start-mongodb.sh

    # sudo sh /home/akkadianuser/scripts/stop_kestrel.sh
    sudo tar -xvzf ${current_tmp_release_folder}/${server_updater_file} -C ${current_server_folder}/ --strip-components 1
    dos2unix ${current_server_folder}/scripts/*
    dos2unix ${current_server_folder}/configs/*
    sudo chmod -R 765 /opt/akkadian/

    #in case we have replica
    sudo chmod 600 /opt/akkadian/data/mongokey

    echo $'\n' "Copying config files..."
    sudo yes | cp -Rf /opt/akkadian/aco-server/configs/sysctl.conf /etc/sysctl.conf
    sudo yes | cp -Rf /opt/akkadian/aco-server/configs/limits.conf /etc/security/limits.conf
    sudo yes | cp -Rf /opt/akkadian/aco-server/configs/supervisord.conf /etc/supervisord.conf
    sudo yes | cp -Rf /opt/akkadian/aco-server/configs/aco-server.service /etc/systemd/system/

    sudo yes | cp -Rf /opt/akkadian/aco-server/configs/nginx.conf /etc/nginx/
    sudo yes | cp -Rf /opt/akkadian/aco-server/configs/40x.html   /usr/share/nginx/html/
    sudo yes | cp -Rf /opt/akkadian/aco-server/configs/50x.html   /usr/share/nginx/html/
    sudo yes | cp -Rf /opt/akkadian/aco-server/configs/404.html   /usr/share/nginx/html//
    sudo yes | cp -Rf /opt/akkadian/aco-server/configs/aCO-icon.png   /usr/share/nginx/html/
    sudo yes | cp -Rf /opt/akkadian/aco-server/configs/aCO_Logo_big.svg  /usr/share/nginx/html/


    #####  getting environment type, it can be empty if it is an old file
    env=$(sudo cat /opt/tomcat/conf/fp-akkadian-platform.properties | grep aco.web.environment.size | awk -F "=" '{print $2}')
    sudo yes | cp -Rf ${current_server_folder}/acow-installer/fp-akkadian-platform.properties ${current_tomcat_base_folder}/conf/
    ####  setting environment type
    if [[ (-z "$env") || ("$env" == " ") || ("$env" == "\n") ]]
    then
        echo "$env is empty"
    else
        sudo sed -i "s/aco.web.environment.size.*/aco.web.environment.size=$env/g" /opt/tomcat/conf/fp-akkadian-platform.properties
    fi

    sudo yes | cp -Rf ${current_server_folder}/acow-installer/server.xml ${current_tomcat_base_folder}/conf/

    echo "getting jtapi from: $2"
    sudo /usr/bin/wget $2 -O /home/akkadianuser/jtapi.jar --no-check-certificate
    sudo yes | cp -Rf /home/akkadianuser/jtapi.jar ${current_tomcat_base_folder}/lib/jtapi-9.1.jar
    sudo rm -Rf /home/akkadianuser/jtapi.jar
    sleep 5
    sudo yes | cp -Rf ${current_server_folder}/acow-installer/jtapi.ini ${current_tomcat_base_folder}/lib/

    #getting /etc/systemd/system/tomcat.service memory and save it
    memory=$(sudo cat /etc/systemd/system/tomcat.service | grep "Environment='CATALINA_OPTS")
    sudo yes | cp -Rf ${current_server_folder}/configs/tomcat.service /etc/systemd/system/
    #setting memory into new file
    sudo sed -i "s/Environment="\'"CATALINA_OPTS.*/$memory/g" /etc/systemd/system/tomcat.service

    sudo yes | cp -Rf ${current_server_folder}/configs/my.cnf /etc/
    sudo yes | cp -Rf ${current_server_folder}/configs/mysqld.service /usr/lib/systemd/system/

    echo $'\n' "reloading daemon..."
    sudo systemctl daemon-reload

    if [[ ! -f /opt/akkadian/data/replica ]];
    then
        sudo echo " " > /home/akkadian/data/replica
        sudo chmod 666 /home/akkadian/data/replica
    else
        sudo chmod 600 /opt/akkadian/data/mongokey
        sudo chmod 666 /home/akkadian/data/replica
    fi


    #sudo sh /home/akkadianuser/scripts/start_kestrel.sh
    echo $'\n' "Running Mongo scripts..."
    #use admin; db.adminCommand({setParameter: 1, internalQueryExecMaxBlockingSortBytes:50151432})

    echo "Restoring certificates"
    sudo yes | cp -Rf /opt/akkadian/data/tmp/aco-server.crt /opt/akkadian/aco-server/certificates/aco-server.crt
    sudo yes | cp -Rf /opt/akkadian/data/tmp/aco-server.csr /opt/akkadian/aco-server/certificates/aco-server.csr
    sudo yes | cp -Rf /opt/akkadian/data/tmp/aco-server.key /opt/akkadian/aco-server/certificates/aco-server.key

    # in case mongo is set with replica
    sudo yes | cp -Rf /opt/akkadian/data/tmp/start-mongodb.sh /opt/akkadian/aco-server/scripts/start-mongodb.sh
fi


if [[ "${web_flag}" -eq 1 ]]; then
    echo $'\n' "Updating ACO WEB..."

    sudo sh /home/akkadianuser/scripts/stop_tomcat.sh

    sudo rm ${current_web_folder}/${web_updater_file}
    sudo rm -Rf ${current_web_folder}/acow-webapp

    sudo cp ${current_tmp_release_folder}/${web_updater_file} ${current_web_folder}/

    sudo mysql -uroot -paCOAkk4di4n! -e "DROP DATABASE fp;"
    sudo mysql -uroot -paCOAkk4di4n! -e "CREATE DATABASE fp;"

    sudo chmod -R 0666 /opt/tomcat/logs
    sudo rm -rf /opt/tomcat/logs/*

    #sudo sh /home/akkadianuser/scripts/start_tomcat.sh

fi

if [[ ! -d /opt/akkadian/aco-server/external_certificates ]]; then
    sudo mkdir /opt/akkadian/aco-server/external_certificates
fi

echo $'\n' "Cleaning..."
sudo rm -Rf ${current_tmp_release_folder}/*
echo $'\n' "DONE!"
sleep 3

sudo systemctl stop aco-server
sleep 1
sudo systemctl start aco-server
sleep 2
sudo systemctl restart tomcat
