#!/usr/bin/env bash

rm -Rf *.tar.gz

hash=$(git rev-parse --short HEAD)
v=$(echo 'aam_version=3.2.0-'$hash)
vv=$(echo '3.2.0-'$hash)
version=$(echo "$v")

#MACOS
#sed -i '' "s/^aam_version=.*/$version/g" mapper.ini
#LINUX
sed -i "s/aam_version=.*/$version/g" mapper.ini

touch tui-$vv.tar.gz
touch tui-$vv-enc.tar.gz

#old cli used sha256, new md5
echo "parameter received is: $1"
if [[ -z "$1" ]]; then
    echo "building without cipher"
    tar --exclude='.git' --exclude='.idea' --exclude='.DS_Store' --exclude=tui-$vv.tar.gz --exclude=tui-$vv-enc.tar.gz -zcf - * | openssl enc -e -aes-256-cbc -out tui-$vv-enc.tar.gz -pass pass:'HtBr6QckqJPk4rpatyUNT594'
else
    echo "building with cipher: $1"
    tar --exclude='.git' --exclude='.idea' --exclude='.DS_Store' --exclude=tui-$vv.tar.gz --exclude=tui-$vv-enc.tar.gz -zcf - * | openssl enc -e -aes-256-cbc -md $1 -out tui-$vv-enc.tar.gz -pass pass:'HtBr6QckqJPk4rpatyUNT594'
fi

sleep 5
echo "generating non enc file:"
tar --exclude='.git' --exclude='.idea' --exclude='.DS_Store' --exclude=tui-$vv.tar.gz --exclude=tui-$vv-enc.tar.gz --exclude=tui-$vv-enc.tar.gz --warning=no-file-changed -zcvf tui-$vv.tar.gz .

#uncompress
#openssl enc -d -aes-256-cbc -in tui-enc-55.tar.gz -pass pass:'HtBr6QckqJPk4rpatyUNT594' | tar xz -C test