import os
from pdb import set_trace

import click
import subprocess
import time
import shutil
import socket
import signal
import ConfigParser
import urllib2
import signal
import netifaces
import time
import sys
import threading
from datetime import date
from subprocess import Popen, PIPE
import re

try:
    import ConfigParser as configparser
except ImportError:
    import configparser

mapper = ConfigParser.RawConfigParser()
mapper.read('mapper.ini')


class Config(object):
    """The config for akkadianAppManager."""

    def __init__(self):
        self.path = os.getcwd()
        self.akkadianAppManager = {}

    def read_config(self, filename):
        parser = configparser.RawConfigParser()
        parser.read([filename])
        try:
            self.akkadianAppManager.update(parser.items('akkadianAppManager'))
        except configparser.NoSectionError:
            pass


pass_config = click.make_pass_decorator(Config, ensure=True)


class AliasedGroup(click.Group):
    """This subclass of a group supports looking up aliases in a config
    file and with a bit of magic.
    """

    def get_command(self, ctx, cmd_name):
        # Step one: bulitin commands as normal
        rv = click.Group.get_command(self, ctx, cmd_name)
        if rv is not None:
            return rv

        # Step two: find the config object and ensure it's there.  This
        # will create the config object is missing.
        cfg = ctx.ensure_object(Config)

        # Step three: lookup an explicit command aliase in the config
        if cmd_name in cfg.aliases:
            actual_cmd = cfg.aliases[cmd_name]
            return click.Group.get_command(self, ctx, actual_cmd)

        # Alternative option: if we did not find an explicit alias we
        # allow automatic abbreviation of the command.  "status" for
        # instance will match "st".  We only allow that however if
        # there is only one command.
        matches = [x for x in self.list_commands(ctx)
                   if x.lower().startswith(cmd_name.lower())]
        if not matches:
            return None
        elif len(matches) == 1:
            return click.Group.get_command(self, ctx, matches[0])
        ctx.fail('Too many matches: %s' % ', '.join(sorted(matches)))


def read_config(ctx, param, value):
    """Callback that is used whenever --config is passed.  We use this to
    always load the correct config.  This means that the config is loaded
    even if the group itself never executes so our aliases stay always
    available.
    """
    cfg = ctx.ensure_object(Config)
    if value is None:
        value = os.path.join(os.path.dirname(__file__), 'aliases.ini')
    cfg.read_config(value)
    return value


@click.command(cls=AliasedGroup)
@click.option('--config', type=click.Path(exists=True, dir_okay=False),
              callback=read_config, expose_value=False,
              help='The config file to use instead of the default.')
def cli():
    """Welcome to Akkadian Application Manager."""
    pass


@cli.command()
@click.pass_context
def menu(ctx):
    """Shows a simple menu."""
    menu = 'main'
    general_ctx = ctx
    ip = ''
    dns1 = ''
    dns2 = ''
    netmask = ''
    gateway = ''
    values_to_update = []
    interface = 'eth0'
    char = ''
    dhcp = None
    installed_app = ''

    def signal_handler(*args):
        try:
            print("signal handler modified")
            signal.siginterrupt()
            print("before starting")

            main_menu(char, ctx, dns1, dns2, gateway, interface, ip, menu, netmask, values_to_update, installed_app)
        except KeyboardInterrupt:
            print("signal handler modified 2")
            raise

        except:
            print("signal handler modified 3")
            main_menu(char, ctx, dns1, dns2, gateway, interface, ip, menu, netmask, values_to_update, installed_app)

    # signal.signal(signal.SIGINT, signal_handler)

    try:

        node_list = get_redundancy_nodelist()

        application = installed_app_vs2()

        if application == 'aco':
            installed_app = application
        else:
            installed_app = 'pme_cm'


        # Because this is starting
        # Cleanning master to be determined next time
        clean_old_master = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'truncateMaster')], stdout=PIPE,
                                            stderr=PIPE)

        for line in clean_old_master.stdout:
            old_master = line

        # Determine Replication type:
        if node_list != None and ' '.join(node_list.split()) != '' and \
                is_mastermaster_mastersalve_replication_enabled():
            replication_type = "master-master"
        elif (node_list == None or ' '.join(node_list.split()) == '') and \
                is_mastermaster_mastersalve_replication_enabled():
            replication_type = "master-slaves"
        else:
            replication_type = "undetermined"

        download_thread = threading.Thread(target=run_needed_scripts)
        download_thread.start()
        main_menu(char, ctx, dns1, dns2, gateway, interface, ip, menu, netmask, dhcp, values_to_update, installed_app,
                  replication_type)

    except click.Abort:
        menu = 'main'
        main_menu(char, ctx, dns1, dns2, gateway, interface, ip, menu, netmask, dhcp, values_to_update, installed_app,
                  replication_type)


def main_menu(char, ctx, dns1, dns2, gateway, interface, ip, menu, netmask, dhcp, values_to_update, installed_app,
              replication_type):
    is_cli_update = is_cli_update_available()

    while 1:
        try:
            if menu == 'main':
                aam_version = mapper.get('GeneralConfigs', 'aam_version')

                click.clear()
                click.secho('#########################################################', fg='yellow')
                click.secho('#                                                       #', fg='yellow')
                click.secho('# Welcome to Akkadian Appliance Manager - %s #' % aam_version, fg='yellow')
                click.secho('#                                                       #', fg='yellow')
                click.secho('#########################################################', fg='yellow')

                if is_cli_update:
                    file_name = getUpdate_name()

                    click.secho('New CLI update: ' + file_name, fg='green')
                    if click.confirm('Do you want to install it now?'):
                        # run it now!!
                        click.secho('CLI is being updated, please wait...', fg='green')
                        ctx.invoke(auto_update, "cli_updates")
                        is_cli_update = is_cli_update_available()
                    else:
                        is_cli_update = False

                else:

                    is_ha_on = is_ha_configured() and is_ha_enable()
                    node_list = get_redundancy_nodelist()

                    need_show_redundancy_info = installed_app == 'pme_cm' and \
                                                node_list != None and \
                                                ' '.join(node_list.split()) != '' and \
                                                is_mastermaster_mastersalve_replication_enabled()

                    need_show_replication_info = installed_app == 'pme_cm' and \
                                                 (node_list == None or \
                                                  ' '.join(node_list.split()) == '') and \
                                                 is_mastermaster_mastersalve_replication_enabled()

                    offline_nodes = get_offlines()

                    if is_ha_on:
                        click.secho('#########################################################', fg='blue')
                        click.secho(' High Availability is Enabled', fg='blue')
                        click.secho(' Master Node: %s ' % get_master(), fg='blue')
                        click.secho(' Online: %s ' % get_onlines(), fg='green')
                        virtual_ip = get_virtual_ip()
                        click.secho(' VIP: %s ' % virtual_ip, fg='green')

                        if ' '.join(offline_nodes.split()) != '':
                            click.secho(' Offline: %s ' % offline_nodes, fg='red')

                        if not need_show_redundancy_info:
                            click.secho('#########################################################', fg='blue')

                    if need_show_redundancy_info:
                        if not is_ha_on:
                            click.secho('#########################################################', fg='blue')

                        click.secho(' Master-Master Database Replication is Enabled', fg='blue')
                        click.secho(' Nodes: %s ' % get_redundancy_nodelist(), fg='blue')
                        click.secho(' Online: %s ' % get_redundancy_online(), fg='green')

                        offline_nodes = get_redundancy_offline()

                        if offline_nodes and ' '.join(offline_nodes.split()) != '':
                            click.secho(' Offline: %s ' % offline_nodes, fg='red')

                        click.secho('#########################################################', fg='blue')
                    elif need_show_replication_info:
                        if not is_ha_on:
                            click.secho('#########################################################', fg='blue')

                        click.secho(' Master-Slave Database Replication is Enabled', fg='blue')
                        click.secho('#########################################################', fg='blue')

                    click.secho('Main Menu:', fg='green')
                    click.secho('  1: Configure Network', fg='green')
                    click.secho('  2: Configure Time', fg='green')
                    click.secho('  3: Update Akkadian Products', fg='green')
                    click.secho('  4: Product Settings Menu', fg='green')
                    click.secho('  5: Appliance Manager Settings', fg='green')
                    click.secho('  6: High Availability', fg='green')
                    if installed_app == 'pme_cm':
                        click.secho('  7: Replication Support - Maintenance Mode', fg='green')
                        click.secho('  8: Akkadian Executor', fg='green')
                    else:
                        click.secho('  7: Akkadian Executor', fg='green')

                    click.secho('  r: Reboot Server', fg='green')
                    click.secho('  s: Shutdown Server', fg='green')
                    click.secho('  q: Quit Akkadian Appliance Manager', fg='red')
                    click.secho('  You can press \'CTRL+C\' at any time to exit from an action\n'
                                'and return to the previous menu.', fg='yellow')

                    click.secho('\nUse the following url to access the application')
                    click.secho('Secure URL, https://%s\n' % get_ip())

                    char = show_select_option(char)

                    if char == '1':
                        menu = 'select-interface'
                    elif char == '2':
                        menu = 'time'
                    elif char == '3':
                        menu = 'update_applications'
                    elif char == '4':
                        menu = 'general'
                    elif char == '5':
                        menu = 'autoupdate'
                    elif char == '6':
                        menu = 'high_availability'
                    elif char == '7':
                        if installed_app == 'pme_cm':
                            menu = 'ha_manage_sync'
                        else:
                            menu = 'akkadian_executor'
                    elif char == '8':
                        menu = 'akkadian_executor'

                    elif char == 'r':
                        menu = 'reboot'
                    elif char == 's':
                        menu = 'shutdown'
                    # elif char == 'c':
                    #    menu = 'crontomcat'
                    elif char == 'q':
                        menu = 'quit'
                    else:
                        click.echo('Invalid input')

            elif menu == 'akkadian_executor':

                click.clear()
                click.secho('Akkadian Executor Management', fg='green')

                click.secho('1: Stop Akkadian Executor', fg='green')
                click.secho('2: Start Akkadian Executor', fg='green')
                click.secho('3: See Akkadian Executor Status', fg='green')

                click.secho('b: Back to Main Menu', fg='red')
                click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                            'and return to the previous menu.', fg='yellow')

                char = show_select_option(char)
                try:
                    if char == '1':
                        ctx.invoke(stop_akkadian_executor)
                    elif char == '2':
                        ctx.invoke(start_akkadian_executor)
                    elif char == '3':
                        ctx.invoke(status_akkadian_executor)
                    elif char == 'b':
                        menu = 'main'

                except click.Abort:
                    print('click.Abort')
                    menu = 'autoupdate'
                    continue
                except:
                    menu = 'main'
                    continue


            elif menu == 'autoupdate':
                click.clear()
                click.secho('Update Akkadian Appliance Manager', fg='green')
                click.secho('0: Current Appliance Manager Version', fg='green')
                click.secho('1: Update Appliance Manager Using URL/Local Media', fg='green')
                click.secho('2: Restart Appliance Manager', fg='green')
                click.secho('3: Change Appliance Manager user Password', fg='green')
                click.secho('4: Change folder owner', fg='green')

                if is_snmp_enabled():
                    click.secho('5: Disable SNMP', fg='green')
                    click.secho('6: Edit SNMP', fg='green')

                    if is_encryption_enabled():
                        click.secho('7: Disable Encryption mode', fg='green')
                    else:
                        click.secho('7: Enable Encryption mode', fg='green')

                    if not is_snmpv3_enable():
                        click.secho('8: Enable SNMPv3', fg='green')

                else:
                    click.secho('5: Enable SNMP', fg='green')
                    if is_encryption_enabled():
                        click.secho('6: Disable Encryption mode', fg='green')
                    else:
                        click.secho('6: Enable Encryption mode', fg='green')

                # click.secho('5: Enable advanced SSL settings in web interface', fg='green')
                click.secho('b: Back to Main Menu', fg='red')
                click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                            'and return to the previous menu.', fg='yellow')
                char = show_select_option(char)
                try:
                    if char == '0':

                        aam_version = mapper.get('GeneralConfigs', 'aam_version')

                        click.clear()
                        click.secho('******************************', fg='green')
                        click.secho('Current Appliance Manager Version', fg='green')
                        click.echo('version: %s' % aam_version)
                        click.secho('******************************', fg='green')
                        click.pause('Please press any key to continue...')

                    elif char == '1':
                        try:
                            is_cli_update = is_cli_update_available()
                            if is_cli_update:
                                click.secho(' There is a new CLI update', fg='green')
                                if click.confirm('Do you want to install it from the default location?'):
                                    # run it now!!
                                    ctx.invoke(auto_update, "cli_updates")
                                    menu = 'main'
                                else:
                                    is_cli_update = False

                            if not is_cli_update:
                                zipinstaller = click.prompt(
                                    'Please enter the URL/Path for the CLI update files (tar.gz file)',
                                    type=str)
                                if os.path.exists(zipinstaller) or exists(zipinstaller):
                                    ctx.invoke(auto_update, zipinstaller)
                                    menu = 'autoupdate'
                                else:
                                    click.pause('Invalid URL/Local Media. Please try again.')

                        except click.Abort:
                            menu = 'autoupdate'

                    elif char == '2':
                        if click.confirm('Are you sure you want to restart? '
                                         'All users of the Command Line Interface will be logged out.'
                                         'Please ensure you have saved all your changes before committing.'):
                            ctx.invoke(kick_off)

                    elif char == '3':
                        subprocess.call(['passwd', 'akkadianuser'])

                    elif char == '4':
                        try:
                            path = click.prompt('Folder', type=str)
                            if click.confirm('You are about to change owner for ' + path + ' Do you want to continue?'):
                                ctx.invoke(chown, path)
                        except click.Abort:
                            menu = 'autoupdate'

                    # elif char == '5':
                    #    try:
                    #        path = '/etc/pki/'
                    #        if click.confirm('You are about to enable advanced SSL settings in the web interface. '
                    #            ctx.invoke(chown, path)

                    #    except click.Abort:
                    #        menu = 'autoupdate'

                    elif char == '5':
                        if is_snmp_enabled():
                            disable_snmp()
                        else:
                            enable_snmp()
                    elif char == '6':
                        if is_snmp_enabled():
                            ctx.invoke(edit_snmp_configs)
                        else:
                            if is_encryption_enabled():
                                ctx.invoke(disable_encryption_mode)
                            else:
                                ctx.invoke(enable_encryption_mode)
                    elif char == '7':
                        if is_encryption_enabled():
                            ctx.invoke(disable_encryption_mode)
                        else:
                            ctx.invoke(enable_encryption_mode)
                    elif char == '8':
                        ctx.invoke(enable_snmpv3)

                    elif char == 'b':
                        menu = 'main'

                except click.Abort:
                    print('click.Abort')
                    menu = 'autoupdate'
                    continue

            elif menu == 'general':
                click.clear()
                click.secho('Products Settings', fg='green')
                click.secho('1: Akkadian PM/HCS Services', fg='green')
                click.secho('2: Akkadian Console Operator Services', fg='green')
                click.secho('3: Akkadian Contact Manager Services', fg='green')
                click.secho('b: Back to Main Menu', fg='red')
                click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                            'and return to the previous menu.', fg='yellow')

                char = show_select_option(char)

                if char == 'b':
                    menu = 'main'

                elif char == '1':
                    pme = subprocess.Popen(["sh", mapper.get('ApplicationScripts', 'pmeVersion')], stdout=PIPE,
                                           stderr=PIPE)
                    for line in pme.stdout:
                        pme_version = line

                    if pme_version == '\n':
                        click.clear()
                        click.pause('PME is not installed. Please press any key to continue...')
                    else:
                        menu = 'pme_services'

                elif char == '2':
                    aco = subprocess.Popen(["sh", mapper.get('ApplicationScripts', 'acoServerVersion')], stdout=PIPE,
                                           stderr=PIPE)
                    for line in aco.stdout:
                        aco_version = line

                    if aco_version == '\n':
                        click.clear()
                        click.pause('ACO is not installed. Please press any key to continue...')
                    else:
                        menu = 'aco_services'

                elif char == '3':
                    try:
                        cm = subprocess.Popen(["sh", mapper.get('ApplicationScripts', 'cmVersion')], stdout=PIPE,
                                              stderr=PIPE)
                        for line in cm.stdout:
                            cm_version = line

                        if cm_version == '\n':
                            click.clear()
                            click.pause('CM is not installed. Please press any key to continue...')
                        else:
                            menu = 'cm_services'
                    except:
                        click.pause('CM is not installed. Please press any key to continue...')
                        menu = 'general'


            elif menu == 'time':
                click.clear()
                click.secho('Time Configurations', fg='green')
                click.secho('0: Current Time Status', fg='green')
                click.secho('1: NTP Stop Sync Up Service', fg='green')
                click.secho('2: NTP Start and Sync Up Service', fg='green')
                click.secho('3: NTP Set Sync Servers', fg='green')
                click.secho('4: Set Date Manually', fg='green')
                click.secho('5: Set Time Zone Manually', fg='green')
                click.secho('6: Remove Time Zone (Set to UTC)', fg='green')
                click.secho('7: Install NTP service', fg='green')
                click.secho('b: Back to Main Menu', fg='red')
                click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                            'and return to the previous menu.', fg='yellow')

                char = show_select_option(char)

                if char == '0':

                    try:
                        ntp_status_ = ntp_status()
                        ntp_servers = get_servers_ntp_file(mapper.get('GeneralConfigs', 'ntp_file'))

                        p = subprocess.Popen(["sh", mapper.get('DateScripts', 'getDate')], stdout=PIPE, stderr=PIPE)
                        for line in p.stdout:
                            date = line

                        p = subprocess.Popen(["sh", mapper.get('DateScripts', 'getTimeZone')], stdout=PIPE, stderr=PIPE)
                        for line in p.stdout:
                            timezone = line
                        click.clear()
                        click.secho('******************************', fg='green')
                        click.secho('Current Time Status', fg='green')

                        if ntp_status_ < 16:
                            click.echo('NTP Status: SYNCHRONIZED')
                        else:
                            click.echo('NTP Status: NOT SYNCHRONIZED')

                        click.echo('\nNTP Sync Servers: ')
                        click.echo(''.join(map(str, ntp_servers)))

                        if date == '\n':
                            click.echo('Current Date: is not configured')
                        else:
                            click.echo('Current Date: %s' % date)

                        if timezone == '\n':
                            click.echo('Current Time Zone: is not configured')
                        else:
                            click.echo('Current Time Zone: %s' % timezone)

                        click.secho('******************************', fg='green')
                        click.pause('Please press any key to continue...')
                    except:
                        click.pause(
                            'There was a problem getting time settings, please install ntp (option 7), press any key to continue')
                        menu = 'time'



                elif char == '1':
                    ctx.invoke(stop_ntp)
                    if click.confirm('Do you want to remove the Time Zone? (This will set the time to UTC.)'):
                        ctx.invoke(delete_timezone)

                elif char == '2':
                    ctx.invoke(start_ntp)
                    if click.confirm('Do you want to change the Time Zone?'):
                        menu = change_timezone(ctx, menu)

                elif char == '3':
                    menu = 'sync-servers'

                elif char == '4':
                    try:
                        click.pause('Please enter the GMT date and time for the system time in the following format:\n'
                                    'YYYYMMDDhhmm\n(ex. 201508151500, equivalent to 2015-08-15 3:00 PM GMT).\n\n'
                                    'Date must also occur after year 2000 CE).\n\n'
                                    'Note that this will stop NTP sync in case NTP service is up and running.\n'
                                    'Press any key...')

                        date = click.prompt('Date', type=str)

                        while len(date) != 12 or not date.isdigit() or int(date[:4]) < 2000:
                            date = click.prompt('Invalid Date.\nPlease enter the GMT date for the system time in the '
                                                'following format:\nYYYYMMDDhhmm\n(ex. 201508151500, equivalent to '
                                                '2015-08-15 3:00 PMGMT).\n\n '
                                                'Date must also occur after year 2000 CE).\n\n'
                                                'Note that this will stop NTP sync in case NTP service is up and'
                                                'running.\nDate', type=str)

                        date_to_send = date[4:] + date[:4]
                        ctx.invoke(set_date, date=date_to_send)

                        if click.confirm('Do you want to change the Time Zone?'):
                            menu = change_timezone(ctx, menu)

                    except click.Abort:
                        menu = 'time'

                elif char == '5':
                    _ = change_timezone(ctx, menu)

                elif char == '6':
                    ctx.invoke(delete_timezone)

                elif char == '7':
                    ctx.invoke(install_ntp)

                elif char == 'b':
                    menu = 'main'

            elif menu == 'sync-servers':
                click.clear()
                click.secho('Modify NTP Servers Menu...', fg='yellow')
                click.secho('1: Add NTP Servers', fg='green')
                click.secho('2: Review NTP Servers', fg='green')
                click.secho('3: Save NTP Servers', fg='green')
                click.secho('b: Back to Configure Time Menu', fg='red')
                click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                            'and return to the previous menu.', fg='yellow')

                try:
                    char = show_select_option(char)

                    if char == '1':
                        try:
                            if len(values_to_update) == 4:
                                if click.confirm('The NTP servers have already been configured. '
                                                 'Do you want to modify your changes?'):
                                    values_to_update = updateNTPServers(values_to_update)
                            else:
                                values_to_update = updateNTPServers(values_to_update)

                            if len(values_to_update) > 0:
                                click.secho('[OK] NTP Servers Ready to be Saved', fg="yellow")
                            else:
                                click.secho('[FAIL] Servers have not being collected', fg="red")

                        except click.Abort:
                            menu = 'sync-servers'

                    elif char == '2':
                        menu = 'review_ntp_servers'

                    elif char == '3':
                        try:
                            if click.confirm('Are you sure you want to save the configurations for the NTP servers?'):
                                if len(values_to_update) > 0:
                                    res = set_servers_ntp_file(mapper.get('GeneralConfigs', 'ntp_file'),
                                                               values_to_update)
                                    if res:
                                        click.secho('[OK] NTP Servers Updated', fg="yellow")
                                    else:
                                        click.secho('[FAIL] NTP Servers Not Updated', fg="red")

                                else:
                                    click.secho('Please specify Servers')
                        except click.Abort:
                            menu = 'sync-servers'

                    elif char == 'b':
                        try:
                            if click.confirm(
                                    'Are you sure you want to exit?\nAny unsaved changes will not be preserved.'):
                                menu = 'time'
                        except click.Abort:
                            menu = 'sync-servers'

                except KeyboardInterrupt:
                    menu = 'time'
                    continue

            elif menu == 'review_ntp_servers':
                click.clear()
                try:
                    click.secho('Current NTP Servers to be Saved', fg='yellow')

                    for i in range(len(values_to_update)):
                        click.secho('Server %s' % str(i) + ': ' + values_to_update[i], fg='green')

                    click.pause('Press any key to continue...')
                    menu = 'sync-servers'

                    # char = show_select_option(char)
                    # if char == 'b':
                    #     menu = 'sync-servers'
                except click.Abort:
                    menu = 'sync-servers'

            elif menu == 'update_applications':
                pme = subprocess.Popen(["sh", mapper.get('ApplicationScripts', 'pmeVersion')], stdout=PIPE,
                                       stderr=PIPE)

                aco_server = subprocess.Popen(["sh", mapper.get('ApplicationScripts', 'acoServerVersion')],
                                              stdout=PIPE, stderr=PIPE)

                aco_web = subprocess.Popen(["sh", mapper.get('ApplicationScripts', 'acoWebVersion')], stdout=PIPE,
                                           stderr=PIPE)

                cm = subprocess.Popen(["sh", mapper.get('ApplicationScripts', 'cmVersion')], stdout=PIPE,
                                      stderr=PIPE)

                for line in pme.stdout:
                    pme_version = line

                for line in aco_server.stdout:
                    aco_server_version = line

                for line in aco_web.stdout:
                    aco_web_version = line

                for line in cm.stdout:
                    cm_version = line

                if installed_app == "pme":
                    click.echo('APM version: %s' % pme_version)
                    menu = 'update_pme'
                elif installed_app == "aco":
                    click.echo('ACO version: %s' % aco_server_version)
                    menu = 'update_aco'
                elif installed_app == "cm":
                    click.echo('ACM version: %s' % cm_version)
                    menu = 'update_cm'
                else:

                    line = ''
                    pme_version = line
                    aco_server_version = line
                    aco_web_version = line
                    cm_version = line


                    click.clear()
                    click.secho('Akkadian Labs Products', fg='green')
                    click.secho('0: Current Application Versions', fg='green')
                    click.secho('1: Update Akkadian Provisioning Manager', fg='green')
                    click.secho('2: Update Akkadian Console Operator', fg='green')
                    click.secho('3: Update Akkadian Contact Manager', fg='green')
                    click.secho('4: Push Akkadian Products to Remote', fg='green')
                    click.secho('5: Akkadian Universal Updater Menu', fg='green')
                    click.secho('b: Back to Main Menu', fg='red')
                    click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                                'and return to the previous menu.', fg='yellow')

                    char = show_select_option(char)

                    if char == 'b':
                        menu = 'main'

                    elif char == '0':
                        pme = subprocess.Popen(["sh", mapper.get('ApplicationScripts', 'pmeVersion')], stdout=PIPE,
                                               stderr=PIPE)

                        aco_server = subprocess.Popen(["sh", mapper.get('ApplicationScripts', 'acoServerVersion')],
                                                      stdout=PIPE, stderr=PIPE)

                        aco_web = subprocess.Popen(["sh", mapper.get('ApplicationScripts', 'acoWebVersion')],
                                                   stdout=PIPE,
                                                   stderr=PIPE)

                        cm = subprocess.Popen(["sh", mapper.get('ApplicationScripts', 'cmVersion')], stdout=PIPE,
                                              stderr=PIPE)

                        for line in pme.stdout:
                            pme_version = line

                        for line in aco_server.stdout:
                            aco_server_version = line

                        for line in aco_web.stdout:
                            aco_web_version = line

                        for line in cm.stdout:
                            cm_version = line

                        click.clear()
                        click.secho('******************************', fg='green')

                        click.secho('Current PME Version', fg='green')
                        if pme_version== '' or pme_version == '\n':
                            click.echo('pme is not installed\n')
                        else:
                            click.echo('version: %s' % pme_version)

                        click.secho('Current ACO SERVER Version', fg='green')
                        if aco_server_version == '' or aco_server_version == '\n':
                            click.echo('aco server is not installed\n')
                        else:
                            click.echo('version: %s' % aco_server_version)

                        click.secho('Current ACO WEB Version', fg='green')
                        if aco_web_version == '' or aco_web_version == '\n':
                            click.echo('aco web is not installed\n')
                        else:
                            click.echo('version: %s' % aco_web_version)

                        click.secho('Current ACM Version', fg='green')
                        if cm_version == '' or cm_version == '\n':
                            click.echo('Contact Manager is not installed\n')
                        else:
                            click.echo('version: %s' % cm_version)

                        click.secho('******************************', fg='green')
                        click.pause('Please press any key to continue...')

                    elif char == '1':
                        pme = subprocess.Popen(["sh", mapper.get('ApplicationScripts', 'pmeVersion')], stdout=PIPE,
                                               stderr=PIPE)

                        pme_version = ''
                        for line in pme.stdout:
                            pme_version = line

                        if pme_version == '' or pme_version == '\n':
                            click.clear()
                            click.pause('PME is not installed. Please press any key to continue...')
                        else:
                            menu = 'update_pme'

                    elif char == '2':
                        aco = subprocess.Popen(["sh", mapper.get('ApplicationScripts', 'acoServerVersion')],
                                               stdout=PIPE,
                                               stderr=PIPE)
                        for line in aco.stdout:
                            aco_version = line

                        if aco_version == '' or aco_version == '\n':
                            click.clear()
                            click.pause('ACO is not installed. Please press any key to continue...')
                        else:
                            menu = 'update_aco'

                    elif char == '3':
                        cm = subprocess.Popen(["sh", mapper.get('ApplicationScripts', 'cmVersion')], stdout=PIPE,
                                              stderr=PIPE)
                        for line in cm.stdout:
                            cm_version = line

                        if cm_version == '' or cm_version == '\n':
                            click.clear()
                            click.pause('ACM is not installed. Please press any key to continue...')
                        else:
                            menu = 'update_cm'
                    elif char == '4':
                        menu = 'push_installation'
                    elif char == '5':
                        menu = 'aUU_menu'
                    else:
                        click.echo('Invalid input')

            elif menu == 'aUU_menu':
                click.clear()
                click.secho('1: Disable Akkadian Universal Updater', fg='green')
                click.secho('2: Enable Akkadian Universal Updater', fg='green')
                click.secho('b. Back to Main Menu', fg='red')

                click.secho(
                    'You can press \'CTRL+C\' at any time to exit from an action\nand return to the previous menu.',
                    fg='yellow')
                char = show_select_option(char)
                try:
                    if char == 'b':
                        menu = 'main'
                    elif char == '1':
                        disable_auu_in_pme()
                    elif char == '2':
                        enable_auu_in_pme()

                except click.Abort:
                    menu = 'main'

            elif menu == 'select-interface':
                interfaces = get_network_interface()
                for i in range(len(interfaces)):
                    click.secho('%s' % i + '.' + interfaces[i], fg='green', nl=False)
                click.secho('b. Back to Main Menu', fg='red')
                try:
                    index = click.prompt('Please select a network interface to configure', type=str)
                    if index == 'b':
                        menu = 'main'

                    elif index.isdigit() and int(index) < len(interfaces):
                        click.echo('setting...')
                        interface = interfaces[int(index)].rstrip()
                        menu = 'network'
                    else:
                        click.echo(
                            'Invalid Selection. Please select a number assocaited with an interface in the list.')

                except click.Abort:
                    menu = 'main'

            elif menu == 'network':
                click.clear()
                click.secho('Update Network Configs', fg='green')
                click.secho('1: Review Current Network Configurations', fg='green')
                #click.secho('1: Configure Network', fg='green')
                #click.secho('2: Change IPv4 Address', fg='green')
                #click.secho('3: Change IPv4 Primary DNS', fg='green')
                #click.secho('4: Change IPv4 Secondary DNS', fg='green')
                #click.secho('5: Change IPv4 Netmask', fg='green')
                #click.secho('6: Change IPv4 Gateway', fg='green')
                #click.secho('7: Change Hostname', fg='green')
                click.secho('2: Network Settings (nmtui tool)', fg='green')
                click.secho('3: Change proxy configurations', fg='green')
                click.secho('4: Ping Host or IP (ICMP)', fg='green')
                #click.secho('5 r: Review Configuration Changes', fg='green')
                #click.secho('5: Save Configuration Changes', fg='green')
                click.secho('5: Stop Network', fg='green')
                click.secho('6: Start Network', fg='green')
                click.secho('7: Restart Network', fg='green')
                click.secho('b: Back to Main Menu', fg='red')
                click.secho(
                    'You can press \'CTRL+C\' at any time to exit from an action\nand return to the previous menu.',
                    fg='yellow')
                char = show_select_option(char)

                if char == '1':
                    if is_interface_up(interface):
                        addrs = netifaces.ifaddresses(interface)

                        ipv4 = addrs[netifaces.AF_INET][0].get('addr')
                        ipv4_netmask = addrs[netifaces.AF_INET][0].get('netmask')

                        ipv6 = addrs[netifaces.AF_INET6][0].get('addr')
                        ipv6_netmask = addrs[netifaces.AF_INET6][0].get('netmask')

                        gws = netifaces.gateways()

                        gateway = gws['default'][netifaces.AF_INET][0]

                        # dns_ips = []
                        lines = open(mapper.get('GeneralConfigs', 'network_interface_file') + interface,
                                     'r').readlines()
                        primary_dns = ''
                        secondary_dns = ''

                        for line in lines:
                            columns = line.split('=')
                            if columns[0] == 'DNS1':
                                primary_dns = columns[1]
                            if columns[0] == 'DNS2':
                                secondary_dns = columns[1]

                                # dns_ips.extend(columns[1:])

                        # primary_dns = dns_ips[0]
                        # secondary_dns = dns_ips[1]

                        # hostname = ctx.invoke(get_current_hostname)

                        click.clear()
                        click.secho('******************************', fg='green')
                        click.secho('Current Network Status & Configurations', fg='green')
                        if (ipv4 is not None) and ipv4 != '':
                            click.echo('Current IPv4:               %s' % ipv4)
                        if (ipv4_netmask is not None) and ipv4_netmask != '':
                            click.echo('Current IPv4 Netmask:       %s' % ipv4_netmask)
                        # click.echo('Current IPv6: %s' %ipv6)
                        # click.echo('Current IPv6 Netmask: %s' %ipv6_netmask)
                        if (primary_dns is not None) and primary_dns != '':
                            click.echo('Current IPv4 Primary DNS:   %s' % primary_dns)
                        if (secondary_dns is not None) and secondary_dns != '':
                            click.echo('Current IPv4 Secondary DNS: %s' % secondary_dns)
                        if (gateway is not None) and gateway != '':
                            click.echo('Current IPv4 Gateway:       %s' % gateway)
                        click.echo('Current Hostname:')
                        ctx.invoke(get_current_hostname)
                        click.secho('******************************', fg="green")
                        click.pause('Please press any key to continue...')
                    else:
                        click.clear()
                        click.secho('******************************', fg='green')
                        click.secho('Current Network Status & Configurations', fg='green')
                        click.secho('Network Interface is Offline')
                        click.secho('******************************', fg='green')
                        click.pause('Please press any key to continue...')
                        menu = 'network'

                elif char == '2':
                    ctx.invoke(nmtui)
                elif char == '3':
                    try:
                        ctx.invoke(edit_proxy)
                        restart_network(ctx, interface)
                    except click.Abort:
                        menu = 'network'
                elif char == '4':
                    try:
                        host = click.prompt('Ping Host or IP Enter Hostname or IP')
                        #TODO: how to validate this since it can be a hostname???
                        ping(host)

                    except KeyboardInterrupt:
                        menu = 'network'
                        continue
                #elif char == '5':
                #    menu = 'save_changes'

                # elif char == '6':
                #     try:
                #         click.clear()
                #         click.secho('******************************', fg="green")
                #         ctx.invoke(get_current_hostname)
                #         click.secho('******************************', fg="green")
                #         new_hostname = click.prompt('New Hostname')
                #         ctx.invoke(change_hostname, new_hostname)
                #         click.pause('New Hostname set! Press any key to continue...')
                #
                #     except click.Abort:
                #         menu = 'network'

                elif char == '5':
                    try:
                        if click.confirm(
                                'Are you sure you want to stop this network interface? If this is your primary network interface, you may lose connection to this command prompt. '):
                            ctx.invoke(network_stop, interface)
                    except click.Abort:
                        menu = 'network'
                elif char == '6':
                    try:
                        if click.confirm('Are you sure you want to start this network interface? '):
                            ctx.invoke(network_start, interface)
                    except click.Abort:
                        menu = 'network'
                elif char == '7':
                    try:
                        if click.confirm(
                                'Are you sure you want to restart this network interface? If this is your primary network interface, you may lose connection to this command prompt. '):
                            ctx.invoke(network_restart, interface)
                    except click.Abort:







                #if char == 'r':
                #    menu = 'show_changes'
                # elif char == '1':
                #     if is_interface_up(interface):
                #         addrs = netifaces.ifaddresses(interface)
                #
                #         ipv4 = addrs[netifaces.AF_INET][0].get('addr')
                #         ipv4_netmask = addrs[netifaces.AF_INET][0].get('netmask')
                #
                #         ipv6 = addrs[netifaces.AF_INET6][0].get('addr')
                #         ipv6_netmask = addrs[netifaces.AF_INET6][0].get('netmask')
                #
                #         gws = netifaces.gateways()
                #
                #         gateway = gws['default'][netifaces.AF_INET][0]
                #
                #         # dns_ips = []
                #         lines = open(mapper.get('GeneralConfigs', 'network_interface_file') + interface,
                #                      'r').readlines()
                #         primary_dns = ''
                #         secondary_dns = ''
                #
                #         for line in lines:
                #             columns = line.split('=')
                #             if columns[0] == 'DNS1':
                #                 primary_dns = columns[1]
                #             if columns[0] == 'DNS2':
                #                 secondary_dns = columns[1]

                                # dns_ips.extend(columns[1:])

                        # primary_dns = dns_ips[0]
                        # secondary_dns = dns_ips[1]

                        # hostname = ctx.invoke(get_current_hostname)
                    #
                    #     click.clear()
                    #     click.secho('******************************', fg='green')
                    #     click.secho('Current Network Status & Configurations', fg='green')
                    #     if (ipv4 is not None) and ipv4 != '':
                    #         click.echo('Current IPv4:               %s' % ipv4)
                    #     if (ipv4_netmask is not None) and ipv4_netmask != '':
                    #         click.echo('Current IPv4 Netmask:       %s' % ipv4_netmask)
                    #     # click.echo('Current IPv6: %s' %ipv6)
                    #     # click.echo('Current IPv6 Netmask: %s' %ipv6_netmask)
                    #     if (primary_dns is not None) and primary_dns != '':
                    #         click.echo('Current IPv4 Primary DNS:   %s' % primary_dns)
                    #     if (secondary_dns is not None) and secondary_dns != '':
                    #         click.echo('Current IPv4 Secondary DNS: %s' % secondary_dns)
                    #     if (gateway is not None) and gateway != '':
                    #         click.echo('Current IPv4 Gateway:       %s' % gateway)
                    #     click.echo('Current Hostname:')
                    #     ctx.invoke(get_current_hostname)
                    #     click.secho('******************************', fg="green")
                    #     click.pause('Please press any key to continue...')
                    # else:
                    #     click.clear()
                    #     click.secho('******************************', fg='green')
                    #     click.secho('Current Network Status & Configurations', fg='green')
                    #     click.secho('Network Interface is Offline')
                    #     click.secho('******************************', fg='green')
                    #     click.pause('Please press any key to continue...')
                    #     menu = 'network'

                # elif char == '1':
                #     try:
                #         dhcp = None
                #         if click.confirm('Do you want to configure this as DHCP client?'):
                #             # write_new_configs('', '', '', '', '', 'dhcp', interface)
                #             dhcp = 'dhcp'
                #             click.pause(
                #                 '[OK] The Network Interface will need to be reset before configuration changes will apply to the interface.\n Press any key to continue...')
                #         else:
                #             if click.confirm('Do you want to configure IPv4?'):
                #                 ip = click.prompt('New IPv4 Address', type=str)
                #                 while reach_ip(ip) or not is_valid_ip(ip):
                #                     if reach_ip(ip):
                #                         if click.confirm(
                #                                 "The IP Address you entered is currently in use, do you want continue anyway? "):
                #                             break
                #                         else:
                #                             ip = click.prompt(
                #                                 "IPv4 address", type=str)
                #
                #                     elif not is_valid_ip(ip):
                #                         ip = click.prompt("Ip address is not valid, please enter a valid IPv4 address",
                #                                           type=str)
                #
                #             if click.confirm('Do you want to set the IPv4 Primary DNS?'):
                #                 dns1 = click.prompt('IPv4 Primary DNS Address', type=str)
                #                 while not is_valid_ip(dns1):
                #                     dns1 = click.prompt(
                #                         'Invalid IPv4 address. Please enter a valid IPv4 address for the new IPv4 Primary DNS address.',
                #                         type=str)
                #             if click.confirm('Do you want to set the IPv4 Secondary DNS?'):
                #                 dns2 = click.prompt('IPv4 Secondary DNS Address', type=str)
                #                 while not is_valid_ip(dns2):
                #                     dns2 = click.prompt(
                #                         'Invalid IPv4 address. Please enter a valid IPv4 address for the new IPv4 Secondary DNS address.',
                #                         type=str)
                #             if click.confirm('Do you want to set the IPv4 Network Mask?'):
                #                 netmask = click.prompt('IPv4 Netmask Address', type=str)
                #                 while not is_valid_ip(netmask):
                #                     netmask = click.prompt(
                #                         'Invalid IPv4 address. Please enter a valid IPv4 address to serve as the new IPv4 Netmask.',
                #                         type=str)
                #             if click.confirm('Do you want to set the IPv4 Gateway?'):
                #                 gateway = click.prompt('IPv4 Gateway Address', type=str)
                #                 while not is_valid_ip(gateway):
                #                     gateway = click.prompt(
                #                         'Invalid IPv4 address. Please enter a valid IPv4 address to for the new IPv4 Gateway address.',
                #                         type=str)
                #
                #         click.echo('\nChanges to be Saved\n')
                #         if dhcp == 'dhcp':
                #             click.echo('DHCP was configured succesfully')
                #         else:
                #             dhcp = 'none'
                #
                #         if ip != '':
                #             click.echo('IPv4 Address:       ' + ip)
                #         if netmask != '':
                #             click.echo('IPv4 Netmask:       ' + netmask)
                #         if dns1 != '':
                #             click.echo('IPv4 Primary DNS:   ' + dns1)
                #         if dns2 != '':
                #             click.echo('IPv4 Secondary DNS: ' + dns2)
                #         if gateway != '':
                #             click.echo('IPv4 Gateway:       ' + gateway)
                #
                #         menu = 'save_changes'
                #
                #     except click.Abort:
                #         menu = 'network'
                #
                # elif char == '2':
                #     try:
                #         ip = click.prompt('New IPv4 Address', type=str)
                #         while reach_ip(ip) or not is_valid_ip(ip):
                #             if reach_ip(ip):
                #                 if click.confirm(
                #                         "The IP Address you entered is currently in use, do you want continue anyway? "):
                #                     break
                #                 else:
                #                     ip = click.prompt(
                #                         "IPv4 address", type=str)
                #
                #             elif not is_valid_ip(ip):
                #                 ip = click.prompt("Ip address is not valid, please enter a valid IPv4 address",
                #                                   type=str)
                #
                #         if click.confirm('New IPv4 IP Address: {0}\nDo you wish to save this change?.'.format(ip)):
                #             write_new_configs(ip, '', '', '', '', 'none', interface)
                #             click.pause(
                #                 'IPv4 Address saved! The Network Interface will need to be reset before configuration changes\nwill apply to the interface.\n Press any key to continue...')
                #
                #
                #     except click.Abort:
                #         menu = 'network'
                #
                # elif char == '3':
                #     try:
                #         dns1 = click.prompt('Enter New IPv4 Primary DNS Address', type=str)
                #         while not is_valid_ip(dns1):
                #             dns1 = click.prompt(
                #                 'Invalid IPv4 address. Please enter a valid IPv4 address for the IPv4 Primary DNS.',
                #                 type=str)
                #         if click.confirm('New IPv4 Primary DNS: {0}\nDo you wish to save this change?.'.format(dns1)):
                #             write_new_configs('', dns1, '', '', '', 'none', interface)
                #             click.pause(
                #                 'IPv4 Primary DNS saved! The Network Interface will need to be reset before configuration changes\nwill apply to the interface.\n Press any key to continue...')
                #
                #     except click.Abort:
                #         menu = 'network'
                #
                # elif char == '4':
                #     try:
                #         dns2 = click.prompt('Enter New IPv4 Secondary DNS Address', type=str)
                #         while not is_valid_ip(dns2):
                #             dns2 = click.prompt(
                #                 'Invalid IPv4 address. Please enter a valid IPv4 address for the IPv4 Secondary DNS.',
                #                 type=str)
                #         if click.confirm('New IPv4 Secondary DNS: {0}\nDo you wish to save this change?.'.format(dns2)):
                #             write_new_configs('', '', dns2, '', '', 'none', interface)
                #             click.pause(
                #                 'IPv4 Secondary DNS saved! The Network Interface will need to be reset before configuration changes\nwill apply to the interface.\n Press any key to continue...')
                #
                #     except click.Abort:
                #         menu = 'network'
                # elif char == '5':
                #     try:
                #         netmask = click.prompt('Enter new IPv4 Netmask Address', type=str)
                #         while not is_valid_ip(netmask):
                #             netmask = click.prompt(
                #                 'Invalid IPv4 address. Please enter a valid IPv4 address to server as the IPv4 Netmask.',
                #                 type=str)
                #         if click.confirm('New IPv4 Netmask: {0}\nDo you wish to save this change?.'.format(netmask)):
                #             write_new_configs('', '', '', netmask, '', 'none', interface)
                #             click.pause(
                #                 'IPv4 Netmask saved! The Network Interface will need to be reset before configuration changes\nwill apply to the interface.\n Press any key to continue...')
                #
                #     except click.Abort:
                #         menu = 'network'
                #
                # elif char == '6':
                #     try:
                #         gateway = click.prompt('Enter new IPv4 Gateway Address', type=str)
                #         while not is_valid_ip(gateway):
                #             gateway = click.prompt(
                #                 'Invalid IPv4 address. Please enter a valid IPv4 address for the IPv4 Gateway.',
                #                 type=str)
                #         if click.confirm('New IPv4 Gateway: {0}\nDo you wish to save this change?.'.format(gateway)):
                #             write_new_configs('', '', '', '', gateway, 'none', interface)
                #             click.pause(
                #                 'IPv4 Gateway saved! The Network Interface will need to be reset before configuration changes\nwill apply to the interface.\n Press any key to continue...')
                #
                #     except click.Abort:
                #         menu = 'network'


                        menu = 'network'

                elif char == 'b':
                    try:
                        if ip != '' or netmask != '' or dns1 != '' or dns2 != '' or gateway != '':
                            if click.confirm(
                                    'Do you want to leave this menu?\nAny unsaved changes will not be preserved.'):
                                ip = ''
                                netmask = ''
                                dns1 = ''
                                dns2 = ''
                                gateway = ''
                                menu = 'main'
                        else:
                            menu = 'main'

                    except click.Abort:
                        menu = 'network'


            elif menu == 'high_availability':
                click.clear()
                node_list = get_redundancy_nodelist()
                is_ha_on = is_ha_enable()

                if (installed_app != 'aco' and (node_list != None and ' '.join(
                        node_list.split()) != '') or is_mastermaster_mastersalve_replication_enabled()) and not is_ha_on:

                    click.secho('High Availability - External Load Balancer Actions', fg='green')

                    click.secho('1: Enable High Availability and VIP (external load balancer will not be used anymore)', fg='green')
                    click.secho('2: Set This Node as Master', fg='green')
                    click.secho('b: Back to Main Menu', fg='red')
                    click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                                'and return to the previous menu.', fg='yellow')

                    try:
                        char = show_select_option(char)

                        if char == 'b':
                            menu = 'main'
                        elif char == '1':
                            r = ctx.invoke(createHA, ctx, installed_app=installed_app)
                            if r == 'ok':
                                menu = 'high_availability'

                        elif char == '2':
                            force_master()

                    except click.Abort:
                        menu = 'main'
                        continue

                    except KeyboardInterrupt:
                        menu = 'main'
                        continue

                    #click.secho(
                        #    "Master-Master Database replication is enabled. However, High Availability and VIP are disabled",
                        #    fg='green')


                        #if click.confirm('Do you want to enable High Availability and VIP?'):
                            # char, menu, replication_type = run_create_HA(char, ctx, installed_app, menu,
                            #                                             replication_type)

                        #    r = ctx.invoke(createHA, ctx, installed_app=installed_app)
                        #    if r == 'ok':
                        #        menu = 'high_availability'
                        #else:
                        #    menu = 'main'

                elif is_ha_configured():
                    click.secho('High Availability Actions', fg='green')

                    click.secho('1: Current High Availability Status', fg='green')
                    click.secho('2: Manage Nodes', fg='green')
                    click.secho('3: Manage Resources', fg='green')
                    click.secho('4: Maintenance Mode', fg='green')
                    click.secho('5: Remove High Availability Cluster Config', fg='green')
                    click.secho('6: Database Replication Settings', fg='green')

                    click.secho('b: Back to Main Menu', fg='red')
                    click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                                'and return to the previous menu.', fg='yellow')

                    try:
                        char = show_select_option(char)

                        if char == 'b':
                            menu = 'main'

                        # elif char == '0':
                        #    ctx.invoke(ha_enable)
                        # backup_db_in_ha.sh    menu = 'high_availability'

                        elif char == '1':
                            p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'haStatus')], stdout=PIPE,
                                                 stderr=PIPE)

                            ha_status_lines = []
                            for line in p.stdout:
                                print(line)
                                ha_status_lines.append(line)

                            click.clear()
                            click.secho('******************************', fg='green')
                            click.secho('Current High Availability Status', fg='green')
                            if not ha_status_lines:
                                click.echo('High Availability is not installed\n')
                            else:
                                click.echo('%s' % ''.join(ha_status_lines))

                            click.secho('******************************', fg='green')
                            click.pause('Please press any key to continue...')

                        elif char == '2':
                            menu = 'ha_manage_nodes'

                        elif char == '3':
                            menu = 'ha_manage_resources'

                        elif char == '4':
                            menu = 'ha_manage_sync'

                        elif char == '5':
                            ctx.invoke(ha_disable_cluster, installed_app=installed_app,
                                       replication_type=replication_type)
                            menu = 'main'

                        elif char == '6':
                            menu = 'ha_manage_sync'

                        # elif char == '7':
                        # menu = 'ha_replication_maintenance_mode'

                        else:
                            click.echo('Invalid input')

                    except KeyboardInterrupt:
                        menu = 'main'
                        continue

                else:
                    click.secho('High Availability/Load Balancer Configurations', fg='green')
                    click.secho('1: Enable High Availability', fg='green')

                    click.secho('Pre-requisites for High Availability:', fg='yellow')
                    click.secho('- All nodes have been assigned with a correct IP address', fg='yellow')
                    click.secho('- All nodes have a FQDN (name.domain.com)', fg='yellow')
                    click.secho('- An available IP address to be used as the virtual IP for the cluster', fg='yellow')
                    click.secho('- All nodes should be accessible via DNS\n', fg='yellow')

                    click.secho('b: Back to Main Menu', fg='red')
                    click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                                'and return to the previous menu.', fg='yellow')

                    char = show_select_option(char)
                    try:
                        if char == "1":
                            # char, menu, replication_type = run_create_HA(char, ctx, installed_app, menu,
                            #                                             replication_type)

                            r = ctx.invoke(createHA, ctx, installed_app=installed_app)

                            if r == 'ok':
                                menu = 'high_availability'

                        if char == "b":
                            menu = 'main'

                    except click.Abort:
                        menu = 'main'
                        continue

                    except KeyboardInterrupt:
                        menu = 'main'
                        continue

            elif menu == 'show_changes':
                click.echo('\nChanges to be Saved \n')
                click.echo('IPv4 IP Address:    ' + ip)
                click.echo('IPv4 Netmask:       ' + netmask)
                click.echo('IPv4 Primary DNS:   ' + dns1)
                click.echo('IPv4 Secondary DNS: ' + dns2)
                click.echo('IPv4 Gateway:       ' + gateway)
                click.secho('b: Back to Network Interface Config Menu', fg='red')
                char = show_select_option(char)
                if char == 'b':
                    menu = 'network'

            elif menu == 'save_changes':
                try:
                    if click.confirm('The changes to the configuration will now be saved.\n'
                                     'Are you sure you want to continue? Confirming will overwrite '
                                     'your current network configurations.'):
                        click.echo('Saving Configs...')
                        if dhcp is None:
                            dhcp = ''

                        if dhcp == '' and ip == '' and dns1 == '' and dns2 == '' and netmask == '' and gateway == '':
                            click.pause('There was no change, save is not executed. Press any key to continue...')

                        else:
                            write_new_configs(ip, dns1, dns2, netmask, gateway, dhcp, interface)
                            time.sleep(3)
                            restart_network(ctx, interface)
                            # click.echo('Restarting Interface...')
                            # ctx.invoke(network_restart, interface)
                            ip = ''
                            dns1 = ''
                            dns2 = ''
                            netmask = ''
                            gateway = ''
                            dhcp = ''
                            click.pause('Configurations Saved and Applied!. Press any key to continue...')
                            # click.pause('Interface needs to be restarted to take changes (option R). Press any key to continue...')
                    else:
                        click.pause('Configurations Not Saved. Press any key to continue...')

                    menu = 'network'
                except click.Abort:
                    menu = 'network'

            elif menu == 'update_pme':
                click.clear()

                if is_mastermaster_mastersalve_replication_enabled():
                    click.secho('Database Replication is enabled, please to ensure a correct\n'
                                'Akkadian Product installation, follow the steps in Master node:\n'
                                '1) go to main menu -> Replication Support - Maintenance Mode\n'
                                '2) select option Disable Database Replication\n'
                                '3) go back here and ensure this explanation is gone\n', fg='yellow')

                    click.pause('Please press any key to go to Maintenance Mode.')

                    menu = 'ha_manage_sync'

                else:
                    click.secho('Update PME', fg='green')
                    click.secho('1: Update PME Using URL', fg='green')
                    click.secho('2: Update PME Using Local Media', fg='green')
                    click.secho('3: Push PME Using Local Installation', fg='green')
                    click.secho('b: Back to Main Menu', fg='red')
                    click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                                'and return to the previous menu.', fg='yellow')

                    try:
                        pme_option = show_select_option(char)

                        if pme_option == 'b':
                            menu = 'main'

                        elif pme_option == '1':
                            menu = 'pme_from_url'

                        elif pme_option == '2':
                            menu = 'pme_from_file'
                        elif pme_option == '3':
                            menu = 'push_installation'

                    except KeyboardInterrupt:
                        menu = 'update_applications'
                        continue

            elif menu == 'pme_from_url':
                click.clear()
                click.secho('Installing PME...', fg='green')

                currentversion = mapper.get('GeneralConfigs', 'pmeBackupFileName')

                try:
                    zipinstaller = click.prompt('Please enter the URL for the PME Update file', type=str)
                    if os.path.exists(zipinstaller) or exists(zipinstaller):
                        ctx.invoke(pme_update, currentversion=currentversion, zipinstaller=zipinstaller)
                        click.secho('Click b to return to the previous menu.')
                    else:
                        click.pause('Invalid URL. Please try again.')

                except click.Abort:
                    menu = 'update_pme'

            elif menu == 'pme_from_file':
                currentversion = mapper.get('GeneralConfigs', 'pmeBackupFileName')

                try:
                    zipinstaller = see_files_in_folder(mapper.get('GeneralConfigs', 'pmeUploadFolder'))
                    if zipinstaller != '':
                        print('Installer found in:' + zipinstaller)
                        ctx.invoke(pme_update, currentversion=currentversion, zipinstaller=zipinstaller)
                    else:
                        click.echo('Exit...')
                        menu = 'update_pme'

                except click.Abort:
                    menu = 'update_pme'

            elif menu == 'push_installation':

                if installed_app != 'aco':
                    click.clear()
                    click.secho('Pushing current installation into target nodes...', fg='green')

                    click.secho('\nPlease follow the steps to push current installation into other instances',
                                fg='green')
                    value = click.prompt('Please enter the Target Hostname (maximum 15 characters).\nNode 1',
                                         type=str).replace("\n", "")
                    while not reach_ip(value):
                        click.pause('Node is not reachable, please enter any key to continue...')
                        value = click.prompt('Please enter the Target Hostname (maximum 15 characters).\nNode 1',
                                             type=str).replace("\n", "")
                    ha_nodes = []
                    ha_nodes += [value]

                    confirm = True
                    nodes_numbers = 2
                    max_nodes_number = 9

                    if installed_app == "aco":
                        max_nodes_number = 4
                    else:
                        max_nodes_number = 9

                    while (nodes_numbers < max_nodes_number and confirm):
                        confirm = click.confirm('Do you want to push the product into another Node?')
                        if confirm:
                            value = click.prompt(
                                'Node %s Please enter the Hostname (maximum 15 characters)' % str(nodes_numbers + 1),
                                type=str).replace("\n", "")
                            while not reach_ip(value):
                                click.pause('Node is not reachable, please enter any key to continue...')
                                value = click.prompt(
                                    'Node %s Please enter the Hostname (maximum 15 characters).' % str(
                                        nodes_numbers + 1), type=str).replace("\n", "")

                            ha_nodes += [value]
                        nodes_numbers += 1

                    ctx.invoke(push_installation, ha_nodes)
                    click.pause('Every was pushed to specific nodes. Please press any key to continue...')
                    menu = 'main'
                else:
                    click.pause(
                        'Akkadian Console Operator cannot be pushed automatically. Press any key to continue...')
                    menu = 'main'

            elif menu == 'update_aco':
                click.clear()
                click.secho('Update ACO', fg='green')
                click.secho('1: Update ACO using URL/Local Media', fg='green')
                click.secho('b: Back to Main Menu', fg='red')
                click.secho(
                    'You can press \'CTRL+C\' at any time to exit from an action\nand return to the previous menu.',
                    fg='yellow')

                try:
                    aco_option = show_select_option(char)

                    if aco_option == 'b':
                        menu = 'main'

                    elif aco_option == '1':
                        menu = 'aco_from_url'

                    else:
                        click.echo('Invalid input')

                except KeyboardInterrupt:
                    menu = 'update_applications'
                    continue

            elif menu == 'aco_from_url':
                click.clear()
                click.secho('*********************************************', fg='green')
                click.secho('*********   CUCM Version settings ***********', fg='green')

                click.echo('Please enter Cisco Call Manager url you will use')
                click.secho(
                    'if you are using two or more CUCM configurations that have different versions, you should enter the url of the minor one.',
                    fg='red')
                cucm_url = click.prompt('Please enter CUCM url (ip address or domain name)', type=str)

                while not reach_ip(cucm_url):
                    cucm_url = click.prompt('Please enter CUCM url (ip address or domain name)', type=str)

                cucm_url = 'https://' + cucm_url + '/plugins/jtapi.jar'

                click.secho('Installing ACO...', fg='green')
                click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                            'and return to the previous menu.', fg='yellow')

                try:
                    zip_installer = click.prompt('\nPlease enter the URL/Path for the ACO update files (tar.gz file)',
                                                 type=str)

                    if os.path.exists(zip_installer) or exists(zip_installer):
                        click.secho(
                            "After the installation, the server will reboot, you will lose all information not saved",
                            fg='yellow')
                        if click.confirm('Are you sure you want to continue?'):
                            ctx.invoke(aco_update, zip_installer=zip_installer, jtapi_version=cucm_url)
                        menu = 'update_aco'
                    else:
                        click.pause('Invalid URL/Path. Please try again.')

                except click.Abort:
                    menu = 'update_aco'

                except KeyboardInterrupt:
                    menu = 'update_aco'
                    continue

            elif menu == 'update_cm':
                click.clear()

                if is_mastermaster_mastersalve_replication_enabled():
                    click.secho('Database Replication is enabled, please to ensure a correct\n'
                                'Akkadian Product installation, follow the steps in Master node:\n'
                                '1) go to main menu -> Replication Support - Maintenance Mode\n'
                                '2) select option Disable Database Replication\n'
                                '3) go back here and ensure this explanation is gone\n', fg='yellow')

                    click.pause('Please press any key to go to Maintenance Mode.')

                    menu = 'ha_manage_sync'

                else:

                    click.clear()
                    click.secho('Update ACM', fg='green')
                    click.secho('1: Update ACM using URL/Local Media', fg='green')
                    click.secho('2: Push ACM using Local Installation', fg='green')
                    click.secho('b: Back to Main Menu', fg='red')
                    click.secho(
                        'You can press \'CTRL+C\' at any time to exit from an action\nand return to the previous menu.',
                        fg='yellow')

                    try:
                        acm_option = show_select_option(char)

                        if acm_option == 'b':
                            menu = 'main'

                        elif acm_option == '1':
                            click.clear()
                            click.secho('Installing ACM...', fg='green')

                            try:
                                zipinstaller = click.prompt('Please enter the URI for the ACM Update file', type=str)
                                if os.path.exists(zipinstaller) or exists(zipinstaller):
                                    ctx.invoke(cm_update, zipinstaller=zipinstaller)
                                    click.secho('Click b to return to the previous menu.')
                                else:
                                    click.pause('Invalid URL. Please try again.')

                            except click.Abort:
                                menu = 'update_cm'
                        elif char == '2':
                            menu = 'push_installation'

                        else:
                            click.echo('Invalid input')

                    except KeyboardInterrupt:
                        menu = 'update_applications'
                        continue

            elif menu == 'pme_services' or menu == 'cm_services':
                click.clear()
                app = installed_app_vs2()

                if menu == 'pme_services':
                    click.secho('APM Product Settings', fg='green')
                elif menu == 'cm_services':
                    click.secho('ACM Product Settings', fg='green')

                click.secho('0: Current Web Server Status', fg='green')
                click.secho('1: Apache Service', fg='green')
                click.secho('2: MySQL Service', fg='green')
                if app == 'acm':
                    click.secho('3: OpenLDAP Settings', fg='green')
                    click.secho('4: Supervisor Service', fg='green')
                    click.secho('5: Generate Certificate', fg='green')
                else:
                    click.secho('3: Supervisor Service', fg='green')
                    click.secho('4: Generate Certificate', fg='green')

                click.secho('b: Back to Main Menu', fg='red')
                click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                            'and return to the previous menu.', fg='yellow')

                try:
                    char = show_select_option(char)

                    if char == 'b':
                        menu = 'main'

                    elif char == '0':
                        p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'apacheStatus')], stdout=PIPE,
                                             stderr=PIPE)
                        for line in p.stdout:
                            apache_status = line

                        mysql_status_lines = []
                        p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'pmeMysqlStatus')], stdout=PIPE,
                                             stderr=PIPE)
                        for line in p.stdout:
                            mysql_status_lines.append(line)

                        click.clear()
                        click.secho('******************************', fg='green')
                        click.secho('Current PME Services Status', fg='green')

                        click.secho('* Apache Current Status:', fg='yellow')
                        if apache_status == '\n':
                            click.echo('Apache Service is not installed\n')
                        else:
                            click.echo('%s' % apache_status)

                        click.secho('* MySQL Current Status:', fg='yellow')
                        if not mysql_status_lines:
                            click.echo('MySQL Service is not installed\n')
                        else:
                            click.echo('%s' % ''.join(mysql_status_lines))

                        click.secho('******************************', fg='green')
                        click.pause('Please press any key to continue...')

                    elif char == '1':
                        menu = 'apache'

                    elif char == '2':
                        menu = 'pme_mysql'
                    elif char == '3':
                        if installed_app == 'acm':
                            menu = 'openldap'
                        else:
                            menu = 'supervisor'
                    elif char == '4':
                        if installed_app == 'acm':
                            menu = 'supervisor'
                        else:
                            generate_nonaco_certificate()
                    elif char == '5':
                        generate_nonaco_certificate()

                except KeyboardInterrupt:
                    menu = 'general'
                    continue

            elif menu == 'aco_services':
                click.clear()
                click.secho('ACO Services Settings', fg='green')
                click.secho('0: Current ACO Services Status', fg='green')
                click.secho('1: ACO Server (Kestrel) management', fg='green')
                click.secho('2: Mongo (Server DB) management', fg='green')
                click.secho('3: MySQL (Web Console DB) management', fg='green')
                click.secho('4: Smart Proxy (Nginx) management', fg='green')
                click.secho('5: ACO Web (Tomcat) management', fg='green')
                click.secho('6: Load jtapi library', fg='green')
                click.secho('7: Schedule Sync Job', fg='green')
                click.secho('8: Generate General Certificates', fg='green')
                click.secho('b: Back to Main Menu', fg='red')
                click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                            'and return to the previous menu.', fg='yellow')

                try:
                    char = show_select_option(char)

                    if char == 'b':
                        menu = 'main'

                    elif char == '0':
                        p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'kestrelStatus')], stdout=PIPE,
                                             stderr=PIPE)

                        kestrel_status_lines = []
                        for line in p.stdout:
                            kestrel_status_lines.append(line)

                        p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'mongoStatus')], stdout=PIPE,
                                             stderr=PIPE)

                        mongo_status_lines = []
                        for line in p.stdout:
                            mongo_status_lines.append(line)

                        p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'acoMysqlStatus')], stdout=PIPE,
                                             stderr=PIPE)

                        mysql_status_lines = []
                        for line in p.stdout:
                            mysql_status_lines.append(line)

                        p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'nginxStatus')], stdout=PIPE,
                                             stderr=PIPE)

                        nginx_status_lines = []
                        for line in p.stdout:
                            nginx_status_lines.append(line)

                        p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'tomcatStatus')], stdout=PIPE,
                                             stderr=PIPE)

                        tomcat_status_lines = []
                        for line in p.stdout:
                            tomcat_status_lines.append(line)

                        click.clear()
                        click.secho('******************************', fg='green')
                        click.secho('Current ACO Services Status', fg='green')

                        click.secho('* Kestrel Current Status:', fg='yellow')
                        if not kestrel_status_lines:
                            click.echo('Kestrel Service is not installed\n')
                        else:
                            click.echo('%s' % ''.join(kestrel_status_lines))

                        click.secho('* Mongo Current Status:', fg='yellow')
                        if not mongo_status_lines:
                            click.echo('Mongo Service is not installed\n')
                        else:
                            click.echo('%s' % ''.join(mongo_status_lines))

                        click.secho('* MySQL Current Status:', fg='yellow')
                        if not mysql_status_lines:
                            click.echo('MySQL Service is not installed\n')
                        else:
                            click.echo('%s' % ''.join(mysql_status_lines))

                        click.secho('* Nginx Current Status:', fg='yellow')
                        if not nginx_status_lines:
                            click.echo('Nginx Service is not installed\n')
                        else:
                            click.echo('%s' % ''.join(nginx_status_lines))

                        click.secho('* Tomcat Current Status:', fg='yellow')
                        if not tomcat_status_lines:
                            click.echo('Tomcat Service is not installed\n')
                        else:
                            click.echo('%s' % ''.join(tomcat_status_lines))

                        click.secho('******************************', fg='green')
                        click.pause('Please press any key to continue...')

                    elif char == '1':
                        menu = 'kestrel'

                    elif char == '2':
                        menu = 'mongo'

                    elif char == '3':
                        menu = 'aco_mysql'

                    elif char == '4':
                        menu = 'nginx'

                    elif char == '5':
                        menu = 'tomcat'

                    elif char == '6':
                        click.echo('Please enter Cisco Call Manager url you will use')
                        click.secho(
                            'if you are using two or more CUCM configurations with different versions, you should enter the url of the minor one.',
                            fg='red')
                        cucm_url = click.prompt('Please enter CUCM url (ip address or domain name)', type=str)

                        while not reach_ip(cucm_url):
                            cucm_url = click.prompt('Please enter CUCM url (ip address or domain name)', type=str)

                        cucm_url = 'https://' + cucm_url + '/plugins/jtapi.jar'
                        get_jtapi(cucm_url)
                    elif char == '7':
                        menu = 'crontomcat'

                    elif char == '8':
                        generate_aco_certificate()

                except KeyboardInterrupt:
                    menu = 'general'
                    continue

            elif menu == 'apache':
                click.clear()
                click.secho('Apache Service Settings', fg='green')
                click.secho('1: Stop Apache Service', fg='green')
                click.secho('2: Restart Apache Service', fg='green')
                click.secho('3: Start Apache Service', fg='green')
                click.secho('4: Edit PHP Configuration (php.ini)', fg='green')
                click.secho('5: Edit Apache Configuration (httpd.conf)', fg='green')
                click.secho('c: Edit cron File for Apache', fg='green')
                click.secho('b: Back to Main Menu', fg='red')
                click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                            'and return to the previous menu.', fg='yellow')
                click.secho('\nNOTE: The editor used by the application is the OS default\n'
                            'loaded text editor \'vim\'.\n', fg='yellow')

                try:
                    char = show_select_option(char)

                    if char == 'b':
                        menu = 'main'

                    elif char == '1':
                        ctx.invoke(apache_stop)

                    elif char == '2':
                        ctx.invoke(apache_restart)

                    elif char == '3':
                        ctx.invoke(apache_start)

                    elif char == '4':
                        ctx.invoke(edit_php_ini)

                    elif char == '5':
                        ctx.invoke(edit_apache_configs)

                    elif char == 'c':
                        subprocess.call(['crontab', '-u', 'apache', '-e'])

                    else:
                        click.echo('Invalid input')

                except KeyboardInterrupt:
                    menu = 'pme_services'
                    continue

            elif menu == 'openldap':
                click.clear()
                click.secho('OpenLDAP Settings', fg='green')
                click.secho('1: Current OpenLDAP Settings', fg='green')
                click.secho('2: Change Base DN', fg='green')
                click.secho('3: Change Query Response Limit', fg='green')
                click.secho('b: Back to Main Menu', fg='red')
                click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                            'and return to the previous menu.', fg='yellow')
                try:
                    char = show_select_option(char)

                    if char == 'b':
                        menu = 'main'

                    elif char == '1':
                        see_ldap_settings()

                    elif char == '2':
                        click.clear()
                        click.secho('Change Base DN', fg='green')
                        value = click.prompt('Enter new Base DN ex. dc=company,dc=com')

                        while not value:
                            value = click.prompt('Enter new Base DN ex. dc=company,dc=com')

                        if is_valid_ldap_basename(value) or click.confirm('Base DN is not valid do you want to save the change?'):
                            value = value.replace(" ", "")
                            change_ldap_basedn(value)
                        else:
                            menu = 'openldap'
                    elif char == '3':

                        limit=click.prompt('Enter olcSizeLimit ex. 1000')
                        set_olcSizeLimit(limit)

                except KeyboardInterrupt:
                    menu = 'pme_services'
                    continue

            elif menu == 'supervisor':
                click.clear()
                click.secho('Supervisor Service Settings', fg='green')
                click.secho('1: Stop Supervisor Service', fg='green')
                click.secho('2: Restart Supervisor Service', fg='green')
                click.secho('3: Start Supervisor Service', fg='green')
                click.secho('4: Status Supervisor Service', fg='green')
                click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                            'and return to the previous menu.', fg='yellow')

                try:
                    char = show_select_option(char)

                    if char == 'b':
                        menu = 'main'

                    elif char == '1':
                        ctx.invoke(supervisor_stop)

                    elif char == '2':
                        ctx.invoke(supervisor_restart)

                    elif char == '3':
                        ctx.invoke(supervisor_start)

                    elif char == '4':
                        ctx.invoke(supervisor_status)

                except KeyboardInterrupt:
                    menu = 'supervisor'
                    continue


            elif menu == 'pme_mysql':
                click.clear()
                click.secho('MySQL Service Settings', fg='green')
                click.secho('1: Stop MySQL Service', fg='green')
                click.secho('2: Restart MySQL Service', fg='green')
                click.secho('3: Start MySQL Service', fg='green')
                click.secho('4: Edit MySQL Configuration (my.cnf)', fg='green')
                click.secho('b: Back to Main Menu', fg='red')
                click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                            'and return to the previous menu.', fg='yellow')
                click.secho('\nNOTE: The editor used by the application is the OS default\n'
                            'loaded text editor \'vim\'.\n', fg='yellow')

                try:
                    char = show_select_option(char)

                    if char == 'b':
                        menu = 'main'

                    elif char == '1':
                        ctx.invoke(pme_mysql_stop)

                    elif char == '2':
                        ctx.invoke(pme_mysql_restart)

                    elif char == '3':
                        ctx.invoke(pme_mysql_start)

                    elif char == '4':
                        ctx.invoke(edit_my_ini)

                    else:
                        click.echo('Invalid input')

                except KeyboardInterrupt:
                    menu = 'pme_services'
                    continue

            elif menu == 'kestrel':
                click.clear()
                click.secho('ACO Server Service and Settings', fg='green')
                click.secho('1: Stop ACO Server', fg='green')
                click.secho('2: Restart ACO Server', fg='green')
                click.secho('3: Start ACO Server', fg='green')
                click.secho('4: Override ACO Server configs (Increase File Descriptor Configs)', fg='green')
                click.secho('5: See/Modify ACO Server log level', fg='green')
                click.secho('6: See logs in Real Time', fg='green')
                click.secho('7: Remove duplicated Console Events', fg='green')
                click.secho('8: See Amount of Console Events', fg='green')
                click.secho('9: See Amount of Console Events coming from web', fg='green')
                click.secho('r: Reset Admin password', fg='green')
                click.secho('b: Back to Main Menu', fg='red')
                click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                            'and return to the previous menu.', fg='yellow')

                try:
                    char = show_select_option(char)

                    if char == 'b':
                        menu = 'main'

                    elif char == 'r':
                        ctx.invoke(reset_aco_admin_pass)

                    elif char == '1':
                        ctx.invoke(kestrel_stop)

                    elif char == '2':
                        ctx.invoke(kestrel_restart)

                    elif char == '3':
                        ctx.invoke(kestrel_start)

                    elif char == '4':
                        ctx.invoke(kestrel_configs)

                    elif char == '5':
                        ctx.invoke(edit_acolog)

                    elif char == '6':
                        ctx.invoke(tail_f_acoserver)

                    elif char == '7':
                        ctx.invoke(remove_events_duplicated)

                    elif char == '8':
                        ctx.invoke(see_console_events)

                    elif char == '9':
                        ctx.invoke(see_console_events_web)

                    else:
                        click.echo('Invalid input')

                except KeyboardInterrupt:
                    menu = 'aco_services'
                    continue

            elif menu == 'mongo':
                click.clear()
                click.secho('Mongo Service Settings', fg='green')
                click.secho('1: Stop Mongo Service', fg='green')
                click.secho('2: Restart Mongo Service', fg='green')
                click.secho('3: Start Mongo Service', fg='green')
                click.secho('b: Back to Main Menu', fg='red')
                click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                            'and return to the previous menu.', fg='yellow')

                try:
                    char = show_select_option(char)

                    if char == 'b':
                        menu = 'main'

                    elif char == '1':
                        ctx.invoke(mongo_stop)

                    elif char == '2':
                        ctx.invoke(mongo_restart)

                    elif char == '3':
                        ctx.invoke(mongo_start)

                    else:
                        click.echo('Invalid input')

                except KeyboardInterrupt:
                    menu = 'aco_services'
                    continue

            elif menu == 'aco_mysql':
                click.clear()
                click.secho('MySQL Service Settings', fg='green')
                click.secho('1: Stop MySQL Service', fg='green')
                click.secho('2: Restart MySQL Service', fg='green')
                click.secho('3: Start MySQL Service', fg='green')
                click.secho('b: Back to Main Menu', fg='red')
                click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                            'and return to the previous menu.', fg='yellow')

                try:
                    char = show_select_option(char)

                    if char == 'b':
                        menu = 'main'

                    elif char == '1':
                        ctx.invoke(aco_mysql_stop)

                    elif char == '2':
                        ctx.invoke(aco_mysql_restart)

                    elif char == '3':
                        ctx.invoke(aco_mysql_start)

                    else:
                        click.echo('Invalid input')

                except KeyboardInterrupt:
                    menu = 'aco_services'
                    continue

            elif menu == 'nginx':
                click.clear()
                click.secho('Nginx Service Settings', fg='green')
                click.secho('1: Stop Nginx Service', fg='green')
                click.secho('2: Restart Nginx Service', fg='green')
                click.secho('3: Start Nginx Service', fg='green')
                click.secho('4: Override Nginx configs', fg='green')
                click.secho('b: Back to Main Menu', fg='red')
                click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                            'and return to the previous menu.', fg='yellow')

                try:
                    char = show_select_option(char)

                    if char == 'b':
                        menu = 'main'

                    elif char == '1':
                        ctx.invoke(nginx_stop)

                    elif char == '2':
                        ctx.invoke(nginx_restart)

                    elif char == '3':
                        ctx.invoke(nginx_start)

                    elif char == '4':
                        ctx.invoke(nginx_config)

                    else:
                        click.echo('Invalid input')

                except KeyboardInterrupt:
                    menu = 'aco_services'
                    continue

            elif menu == 'tomcat':
                click.clear()
                click.secho('Web Console Service Settings', fg='green')
                click.secho('1: Stop Web Console Service', fg='green')
                click.secho('2: Restart Web Console Service', fg='green')
                click.secho('3: Start Web Console Service', fg='green')
                click.secho('4: See/Modify Web Console log level', fg='green')
                click.secho('5: See Web Console log in real time', fg='green')
                click.secho('6: Turn off Web auto start service (in case you use only thick client)', fg='green')
                click.secho('7: Turn on Web auto start service', fg='green')
                click.secho('b: Back to Main Menu', fg='red')
                click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                            'and return to the previous menu.', fg='yellow')

                try:
                    char = show_select_option(char)

                    if char == 'b':
                        menu = 'main'

                    elif char == '1':
                        ctx.invoke(tomcat_stop)

                    elif char == '2':
                        ctx.invoke(tomcat_restart)

                    elif char == '3':
                        ctx.invoke(tomcat_start)

                    elif char == '4':
                        ctx.invoke(edit_logback)

                    elif char == '5':
                        ctx.invoke(tail_f_acoweb)

                    elif char == '6':
                        ctx.invoke(remove_web_service)

                    elif char == '7':
                        ctx.invoke(add_web_service)

                    else:
                        click.echo('Invalid input')

                except KeyboardInterrupt:
                    menu = 'aco_services'
                    continue

            elif menu == 'ha_manage_nodes':
                click.clear()
                click.secho('High Availability Manage Nodes', fg='green')
                click.secho('1: Add Additional Node to Cluster', fg='green')
                click.secho('2: Remove Node from Cluster', fg='green')
                click.secho('b: Back to Main Menu', fg='red')
                click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                            'and return to the previous menu.', fg='yellow')

                try:
                    char = show_select_option(char)

                    if char == 'b':
                        menu = 'main'

                    elif char == '1':
                        menu = 'ha_add_node'

                    elif char == '2':
                        menu = 'ha_remove_node'

                    else:
                        click.echo('Invalid input')

                except KeyboardInterrupt:
                    menu = 'high_availability'
                    continue

            elif menu == 'ha_manage_resources':
                click.clear()
                click.secho('High Availability Manage Resources', fg='green')
                click.secho('1: Add New Resource', fg='green')
                click.secho('2: Delete Resource', fg='green')
                click.secho('3: Move Resource to Node', fg='green')
                click.secho('b: Back to Main Menu', fg='red')
                click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                            'and return to the previous menu.', fg='yellow')

                try:
                    char = show_select_option(char)

                    if char == 'b':
                        menu = 'main'

                    elif char == '1':
                        menu = 'ha_add_resource'

                    elif char == '2':
                        menu = 'ha_delete_resource'

                    elif char == '3':
                        menu = 'ha_move_resource'

                    else:
                        click.echo('Invalid input')

                except click.Abort:
                    menu = 'high_availability'

                except KeyboardInterrupt:
                    menu = 'high_availability'
                    continue

            elif menu == 'ha_manage_sync':

                click.clear()

                current_replication_status = ""
                is_replication_running = False
                need_show_mongo_replication = False
                current_replication_status = 'Database Replication in Not Running'

                click.secho('########## Replication Maintenance Mode ################', fg='yellow')
                if installed_app == 'aco':
                    is_enable = is_replica_enabled()
                    if is_enable:
                        current_replication_status = 'Database Replication Running'
                    else:
                        current_replication_status = 'Database Replication in Not Running'

                    is_replication_running = is_enable

                    click.secho('#########################################################', fg='blue')
                    click.secho('Database Replication Status: ', fg='blue')
                    click.secho(current_replication_status, fg='green')
                    click.secho('#########################################################', fg='blue')

                    if not is_replication_running:
                        click.secho('1: Enable Database Replication', fg='green')
                    else:
                        click.secho('1: Disable Database Replication', fg='green')

                    click.secho('b: Back to Main Menu', fg='red')
                    click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                                'and return to the previous menu.', fg='yellow')

                    try:
                        char = show_select_option(char)

                        if char == 'b':
                            menu = 'main'
                        elif char == '1' and is_replication_running:
                            if click.prompt('Are you sure you want to Disable Database Replication?'):
                                ctx.invoke(remove_mongo_replication)

                        elif char == '1' and not is_replication_running:
                            ctx.invoke(add_mongo_replication)
                            ctx.invoke(mongo_replication_postconditions)

                        # elif char == '2':
                        #    ctx.invoke(status_mongo_replication)
                        else:
                            menu = 'ha_manage_sync'

                    except click.Abort:
                        menu = 'high_availability'

                    except KeyboardInterrupt:
                        menu = 'high_availability'
                        continue
                else:
                    is_replication_running = need_show_replication_info or need_show_redundancy_info

                    click.secho('#########################################################', fg='blue')

                    if need_show_redundancy_info:

                        click.secho(' Master-Master Database Replication is Enabled', fg='blue')
                        click.secho(' Nodes: %s ' % get_redundancy_nodelist(), fg='blue')
                        click.secho(' Online: %s ' % get_redundancy_online(), fg='green')

                        offline_nodes = get_redundancy_offline()

                        if offline_nodes and ' '.join(offline_nodes.split()) != '':
                            click.secho(' Offline: %s ' % offline_nodes, fg='red')
                    elif need_show_replication_info:
                        if not is_ha_on:
                            click.secho('#########################################################', fg='blue')

                        click.secho(' Master-Slave Database Replication is Enabled', fg='blue')
                    else:

                        click.secho(' Database Replication is disabled', fg='blue')
                    click.secho('#########################################################', fg='blue')

                    # It is possible to select a new way of replication
                    if not need_show_redundancy_info and not need_show_replication_info:
                        click.secho('1: Enable Database Replication', fg='green')
                    else:
                        click.secho('1: Disable Database Replication', fg='green')

                        click.secho('2: Advanced Database Replication Status', fg='green')

                    click.secho('b: Back to Main Menu', fg='red')
                    click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                                'and return to the previous menu.', fg='yellow')

                    try:
                        char = show_select_option(char)

                        if char == 'b':
                            menu = 'main'

                        elif char == '1':
                            if is_replication_running:
                                if click.confirm('Are you sure you want to disable Database Replication?'):
                                    click.secho("Removing replication configs...")
                                    remove_replication_general_configs()
                                    time.sleep(2)
                                    remove_replication_db_configs()
                                    time.sleep(5)
                                    menu = 'main'
                            else:

                                # ADD REPLICATION AGAIN!!!!!!
                                # it can be master-master or master-slaves
                                onlines = get_onlines()
                                there_are_onlines = onlines and ' '.join(onlines.split()) != ''
                                onlines_split = []

                                if there_are_onlines:
                                    onlines_split = onlines.split()

                                    click.secho("Node list: [" + onlines_split[0] + ", " + onlines_split[1] + "].",
                                                fg='green')

                                    if len(onlines_split) == 2:
                                        if click.confirm("Do you want to enable a Master-Master Database Replication?"):
                                            # here the menu of master-master replication
                                            replication_type = "master-master"
                                        else:
                                            # here the menu of master-slaves
                                            menu = 'main'
                                            # replication_type = "master-slaves"
                                    else:
                                        # here the menu of master-slaves
                                        replication_type = "master-slaves"
                                else:
                                    # only option is to setup again master-master.
                                    replication_type = "master-master"

                                # deciding if we need to go or not base on the question.
                                if menu != 'main':
                                    if replication_type == "master-slaves":
                                        if click.confirm(
                                                'Are you sure you want to enable Database Replication?'):
                                            print('-- Resetting Synchronization Settings')
                                            remove_replication_general_configs()
                                            remove_replication_db_configs()
                                            print('-- Preparing Database Server for Replication')
                                            add_replication_preconditions()
                                            print('-- Activating Database Replication')
                                            determine_master_and_run_replication()
                                            print('-- Ending Database Server Configurations')
                                            add_replication_posconditions()
                                    else:
                                        ha_nodes = []

                                        if not there_are_onlines:
                                            ip = get_simple_hostname().replace("\n", "")
                                            # ask again
                                            click.secho('Pre-requisites for master-master Database replication:',
                                                        fg='yellow')
                                            click.secho('- All nodes have been assigned with a correct IP address',
                                                        fg='yellow')
                                            click.secho('- All nodes have a FQDN (name.domain.com)', fg='yellow')
                                            click.secho('- All nodes should be accessible via DNS\n', fg='yellow')
                                            click.pause('Please press any key to continue...')

                                            click.secho('Node 1: %s' % get_simple_hostname(), fg='green')
                                            value = click.prompt(
                                                'Please enter the second Hostname.\nNode 2',
                                                type=str).replace("\n", "")
                                            while not reach_ip(value):
                                                click.pause(
                                                    'Node is not reachable, please enter any key to continue...')
                                                value = click.prompt(
                                                    'Please enter the second Hostname.\nNode 2',
                                                    type=str).replace("\n", "")

                                            ha_nodes = [ip] + [value]

                                            replication_type = "master-master"
                                            ctx.invoke(enable_redundancy, ha_nodes)
                                            menu = 'main'
                                        else:
                                            if len(onlines_split) < 2:
                                                click.pause(
                                                    'One of the nodes is down, please ensure the node is back up to start again. Press any key to continue...')
                                            else:
                                                ctx.invoke(enable_redundancy, onlines_split)
                                                menu = 'main'

                        elif char == '2':
                            if installed_app == 'aco':
                                print("Verify Mongo Replica Status")
                                ctx.invoke(status_mongo_replication)
                            else:
                                click.pause(
                                    "Replication Type is: " + replication_type + ". Press any key to continue...")
                                if replication_type == 'master-slaves':
                                    ctx.invoke(replication_masterslaves_status)
                                if replication_type == 'master-master':
                                    ctx.invoke(show_redundancy_status)
                        else:
                            click.echo('Invalid input')

                    except click.Abort:
                        menu = 'high_availability'

                    except KeyboardInterrupt:
                        menu = 'high_availability'
                        continue

            elif menu == 'ha_add_node':
                click.clear()
                click.secho('Adding HA Node...', fg='green')
                click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                            'and return to the previous menu.', fg='yellow')

                try:
                    ip_value = click.prompt('\nPlease enter the IP address of new node', type=str)

                    if is_valid_ip(ip_value):
                        print("This will delay, please wait while everything necessary is configure...")
                        ctx.invoke(add_node, ip=ip_value)
                        menu = 'high_availability'
                    else:
                        click.pause('Invalid IP Address. Please try again.')

                except click.Abort:
                    menu = 'ha_manage_nodes'

                except KeyboardInterrupt:
                    menu = 'ha_manage_nodes'
                    continue

            elif menu == 'ha_remove_node':
                click.clear()
                click.secho('Removing HA Node...', fg='green')
                click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                            'and return to the previous menu.', fg='yellow')

                try:
                    master = get_ip()
                    ip_value = click.prompt('\nPlease enter the IP address of the node that you want remove', type=str)

                    if is_valid_ip(ip_value):
                        if master == ip_value:
                            click.pause('Invalid IP Address. You are trying to delete master ip.')
                        else:
                            ctx.invoke(remove_node, master=master, ip=ip_value)
                            menu = 'high_availability'
                    else:
                        click.pause('Invalid IP Address. Please try again.')

                except click.Abort:
                    menu = 'ha_manage_nodes'

                except KeyboardInterrupt:
                    menu = 'ha_manage_nodes'
                    continue

            elif menu == 'ha_add_resource':
                click.clear()
                click.secho('Adding HA Resource...', fg='green')
                click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                            'and return to the previous menu.', fg='yellow')

                try:
                    ctx.invoke(add_resource)
                    menu = 'high_availability'

                except click.Abort:
                    menu = 'ha_manage_resources'

                except KeyboardInterrupt:
                    menu = 'ha_manage_resources'
                    continue

            elif menu == 'ha_delete_resource':
                click.clear()
                click.secho('Deleting HA Resource...', fg='green')
                click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                            'and return to the previous menu.', fg='yellow')

                try:
                    resource = click.prompt('\nPlease enter the resource name that you want remove', type=str)

                    print("This will delay, please wait while everything necessary is configure...")
                    ctx.invoke(remove_resource, resource=resource)
                    menu = 'high_availability'

                except click.Abort:
                    menu = 'ha_manage_resources'

                except KeyboardInterrupt:
                    menu = 'ha_manage_resources'
                    continue

            elif menu == 'ha_move_resource':
                click.clear()
                click.secho('Moving HA Resource...', fg='green')
                click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                            'and return to the previous menu.', fg='yellow')

                try:
                    resource = click.prompt('\nPlease enter the resource name that you want move', type=str)
                    destination = click.prompt('Please enter the destination node IP address', type=str)

                    print("This will delay, please wait while everything necessary is configure...")
                    ctx.invoke(move_resource, resource=resource, destination=destination)
                    menu = 'high_availability'

                except click.Abort:
                    menu = 'ha_manage_resources'

                except KeyboardInterrupt:
                    menu = 'ha_manage_resources'
                    continue

            elif menu == 'reboot':
                if click.confirm('Do you want to restart?'):
                    ctx.invoke(reboot)
                else:
                    menu = 'main'
            elif menu == 'shutdown':
                if click.confirm('Do you want to shutdown?'):
                    ctx.invoke(shutdown)
                else:
                    menu = 'main'

            elif menu == 'crontomcat':

                type_cron_value_ok = ''
                day_value_ok = ''
                time_value_ok = ':'

                isTypeOK = False
                isWeekOK = False
                isDayOK = False

                exit = False

                cont = 0

                while exit == False and (
                        (isTypeOK == False) or (isWeekOK == False) or (isDayOK == False)) and cont < 50:
                    cont = cont + 1
                    click.clear()
                    click.secho('Setting Tomcat Cron...', fg='green')
                    click.secho('You can press \'CTRL+C\' at any time to exit from an action\n'
                                'and return to the previous menu.', fg='yellow')

                    try:

                        click.secho('\n', fg='green')
                        click.secho('**************************************************************', fg='green')
                        click.secho('D: daily', fg='green')
                        click.secho('W: weekly', fg='green')
                        click.secho('**************************************************************', fg='green')

                        if type_cron_value_ok != '':
                            click.secho(
                                'Please enter the frecuency to run the tomcat cron task: ' + str(type_cron_value_ok))
                            type_cron_value = type_cron_value_ok
                            isTypeOK = True
                        else:
                            type_cron_value = click.prompt(
                                'Please enter the type of tomcat cron task, daily(D) or weekly(W)', type=str)
                            isTypeOK = is_valid_type_cron(type_cron_value)

                        if isTypeOK:
                            type_cron_value_ok = type_cron_value
                            day_value = ''
                        else:
                            click.pause('Invalid Option. Press Enter to Continue ...')

                        if isTypeOK and type_cron_value_ok.upper() == 'W':

                            click.secho('\n', fg='green')
                            click.secho('**************************************************************', fg='green')
                            click.secho('0: Sunday', fg='green')
                            click.secho('1: Monday', fg='green')
                            click.secho('2: Tuesday', fg='green')
                            click.secho('3: Wednesday', fg='green')
                            click.secho('4: Thursday', fg='green')
                            click.secho('5: Friday', fg='green')
                            click.secho('6: Saturday', fg='green')
                            click.secho('**************************************************************', fg='green')

                            if day_value_ok != '':
                                click.secho('Please enter the day of week to run the task (0-6): ' + str(day_value_ok))
                                day_value = day_value_ok
                                isWeekOK = True
                            else:
                                day_value = click.prompt(
                                    'Please enter the day of week to run the task (0-6)', type=str)
                                isWeekOK = is_valid_dayofweek(day_value)

                            if isWeekOK:
                                day_value_ok = day_value
                                time_value = ':'
                            else:
                                click.pause('Invalid Option. Press Enter to Continue ...')
                        else:
                            isWeekOK = True
                            day_value_ok = '*'

                        if isTypeOK and isWeekOK and (
                                type_cron_value_ok.upper() == 'D' or type_cron_value_ok.upper() == 'W'):

                            click.secho('\n', fg='green')
                            click.secho('**************************************************************', fg='green')
                            time_value = click.prompt(
                                'Please enter the hour in 24 hours format (hh:mm)', type=str)
                            isDayOK = is_valid_time(time_value)

                            if isDayOK:
                                time_value_ok = time_value
                            else:
                                click.pause('Invalid Option. Press Enter to Continue ...')

                        if isTypeOK and isWeekOK and isDayOK:
                            time_value_array = time_value_ok.split(':')
                            ctx.invoke(crontomcat, day=day_value_ok, hour=time_value_array[0],
                                       minute=time_value_array[1])
                            click.pause('Cron Tomcat configured. Please press any key to continue...')
                            menu = 'main'


                    except click.Abort:
                        exit = True
                        menu = 'main'

                    except KeyboardInterrupt:
                        exit = True
                        menu = 'main'
                        continue




            elif menu == 'quit':
                ctx.invoke(kickoff_thisuser)

        except click.Abort:
            menu = 'main'
            continue
        except EOFError:
            menu = 'main'
            continue
        except KeyboardInterrupt:
            menu = 'main'
            continue

def change_timezone(ctx, menu):
    try:
        click.pause('\nIf date has being set before, using NTP or manually this change will not modify the system hour.'
                    '\nPress any key to continue...')

        if click.confirm('\nTime Zones are shown in a paged list. When you find the desired \n'
                         'Time Zone please enter the number tied to it. If you need to look \n'
                         'into more pages, please press n, to go to previous pages press p \n'
                         '\nAre you ready?'):
            ctx.invoke(see_regions)

    except click.Abort:
        menu = 'time'

    return menu


def ls_pme_updates_folder():
    p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'lsUpdateFolder')], stdout=PIPE,
                         stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()


def show_select_option(char):
    click.secho('\nSelect an option: ', fg='white', blink=True, nl=False)
    char = click.getchar()
    click.echo('')
    return char


def updateNTPServers(values_to_update):
    values_to_update = []
    click.secho('GET NTP SERVER URLS AT http://www.pool.ntp.org/en/', fg='yellow', bg='red')
    click.secho('Ex: Server 0: svr.pool.ntp.org', fg='yellow', bg='red')
    value = click.prompt('Server 0', type=str)
    value = value.replace("\n", "")
    values_to_update = values_to_update + [value]

    if click.confirm('Do you want to add another NTP Server?'):
        value = click.prompt('Server 1', type=str)
        value = value.replace("\n", "")
        values_to_update = values_to_update + [value]
        if click.confirm('Do you want to add another NTP Server?'):
            value = click.prompt('Server 2', type=str)
            value = value.replace("\n", "")
            values_to_update = values_to_update + [value]

            if click.confirm('Do you want to add another NTP Server?'):
                value = click.prompt('Server 3', type=str)
                value = value.replace("\n", "")
                values_to_update = values_to_update + [value]
                click.secho('Changes to be saved:', fg='green')

                for i in range(len(values_to_update)):
                    click.secho('Server %s' % str(i) + ': ' + values_to_update[i], fg='green')

                if click.confirm('Do you want to save changes?'):
                    set_servers_ntp_file(mapper.get('GeneralConfigs', 'ntp_file'), values_to_update)

    return values_to_update


def createHA(ctx, installed_app):
    # Checking if redundancy is enable
    node_list = get_redundancy_nodelist()
    is_redundancy_on = (node_list != None and ' '.join(
        node_list.split()) != '') or is_mastermaster_mastersalve_replication_enabled()
    ip = get_simple_hostname().replace("\n", "")
    click.clear()
    ha_nodes = []

    if is_redundancy_on:
        click.secho("Node List: " + node_list, fg='green')
        ha_nodes = node_list.split(" ")
        ha_nodes = ha_nodes[1:]

    else:
        click.secho('\nPlease follow the steps to configure High Availability', fg='green')
        click.secho('Node 1: %s' % get_simple_hostname(), fg='green')
        value = click.prompt('Please enter the second Hostname (maximum 15 characters).\nNode 2', type=str).replace(
            "\n", "")
        while not reach_ip(value):
            click.pause('Node is not reachable, please enter any key to continue...')
            value = click.prompt('Please enter the second Hostname (maximum 15 characters).\nNode 2',
                                 type=str).replace("\n", "")

        ha_nodes += [value]

        confirm = True
        nodes_numbers = 2
        max_nodes_number = 2

        if installed_app == "aco":
            max_nodes_number = 4
        else:
            max_nodes_number = 9

        while (nodes_numbers < max_nodes_number and confirm):
            confirm = click.confirm('Do you want to add another Node?')
            if confirm:
                value = click.prompt(
                    'Node %s Please enter the Hostname (maximum 15 characters)' % str(nodes_numbers + 1),
                    type=str).replace("\n", "")
                while not reach_ip(value):
                    click.pause('Node is not reachable, please enter any key to continue...')
                    value = click.prompt(
                        'Node %s Please enter the Hostname (maximum 15 characters).' % str(
                            nodes_numbers + 1), type=str).replace("\n", "")

                ha_nodes += [value]
            nodes_numbers += 1

    if len([ip] + ha_nodes) == 2 and installed_app != 'aco':
        replication_type = "master-master"
        print('replication is master-master')
    else:
        replication_type = "master-slaves"
        print('replication is master-slaves')

    config_ha = True
    if not is_redundancy_on:
        if installed_app != 'aco':
            config_ha = not click.confirm(
                'Will you be using an External Load Balancer to route all traffic to the nodes?')

    if config_ha:
        virtual_ip = click.prompt('Virtual IP', type=str).replace("\n", "")
        virtual_ip_mask = click.prompt('Virtual IP Mask', type=str).replace("\n", "")

        password = click.prompt('Cluster Password', type=str, hide_input=True, confirmation_prompt=True)
        while '\\' in password or '/' in password or '$' in password:
            click.pause('Password cannot have \\ nor / nor $, please press any key to continue')
            password = click.prompt('Cluster Password', type=str, hide_input=True, confirmation_prompt=True)

        click.secho('\nChanges to be saved:', fg='green')
        click.secho('Master node: %s' % ip, fg='green')
        for i in range(len(ha_nodes)):
            click.secho('Secondary node %s' % str(i + 1) + ': ' + ha_nodes[i], fg='green')
        click.secho('Virtual IP: %s' % virtual_ip, fg='green')
        click.secho('Virtual IP Mask: %s' % virtual_ip_mask, fg='green')

        if click.confirm('Do you want to save changes and enable High Availability?'):
            print("Please wait while High Availability is configured and enabled...")

            nodes = ""
            for i in ha_nodes:
                nodes += str(i) + " "

            p = Popen(
                ["sh", mapper.get('GeneralScripts', 'haInstall'), ip, nodes, virtual_ip, virtual_ip_mask, password],
                stdout=PIPE, stderr=PIPE)

            out, err = p.communicate()
            time.sleep(10)

            for line in out.splitlines():
                print(line)

            for line in err.splitlines():
                print(line)

                if 'ERROR' in line:
                    click.secho(line, fg='red')
                    click.secho(
                        'There was an error setting up HA. Check HA status and ensure hostnames are unique. You can validate this, using option 7 in Network menu')
                    click.secho(
                        'After ensuring hostnames are unique, you will need to remove cluster configurations. You can do this, using option 5 in High Availability menu')
                    click.pause('Press any key to continue...')
                    return 'ok'

            print('Please wait while High Availability is enabled...')
            time.sleep(20)

    if not is_redundancy_on:
        if installed_app == 'aco':
            print('-- Adding Mongo Replica!!!')
            ctx.invoke(add_mongo_replication)
            ctx.invoke(mongo_replication_postconditions)
            print('Ending mongo replication')

        elif replication_type == "master-slaves":
            print('-- Adding Database Replication Settings')
            print('-- Resetting Synchronization Settings')
            remove_replication_general_configs()
            remove_replication_db_configs()
            print('-- Preparing Database Server for Replication')
            add_replication_preconditions()
            print('-- Activating Database Replication')
            determine_master_and_run_replication()
            print('-- Ending Database Server Configurations')
            add_replication_posconditions()

        elif replication_type == "master-master":
            ha_nodes = [ip] + ha_nodes
            ctx.invoke(enable_redundancy, ha_nodes=ha_nodes)
            menu = 'main'

        click.pause('Press any key to continue...')

    return 'ok'


def add_resource():
    click.secho('\nPlease enter the follow values to configure New Resource', fg='green')
    name = click.prompt('Resource Name', type=str).replace("\n", "")

    fields = click.prompt('Standard', type=str).replace("\n", "")
    fields += ':'
    fields += click.prompt('Provider', type=str).replace("\n", "")
    fields += ':'
    fields += click.prompt('Type', type=str).replace("\n", "")

    click.secho('Please enter all options in a single word separated by "-".')
    click.secho('VIRTUAL IP Ex: ip=192.168.0.99-cidr_netmask=24-nic=eth2-op-monitor-interval=30s', fg='yellow',
                bg='red')
    options = click.prompt('Options', type=str).replace("\n", "")

    click.secho('\nChanges to be saved:', fg='green')
    click.secho('Resource Name: %s' % name, fg='green')
    click.secho('Fields: %s' % fields, fg='green')
    click.secho('Options: %s' % options, fg='green')

    if click.confirm('Do you want to save changes?'):
        print("This will delay, please wait while everything necessary is installed...")

        p = Popen(["sh", mapper.get('GeneralScripts', 'addResource'), name, fields, options], stdout=PIPE, stderr=PIPE)

        out, err = p.communicate()
        time.sleep(10)

        for line in out.splitlines():
            print(line)

        for line in err.splitlines():
            print(line)

            if 'Error' in line:
                click.pause('ERROR: The resource was not added. Press any key to continue...')
                return

        click.pause('The new resource was added correctly. Press any key to continue...')


def remove_resource(resource):
    p = Popen(["sh", mapper.get('GeneralScripts', 'removeResource'), resource], stdout=PIPE, stderr=PIPE)

    out, err = p.communicate()
    time.sleep(10)

    for line in out.splitlines():
        print(line)

    for line in err.splitlines():
        print(line)

        if 'Error' in line:
            click.pause('ERROR: The resource was not removed. Press any key to continue...')
            return

    click.pause('The resource was removed correctly. Press any key to continue...')


def move_resource(resource, destination):
    p = Popen(["sh", mapper.get('GeneralScripts', 'moveResource'), resource, destination], stdout=PIPE, stderr=PIPE)

    out, err = p.communicate()
    time.sleep(10)

    for line in out.splitlines():
        print(line)

    for line in err.splitlines():
        print(line)

        if 'Error' in line:
            click.pause('ERROR: The resource was not moved. Press any key to continue...')
            return

    click.pause('The resource was moved correctly. Press any key to continue...')


def exists(path):
    try:
        ret = urllib2.urlopen(path)
        return ret.code == 200
    except:
        return False


def nmtui():
    p = subprocess.call(["nmtui"])


def kickoff_thisuser():
    p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'quit')], stdout=PIPE,
                         stderr=PIPE)


def kick_off():
    p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'logout')], stdout=PIPE,
                         stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    out, err = p.communicate()
    time.sleep(10)


def chown(path):
    p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'chown'), path], stdout=PIPE,
                         stderr=PIPE)

    for line in p.stdout:
        print(line)
    p.wait()

    out, err = p.communicate()
    time.sleep(10)


def auto_update(zip_installer):
    """
    UPDATE CLI
    :param zip_installer:
    :return:
    """
    p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'autoUpdate'), zip_installer],
                         stdout=PIPE, stderr=PIPE)

    out, err = p.communicate()
    time.sleep(10)

    for line in out.splitlines():
        if 'ERROR' in line:
            click.secho(line, fg='red')
            click.secho('Akkadian Appliance Manager (AAM) was not updated.', fg='red')
            click.pause('Press any key to continue...')
            return
        else:
            click.secho(line)

    print('\n\n\n')
    click.secho('\n################## Akkadian Appliance Manager Update ################', fg='green')
    click.secho('Akkadian Appliance Manager (AAM) Updated.', fg='green')
    click.secho('\nA restart of AAM is required to enable any functionality and options to be accessible.', fg='green')
    click.secho('Use Option 2 under the \'Update Akkadian Appliance Manager\' menu to restart AAM.', fg='yellow')
    click.pause('Please press any key to continue...')
    return


def is_valid_dayofweek(day):
    try:
        result = len(day) == 1 and day in "0123456"
        # click.secho('result:' + str(result))
        return result
    except Exception:
        click.secho('ERROR:' + str(Exception))
        return False


def is_valid_time(time):
    try:

        res = re.match('^(0[0-9]|1[0-9]|2[0-3]|[0-9]):[0-5][0-9]$', str(time))
        # click.secho('res:' + str(res))
        return (res != None and res != False)

    except Exception:
        click.secho('ERROR:' + str(Exception))
        return False


def is_valid_type_cron(type):
    try:
        return type == 'W' or type == 'D' or type == 'd' or type == 'w'

    except Exception:
        click.secho('ERROR:' + str(Exception))
        return False


def is_valid_ip(ip):
    # try:
    #     socket.inet_aton(ip)
    #     return True

    # except:

    #     return False
    try:
        parts = ip.split('.')
        return len(parts) == 4 and all(0 <= int(part) < 256 for part in parts)
    except ValueError:
        return False  # one of the 'parts' not convertible to integer
    except (AttributeError, TypeError):
        return False  # `ip` isn't even a string

def is_valid_ldap_basename(basename):
    try:
        res = re.match('^(dc=[0-9a-zA-Z]+\,{0,1})*$', str(basename))
        # click.secho('res:' + str(res))
        return (res != None and res != False)

    except Exception:
        click.secho('ERROR:' + str(Exception))
        return False


def has_configured_ipv6(interface):
    p = subprocess.Popen(["sh", mapper.get('NetworkScripts', 'hasAlreadyConfiguredIPV6'), interface], stdout=PIPE,
                         stderr=PIPE)

    i = 0
    for line in p.stdout:
        i += 1

    if i > 0:
        return True
    else:
        return False


def get_current_hostname():
    p = subprocess.Popen(["sh", mapper.get('NetworkScripts', 'getHostname')], stdout=PIPE,
                         stderr=PIPE)

    for line in p.stdout:
        print(line)


def change_hostname(new_host_name):
    p = subprocess.Popen(["sh", mapper.get('NetworkScripts', 'changeHostname'), new_host_name], stdout=PIPE,
                         stderr=PIPE)

    if p.returncode == 0 or p.returncode is None:
        click.secho('[OK] Hostname was changed successfully', fg="yellow")
    else:
        click.secho('[FAIL] Hostname could not be changed', fg="red")

    time.sleep(5)


def change_password():
    p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'changePassword')], stdout=PIPE,
                         stderr=PIPE)
    interfaces = []
    for line in p.stdout:
        interfaces.append(line)

    return interfaces


def get_network_interface():
    p = subprocess.Popen(["sh", mapper.get('NetworkScripts', 'getNetworkInterfaces')], stdout=PIPE,
                         stderr=PIPE)
    interfaces = []
    for line in p.stdout:
        interfaces.append(line)

    return interfaces


def is_interface_up(interface):
    addr = netifaces.ifaddresses(interface)
    return netifaces.AF_INET in addr


def is_in_network(ip1, ip2, netmask):
    ip1_tmp, ip2_tmp = ip1.split("."), ip2.split(".")
    netmask_tmp = netmask.split(".")

    for i in range(3):
        subnet_ip1 = int(ip1_tmp[i]) & int(netmask_tmp[i])
        subnet_ip2 = int(ip2_tmp[i]) & int(netmask_tmp[i])

        if subnet_ip1 != subnet_ip2:
            return False

    return True


def check_ip_exist(interface, new_ip):
    if is_interface_up(interface):
        addrs = netifaces.ifaddresses(interface)
        actual_ip = addrs[netifaces.AF_INET][0].get('addr')
        netmask = addrs[netifaces.AF_INET][0].get('netmask')

        if is_in_network(actual_ip, new_ip, netmask):
            if actual_ip != new_ip:
                p = subprocess.Popen(["sh", mapper.get('NetworkScripts', 'checkIpExist'), new_ip], stdout=PIPE,
                                     stderr=PIPE)
                for line in p.stdout:
                    if '0' in line:
                        return 1  # IP Taken
                    else:
                        return 0  # IP Free
            else:
                return 0  # IP Free
        else:
            if click.confirm('\nThe ip you are trying to use is outside the network.\n'
                             'IPv4 Address cannot be confirmed if used by another system.\n'
                             'Are you sure you want to use this IPV4 address?'):
                return 0  # IP Check Override with external ip
            else:
                click.echo(
                    'IP Configuration interrupted. Returning to Network Configuration Menu.\nPress any key to continue...')
                menu = 'network'
    else:
        if click.confirm('\nNetwork Interface is not currently enabled.\n'
                         'IPv4 Address cannot be confirmed if used by another system.\n'
                         'Are you sure you want to use this IPV4 address?'):
            return 0  # Authorize IP Check Override
        else:
            click.echo(
                'IP Configuration interrupted. Returning to Network Configuration Menu.\nPress any key to continue...')
            menu = 'network'


def get_ip():
    p = subprocess.Popen(["sh", mapper.get('NetworkScripts', 'getIp')], stdout=PIPE,
                         stderr=PIPE)
    ip = ''
    for line in p.stdout:
        ip = line

    return ip


def network_stop(interface):
    p = subprocess.Popen(["sh", mapper.get('NetworkScripts', 'networkStop'), interface], stdout=PIPE,
                         stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Network could not be Stopped', fg="red")
    else:
        click.secho('[OK] Network Stopped Successfully', fg="yellow")

    time.sleep(5)


def network_start(interface):
    p = subprocess.Popen(["sh", mapper.get('NetworkScripts', 'networkStart'), interface], stdout=PIPE,
                         stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Network could not be Started', fg="red")
    else:
        click.secho('[OK] Network Started Successfully', fg="yellow")

    time.sleep(5)


def network_restart(interface):
    p = subprocess.Popen(["sh", mapper.get('NetworkScripts', 'networkRestart'), interface], stdout=PIPE,
                         stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Network Could Not be Restarted.', fg="red")
    else:
        click.secho('[OK] Network Restarted Successfully', fg="yellow")

    time.sleep(5)


def stop_ntp():
    p = subprocess.Popen(["sh", mapper.get('DateScripts', 'NTPStop')], stdout=PIPE, stderr=PIPE)

    for line in p.stdout:
        click.echo(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Cannot reach the service, is it running?', fg="red")
    else:
        click.secho('[OK] NTP Server is down', fg="yellow")

    time.sleep(5)


def start_ntp():
    p = subprocess.Popen(["sh", mapper.get('DateScripts', 'NTPStart')], stdout=PIPE,
                         stderr=PIPE)
    for line in p.stdout:
        click.echo(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] There was a problem starting the service', fg='red')
    else:
        click.secho('[OK] NTP Server is up', fg="yellow")

    time.sleep(5)


def ntp_status():
    p = subprocess.Popen(["sh", mapper.get('DateScripts', 'NTPStatus')], stdout=PIPE,
                         stderr=PIPE)
    for line in p.stdout:
        ntp_status_ = line
    p.wait()

    if ntp_status_.rstrip('\n') is not None and ntp_status_.rstrip('\n') is not "":
        tokens = ntp_status_.split(',')

        for i in range(len(tokens)):
            if 'stratum' in tokens[i]:
                return int(tokens[i].split('=')[1])

    return 17


def reboot():
    p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'reboot')], stdout=PIPE,
                         stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()


def shutdown():
    p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'halt')], stdout=PIPE,
                         stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()


def crontomcat(day, hour, minute):
    p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'tomcatCron'), str(day), str(hour), str(minute)],
                         stdout=PIPE,
                         stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()


def snmp_start():
    p = subprocess.Popen(["sh", mapper.get('NetworkScripts', 'snmpd_start')], stdout=PIPE,
                         stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()


def snmp_stop():
    p = subprocess.Popen(["sh", mapper.get('NetworkScripts', 'snmpd_stop')], stdout=PIPE,
                         stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()


def snmp_restart():
    p = subprocess.Popen(["sh", mapper.get('NetworkScripts', 'snmpd_restart')], stdout=PIPE,
                         stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()


@cli.command()
def apache_stop():
    """
    Stop Apache Service
    """

    click.echo('Stopping...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'apacheStop')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Cannot reach apache, is it running?', fg="red")
    else:
        click.secho('[OK] Apache Server is down', fg="yellow")

    time.sleep(5)


@cli.command()
def apache_start():
    """
    Start Apache Service
    """

    click.echo('Starting...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'apacheStart')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Apache Could Not Be Started', fg="red")
    else:
        click.secho('[OK] Apache Started Successfully', fg="yellow")

    time.sleep(5)


@cli.command()
def apache_restart():
    """
    Restart Apache Service
    """

    click.echo('Restarting...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'apacheRestart')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Apache Could Not Be Restarted', fg="red")
    else:
        click.secho('[OK] Apache Restarted Successfully', fg="yellow")

    time.sleep(5)


@cli.command()
def pme_mysql_stop():
    """
    Stop PME MySQL Service
    """

    click.echo('Stopping...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'pmeMysqlStop')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] MySQL Could not be Stopped', fg="red")
    else:
        click.secho('[OK] MySQL Stopped Successfully', fg="yellow")

    time.sleep(3)


@cli.command()
def pme_mysql_start():
    """
    Start PME MySQL Service
    """

    click.echo('Starting...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'pmeMysqlStart')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] MySQL Could not be Started', fg="red")
    else:
        click.secho('[OK] MySQL Started Successfully', fg="yellow")

    time.sleep(3)


@cli.command()
def pme_mysql_restart():
    """
    Restart PME MySQL Service
    """

    click.echo('Restarting...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'pmeMysqlRestart')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] MySQL Could not be Restarted', fg="red")
    else:
        click.secho('[OK] MySQL Restarted Successfully', fg="yellow")

    time.sleep(3)


@cli.command()
def kestrel_stop():
    """
    Stop Kestrel Service
    """

    click.echo('Stopping...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'kestrelStop')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Kestrel Could not be Stopped', fg="red")
    else:
        click.secho('[OK] Kestrel Stopped Successfully', fg="yellow")

    time.sleep(3)


@cli.command()
def kestrel_start():
    """
    Start Kestrel Service
    """

    click.echo('Starting...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'kestrelStart')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Kestrel Could not be Started', fg="red")
    else:
        click.secho('[OK] Kestrel Started Successfully', fg="yellow")

    time.sleep(3)


@cli.command()
def kestrel_restart():
    """
    Restart Kestrel Service
    """

    click.echo('Restarting...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'kestrelRestart')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Kestrel Could not be Restarted', fg="red")
    else:
        click.secho('[OK] Kestrel Restarted Successfully', fg="yellow")

    time.sleep(3)


@cli.command()
def kestrel_configs():
    """
    Changing Kestrel Service Configs
    """

    click.echo('Starting...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'kestrelConfigs')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] ACO Server Configs Applied Error', fg="red")
    else:
        click.secho('[OK] ACO Server Configs Applied Successfully', fg="yellow")
        click.secho('Please Reboot the Server Completely', fg="yellow")

    time.sleep(3)


@cli.command()
def mongo_stop():
    """
    Stop MongoDB Service
    """

    click.echo('Stopping...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'mongoStop')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] MongoDB Could not be Stopped', fg="red")
    else:
        click.secho('[OK] MongoDB Stopped Successfully', fg="yellow")

    time.sleep(3)


@cli.command()
def mongo_start():
    """
    Start MongoDB Service
    """

    click.echo('Starting...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'mongoStart')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] MongoDB Could not be Started', fg="red")
    else:
        click.secho('[OK] MongoDB Started Successfully', fg="yellow")

    time.sleep(3)


@cli.command()
def mongo_restart():
    """
    Restart MongoDB Service
    """

    click.echo('Restarting...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'mongoRestart')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] MongoDB Could not be Restarted', fg="red")
    else:
        click.secho('[OK] MongoDB Restarted Successfully', fg="yellow")

    time.sleep(3)


@cli.command()
def aco_mysql_stop():
    """
    Stop ACO MySQL Service
    """

    click.echo('Stopping...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'acoMysqlStop')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] MySQL Could not be Stopped', fg="red")
    else:
        click.secho('[OK] MySQL Stopped Successfully', fg="yellow")

    time.sleep(3)


@cli.command()
def aco_mysql_start():
    """
    Start ACO MySQL Service
    """

    click.echo('Starting...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'acoMysqlStart')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] MySQL Could not be Started', fg="red")
    else:
        click.secho('[OK] MySQL Started Successfully', fg="yellow")

    time.sleep(3)


@cli.command()
def aco_mysql_restart():
    """
    Restart ACO MySQL Service
    """

    click.echo('Restarting...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'acoMysqlRestart')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] MySQL Could not be Restarted', fg="red")
    else:
        click.secho('[OK] MySQL Restarted Successfully', fg="yellow")

    time.sleep(3)


@cli.command()
def nginx_stop():
    """
    Stop Nginx Service
    """

    click.echo('Stopping...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'nginxStop')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Nginx Could not be Stopped', fg="red")
    else:
        click.secho('[OK] Nginx Stopped Successfully', fg="yellow")

    time.sleep(3)


@cli.command()
def nginx_start():
    """
    Start Nginx Service
    """

    click.echo('Starting...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'nginxStart')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Nginx Could not be Started', fg="red")
    else:
        click.secho('[OK] Nginx Started Successfully', fg="yellow")

    time.sleep(3)


@cli.command()
def nginx_restart():
    """
    Restart Nginx Service
    """

    click.echo('Restarting...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'nginxRestart')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Nginx Could not be Restarted', fg="red")
    else:
        click.secho('[OK] Nginx Restarted Successfully', fg="yellow")

    time.sleep(3)


@cli.command()
def nginx_config():
    """
    Changing Nginx Configs
    """

    click.echo('Starting...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'nginxOverrideConfigs')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Nginx Could not be updated', fg="red")
    else:
        click.secho('[OK] Nginx was updated Successfully, Nginx.', fg="yellow")

    time.sleep(3)


@cli.command()
def tomcat_stop():
    """
    Stop Tomcat Service
    """

    click.echo('Stopping...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'tomcatStop')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Tomcat Could not be Stopped', fg="red")
    else:
        click.secho('[OK] Tomcat Stopped Successfully', fg="yellow")

    time.sleep(3)


@cli.command()
def tomcat_start():
    """
    Start Nginx Service
    """

    click.echo('Starting...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'tomcatStart')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Tomcat Could not be Started', fg="red")
    else:
        click.secho('[OK] Tomcat Started Successfully', fg="yellow")

    time.sleep(3)


@cli.command()
def tomcat_restart():
    """
    Restart Tomcat Service
    """

    click.echo('Restarting...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'tomcatRestart')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Tomcat Could not be Restarted', fg="red")
    else:
        click.secho('[OK] Tomcat Restarted Successfully', fg="yellow")

    time.sleep(3)


def is_ha_configured():
    p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'isEnable')], stdout=PIPE,
                         stderr=PIPE)

    for line in p.stdout:
        if 'Error: cluster is not currently running on this node' in line:
            return False
        else:
            return True


def is_ha_enable():
    p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'isEnable')], stdout=PIPE,
                         stderr=PIPE)

    for line in p.stdout:
        if 'enable' in line:
            return True
        else:
            return False


@cli.command()
def ha_enable():
    """
    Enable High Availability Service
    """
    print("Enabling...")
    p = Popen(["sh", mapper.get('GeneralScripts', 'haEnable')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Cannot reach high availability, was it created?', fg="red")
    else:
        click.secho('[OK] High Availability is Enable', fg="yellow")

    time.sleep(3)


@cli.command()
def ha_disable_cluster(installed_app, replication_type):
    """
    Disable High Availability Service
    """
    if click.confirm('Are You sure you want to remove the High Availability Configurations?'):
        print('Cleaning sync db settings')
        print("Removing replication pre-conditions on: " + installed_app)
        if installed_app == 'aco':
            remove_mongo_replication()
        elif replication_type == "master-slaves":
            remove_replication_general_configs()
            remove_replication_db_configs()
        elif replication_type == "master-master":
            disable_redundancy()

        p = Popen(["sh", mapper.get('GeneralScripts', 'haDisableCluster')], stdout=PIPE, stderr=PIPE)
        for line in p.stdout:
            print(line)
        for line in p.stderr:
            print(line)
        p.wait()

        if p.returncode != 0:
            click.secho('[FAIL] Cannot reach high availability, is it running?', fg="red")
            return
        else:
            click.secho('[OK] High Availability is Disable', fg="yellow")

        time.sleep(3)
        click.pause('Please press any key to continue...')


@cli.command()
def ha_disable():
    """
    Disable High Availability Service
    """

    p = Popen(["sh", mapper.get('GeneralScripts', 'haDisable')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    for line in p.stderr:
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Cannot reach high availability, is it running?', fg="red")
    else:
        click.secho('[OK] High Availability is Disable', fg="yellow")

    time.sleep(3)


@cli.command()
@click.option('--date', prompt='date in MMDDhhmmYYYY format')
def set_date(date):
    """Set Date Manually"""
    p = subprocess.Popen(["sh", mapper.get('DateScripts', 'setDate'), date], stdout=PIPE,
                         stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    if p.returncode != 0:
        print(p.returncode)

    time.sleep(5)


@cli.command()
def get_date():
    """Get Current Date """
    p = subprocess.Popen(["sh", mapper.get('DateScripts', 'getDate')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    if p.returncode != 0:
        print(p.returncode)

    p.wait()

    time.sleep(3)


def restart_network(ctx, interface):
    try:
        if click.confirm(
                'The network interface is about to restart, Are you sure you want to restart this network interface? If this is your primary network interface, you may lose connection to this command prompt. '):
            ctx.invoke(network_restart, interface)
        else:
            menu = 'network'
    except click.Abort:
        menu = 'network'


def execute_timezones():
    p = subprocess.Popen(["sh", mapper.get('DateScripts', 'timezoneScript')], stdout=PIPE, stderr=PIPE)
    p.wait()


def see_regions():
    regions = ['Africa', 'America', 'Antarctica', 'Arctic', 'Asia', 'Atlantic', 'Australia', 'Europe',
               'Indian', 'Pacific']

    utc = {"-11": "Pacific/Apia", "-10": "Pacific/Honolulu", "-9": "America/Whitehorse",
           "-8": "America/Anchorage", "-7": "America/Phoenix", "-6": "America/Denver",
           "-5": "America/Chicago", "-4": "America/New_York", "-3": "America/Argentina",
           "0": "Africa/Abidjan", "+1": "Europe/London",
           "+2": "Europe/Rome", "+3": "Europe/Bucharest", "+4": "Europe/Samara",
           "+5": "Asia/Oral", "+6": "Asia/Omsk", "+7": "Asia/Krasnoyarsk",
           "+8": "Australia/Perth", "+9": "Asia/Seoul", "+10": "Australia/Melbourne",
           "+11": "Asia/Srednekolymsk", "+12": "Pacific/Auckland", "+13": "Pacific/Apia"}

    click.clear()
    click.secho('0. Africa', fg='green')
    click.secho('1. Americas', fg='green')
    click.secho('2. Antarctica', fg='green')
    click.secho('3. Arctic Ocean', fg='green')
    click.secho('4. Asia', fg='green')
    click.secho('5. Atlantic Ocean', fg='green')
    click.secho('6. Australia', fg='green')
    click.secho('7. Europe', fg='green')
    click.secho('8. Indian Ocean', fg='green')
    click.secho('9. Pacific Ocean', fg='green')
    click.secho('p. Use Time Zone Offset', fg='green')
    click.secho('b. Back to Configure Time Menu', fg='red')

    click.secho('\nSelect an option: ', fg='white', blink=True, nl=False)
    try:
        char = click.getchar()
        click.echo('')

        if char == 'p':

            try:
                click.echo('Numbers from -11 to +13 are allowed.')
                shift = click.prompt('Please an offset from UTC (i.e: 0, -11, +13, -3)')

                click.echo('setting %s' % utc.get(shift))
                if shift == '-2' or shift == '-1':
                    click.pause('There is no city using this timezone. Press any key to continue...')
                else:
                    try:
                        set_timezones(utc.get(shift))

                    except:
                        click.pause('%s is not a valid offset. Ensure you have entered \"+\" or \"-\" next to the '
                                    'number. Press any key to continue...' % shift)
                        see_regions()
            except click.Abort:
                menu = 'time'

        elif char == 'b':
            menu = 'time'

        elif char.isdigit() and 0 <= int(char) <= 9:
            region = regions[int(char)]
            see_timezones(region)

        else:
            click.pause('Wrong choice, please select one from the list. Press any key to continue...')
            see_regions()

    except click.Abort:
        menu = 'time'


def change_posix_time(tz):
    tz2 = '\'' + tz + '\''
    p = subprocess.Popen(["export", 'TZ=' + tz2], stdout=PIPE, stderr=PIPE)

    click.echo('New date is: ', nl=False)
    p = subprocess.Popen(["sh", mapper.get('DateScripts', 'getDate')], stdout=PIPE, stderr=PIPE)

    for line in p.stdout:
        print(line)
    p.wait()

    time.sleep(3)


def see_files_in_folder(folder):
    click.clear()

    p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'seeFiles'), folder], stdout=PIPE, stderr=PIPE)

    lines = []
    i = 1
    for line in p.stdout:
        lines.append('%s. ' % click.style(str(i), fg='green') + click.style(line, fg='white'))
        i += 1

    max_per_page = 20
    offset = 0
    total = len(lines)

    if total == 0:
        click.echo('Could not find an Update file.')
        click.echo('Go to the following links to Upload the Update Files:\n')
        click.echo('Appliance Manager: <Server IP or Hostname>/appliance')
        click.echo('PME: <Server IP or Hostname>/pme/update and perform a Manual Update\n')
        click.pause('Please press any key to continue...')
        return ''

    choice = ''
    while choice != 'e':
        click.clear()
        for line in lines[offset:offset + max_per_page]:
            click.echo(line, nl=False)

        choice = click.prompt('Previous p, Next n, Select file line number (press e to exit)')

        if choice == 'p':
            if offset > 0:
                offset -= max_per_page
        elif choice == 'n':
            if offset + max_per_page < total:
                offset += max_per_page
        elif choice.isdigit():
            if int(choice) == 0:
                click.echo('Please select a valid file')
                time.sleep(2)
            elif int(choice) <= total:
                resp = lines[int(choice) - 1].rstrip('\n').split(' ')[1]
                click.echo('file to be used: %s' % resp + ' ...')
                time.sleep(1)
                return folder + '/' + resp
            else:
                click.echo('Please select a valid file')
                time.sleep(2)

    return ''


def see_timezones(region):
    click.clear()
    """See Available TimeZones """
    p = subprocess.Popen(["sh", mapper.get('DateScripts', 'seeTimeZones'), region], stdout=PIPE, stderr=PIPE)

    lines = []
    i = 1
    for line in p.stdout:
        lines.append('%s. ' % str(i) + ' ' + line)
        i += 1

    max_per_page = 20
    offset = 0
    total = len(lines)

    choice = ''
    while choice != 'e':
        click.clear()
        for line in lines[offset:offset + max_per_page]:
            click.echo(line, nl=False)

        choice = click.prompt('Previous p, Next n, Select a locale by number (Press e to exit)')

        if choice == 'p':
            if offset > 0:
                offset -= max_per_page
        elif choice == 'n':
            if offset + max_per_page < total:
                offset += max_per_page
        elif choice.isdigit():
            if int(choice) <= total:
                click.echo('setting timezone to: %s' % lines[int(choice) - 1].rstrip('\n').split()[1])
                time.sleep(1)
                timezone = region + '/' + lines[int(choice) - 1].rstrip('\n').split()[1]
                set_timezones(timezone)
                return
            else:
                click.echo('Please select a valid line')
                time.sleep(2)


def set_timezones(timezone):
    delete_timezone()

    timezone2 = timezone.replace("\n", "")

    p = subprocess.Popen(["sh", mapper.get('DateScripts', 'setTimeZone'), timezone2], stdout=PIPE, stderr=PIPE)

    for line in p.stdout:
        print(line)

    p.wait()

    click.secho('Writing time zone into ini file...', fg="yellow")

    p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'writeTimeZoneIntoIni'), timezone2], stdout=PIPE, stderr=PIPE)

    for line in p.stdout:
        print(line)

    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Time Zone Could not be set', fg="red")
    else:
        click.secho('[OK] Time Zone Set Successfully', fg="yellow")

    time.sleep(2)


def delete_timezone():
    p = subprocess.Popen(["sh", mapper.get('DateScripts', 'deleteTimeZone')], stdout=PIPE, stderr=PIPE)

    for line in p.stdout:
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho(
            '[FAIL] Time Zone could not be deleted since set to UTC.\n  Time Zone may have previously been deleted.',
            fg="red")
    else:
        click.secho('[OK] Time Zone Deleted Successfully', fg="yellow")

    time.sleep(5)


@cli.command()
def get_timezone():
    """Get TimeZone"""
    p = subprocess.Popen(["sh", mapper.get('DateScripts', 'getTimeZone')], stdout=PIPE, stderr=PIPE)
    status_ = []
    for line in p.stdout:
        if line.rstrip('\n') is not None and line.rstrip('\n') is not "":
            click.echo(line)
            status_.append(line)

    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Undetermined Time Zone', fg="red")

    if len(status_) == 0:
        click.secho('[OK] Time Zone has not been set', fg="yellow")

    time.sleep(3)


def write_new_configs(ip, dns1, dns2, netmask, gateway, dhcp, interface):
    click.echo('Saving Network configs...')
    configs_to_update = []
    values_to_update = []
    if ip != '':
        click.echo('Saving IP...')
        configs_to_update.append('IPADDR')
        values_to_update.append(ip)
    if netmask != '':
        click.echo('Saving Network NETMASK...')
        configs_to_update.append('NETMASK')
        values_to_update.append(netmask)
    if gateway != '':
        click.echo('Saving Network GATEWAY...')
        configs_to_update.append('GATEWAY')
        values_to_update.append(gateway)
    if dns1 != '':
        click.echo('Saving Network DNS1...')
        # modify_dns(mapper.get('GeneralConfigs', 'dns_file'), 'dns1', dns1)
        configs_to_update.append('DNS1')
        values_to_update.append(dns1)
    if dns2 != '':
        click.echo('Saving Network DNS2...')
        # modify_dns(mapper.get('GeneralConfigs', 'dns_file'), 'dns2', dns2)
        configs_to_update.append('DNS2')
        values_to_update.append(dns2)
    if dhcp != '':
        configs_to_update.append('BOOTPROTO')
        values_to_update.append(dhcp)
    if configs_to_update:
        modify_config_file(mapper.get('GeneralConfigs', 'network_interface_file') + interface, configs_to_update,
                           values_to_update)
        # shutil.copy(mapper.get('GeneralConfigs', 'network_interface_file'),
        #            mapper.get('GeneralConfigs', 'network_interface_tmp_file'))


@cli.command()
@click.option('--currentversion', prompt='version to be overwritten')
@click.option('--zipinstaller', prompt='path to the zip installer file', type=click.Path())
def pme_update(currentversion, zipinstaller):
    """Update PME"""

    p = subprocess.Popen(["sh", mapper.get('ApplicationScripts', 'pmeUpdateScript'), currentversion, zipinstaller],
                         stdout=PIPE,
                         stderr=PIPE)

    for line in p.stdout:
        print(line)
    p.wait()

    out, err = p.communicate()
    time.sleep(10)

    if err:
        click.secho('PME Warning/Error')
        click.secho(err)
        click.pause('Press any key to continue...')
        return
    else:
        click.pause('PME was Updated correctly. Press any key to continue...')
        return


@cli.command()
def push_installation(nodes):
    """Update PME"""

    nodes_string = ""
    for i in nodes:
        nodes_string += str(i) + " "

    p = subprocess.Popen(["sh", mapper.get('ApplicationScripts', 'pushScript'), nodes_string],
                         stdout=PIPE,
                         stderr=PIPE)

    for line in p.stdout:
        print(line)
    p.wait()

    out, err = p.communicate()

    if err:
        click.secho('Warning/Error')
        click.secho(err)
        click.pause('Press any key to continue...')
        return
    else:
        click.pause('Product was Updated correctly. Press any key to continue...')
        return


@cli.command()
@click.option('--zipinstaller', prompt='path to the zip installer file', type=click.Path())
def cm_update(zipinstaller):
    """Update ACM"""

    p = subprocess.Popen(["sh", mapper.get('ApplicationScripts', 'cmUpdateScript'), zipinstaller],
                         stdout=PIPE,
                         stderr=PIPE)

    for line in p.stdout:
        print(line)
    p.wait()

    out, err = p.communicate()
    time.sleep(10)

    if err:
        click.secho('ACM Warning/Error')
        click.secho(err)
        click.pause('Press any key to continue...')
        return
    else:
        click.pause('ACM was Updated correctly. Press any key to continue...')
        return


def server_update(zipinstaller, md5code):
    """
    Update ACO SERVER
    """

    p = subprocess.Popen(["sh", mapper.get('ApplicationScripts', 'serverUpdateScript'), zipinstaller, md5code],
                         stdout=PIPE, stderr=PIPE)

    out, err = p.communicate()
    for line in out.splitlines():
        print(line)

        if 'ERROR' in line:
            click.pause('ACO SERVER was not updated. Press any key to continue...')
            return

    click.pause('ACO SERVER was updated correctly. Press any key to continue...')
    return


def web_update(zipinstaller, md5code):
    """
    Update ACO WEB
    """

    p = subprocess.Popen(["sh", mapper.get('ApplicationScripts', 'webUpdateScript'), zipinstaller, md5code],
                         stdout=PIPE, stderr=PIPE)

    out, err = p.communicate()
    for line in out.splitlines():
        print(line)

        if 'ERROR' in line:
            click.pause('ACO WEB was not updated. Press any key to continue...')
            return

    click.pause('ACO WEB was updated correctly. Press any key to continue...')
    return


def aco_update(zip_installer, jtapi_version):
    """
    Update ACO
    """

    p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'acoUpdateScript'), zip_installer, jtapi_version],
                         stdout=PIPE, stderr=PIPE)

    out, err = p.communicate()
    time.sleep(10)

    for line in out.splitlines():
        print(line)

        if 'ERROR' in line:
            click.pause('ACO was not updated. Press any key to continue...')
            return

    click.pause('ACO was updated correctly. Press any key to continue...')
    return


def server_certificates_update(zipinstaller, md5code):
    """
    Update ACO SERVER CERTIFICATES
    """

    p = subprocess.Popen(["sh", mapper.get('ApplicationScripts', 'serverCertUpdateScript'), zipinstaller, md5code],
                         stdout=PIPE, stderr=PIPE)

    out, err = p.communicate()
    for line in out.splitlines():
        print(line)

        if 'ERROR' in line:
            click.pause('ACO SERVER CERTIFICATES was not updated. Press any key to continue...')
            return

    click.pause('ACO SERVER CERTIFICATES was updated correctly. Press any key to continue...')
    return


def web_certificates_update(zipinstaller, md5code):
    """
    Update ACO WEB CERTIFICATES
    """

    p = subprocess.Popen(["sh", mapper.get('ApplicationScripts', 'webCertUpdateScript'), zipinstaller, md5code],
                         stdout=PIPE, stderr=PIPE)

    out, err = p.communicate()
    for line in out.splitlines():
        print(line)

        if 'ERROR' in line:
            click.pause('ACO WEB CERTIFICATES was not updated. Press any key to continue...')
            return

    click.pause('ACO WEB CERTIFICATES was updated correctly. Press any key to continue...')
    return


def add_node(ip):
    """
    Add High Availability Node
    """
    master = get_ip()
    p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'addNodeScript'), master, ip],
                         stdout=PIPE, stderr=PIPE)

    out, err = p.communicate()
    time.sleep(5)

    for line in out.splitlines():
        print(line)

    for line in err.splitlines():
        print(line)

        if 'Error' in line:
            click.pause('\nERROR: The new HA node was not added. Press any key to continue...')
            return

    click.pause('The new HA node was added correctly. Press any key to continue...')
    return


def remove_node(master, ip):
    """
    Remove High Availability Node
    """
    print("This will delay, please wait while everything necessary is configure...")
    p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'removeNodeScript'), master, ip],
                         stdout=PIPE, stderr=PIPE)

    out, err = p.communicate()
    time.sleep(10)

    for line in out.splitlines():
        print(line)

    for line in err.splitlines():
        print(line)

        if 'Error' in line:
            click.pause('ERROR: The HA node was not remove. Press any key to continue...')
            return

    click.pause('The new HA node was removed correctly. Press any key to continue...')
    return


@cli.command()
def edit_snmp_configs():
    click.edit(filename=mapper.get('GeneralConfigs', 'snmpFile'))


@cli.command()
def edit_apache_configs():
    """Open httpd.conf"""
    click.edit(filename=mapper.get('GeneralConfigs', 'apacheFile'))


@cli.command()
def edit_php_ini():
    """Edit php.ini file"""
    click.edit(filename=mapper.get('GeneralConfigs', 'phpFile'))


@cli.command()
def edit_proxy():
    """Edit /etc/environment file"""
    click.edit(filename=mapper.get('GeneralConfigs', 'proxyFile'))


@cli.command()
def edit_my_ini():
    """Edit my.ini file"""
    click.edit(filename=mapper.get('GeneralConfigs', 'myFile'))


@cli.command()
@pass_config
def status(config):
    """Shows the status."""
    click.echo('Status for %s' % config.path)


def modify_dns(infile, dns, new_value):
    click.echo(infile)
    lines = open(infile, 'r').readlines()
    if dns == 'dns1':
        lines[0] = "nameserver " + new_value + "\n"
    elif dns == 'dns2':
        lines[1] = "nameserver " + new_value + "\n"

    outfile = open(infile, 'a')
    outfile.writelines(lines)
    click.echo("lines wrote")


def modify_config_file(infile, config_to_update, value_to_update):
    lines_new = []
    lines = open(infile, 'r').readlines()
    for line in lines:
        line_words = line.split('=')
        for i in range(len(config_to_update)):
            if line_words[0] == config_to_update[i]:
                line_words[1] = value_to_update[i]
                line = line_words[0] + '=' + line_words[1] + '\n'
                break

        lines_new = lines_new + [line]

    outfile = open(infile, 'w')
    outfile.writelines(lines_new)


def add_config_file(infile, config_to_add, value_to_add):
    with open(infile, "a") as file:
        for i in range(len(config_to_add)):
            file.write(config_to_add[i] + '=' + value_to_add[i] + '\n')


def set_servers_ntp_file(infile, value_to_change):
    try:
        inf = open(infile, 'r')
        lines = inf.readlines()

        inf = open(infile, 'w')

        for line in lines:
            line_words = line.split(' ')
            if line_words[0] != 'server':
                inf.write(line)

        for i in range(len(value_to_change)):
            inf.write("server " + value_to_change[i] + ' iburst\n')

    except:
        click.pause(
            'NTP Services were not updated correctly. Check if service is installed ( option 7 ) Press any key to continue...')

    return True


def get_servers_ntp_file(infile):
    try:
        inf = open(infile, 'r')
        lines = inf.readlines()
        servers = []

        for line in lines:
            line_words = line.split(' ')
            if line_words[0] == 'server':
                servers.append(line)
    except:
        click.pause('NTP Services error. Check if service is installed ( option 7 ) Press any key to continue...')

    return servers


@cli.command()
def install_ntp():
    click.pause('NTP Services is about to be installed...')
    p = subprocess.Popen(["sh", mapper.get('DateScripts', 'NTPInstall')],
                         stdout=PIPE, stderr=PIPE)
    i = 0
    for line in p.stdout:
        i + 1
        print(line)
    p.wait()

    click.pause('NTP Services were updated correctly. Press any key to continue...')
    return


@cli.command()
def edit_logback():
    """Edit logback file"""
    click.edit(filename=mapper.get('GeneralConfigs', 'logback'))


@cli.command()
def edit_acolog():
    """Edit acolog file"""
    click.edit(filename=mapper.get('GeneralConfigs', 'acolog'))


@cli.command()
def tail_f_acoserver():
    click.echo('tail into file...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'acologtail')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    time.sleep(3)


@cli.command()
def tail_f_acoweb():
    click.echo('tail into file...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'weblogtail')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    time.sleep(3)


@cli.command()
def remove_events_duplicated():
    click.echo('removing duplicated...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'removeDuplicated')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    time.sleep(3)


@cli.command()
def see_console_events():
    click.echo('getting console events...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'getConsoleEvents')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    time.sleep(3)


@cli.command()
def see_console_events_web():
    click.echo('getting web console events...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'getConsoleEventsWeb')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    time.sleep(3)


@cli.command()
def reset_aco_admin_pass():
    click.echo('Reseting Admin password...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'resetACOAdminPass')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    time.sleep(3)


@cli.command()
def remove_web_service():
    click.echo('removing web console service...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'tomcatRemove')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    time.sleep(3)


@cli.command()
def add_web_service():
    click.echo('adding web console service...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'tomcatAdd')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    time.sleep(3)


@cli.command()
def run_sync_dbs():
    p = Popen(["sh", mapper.get('GeneralScripts', 'haSyncDbs')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    time.sleep(3)
    click.pause('Press any key to continue...')


def add_sync_crontab(line):
    try:
        print(line)
        p = Popen(["sh", mapper.get('GeneralScripts', 'haSyncDbsScheduler'), line], stdout=PIPE, stderr=PIPE)
        for line in p.stdout:
            print(line)
        p.wait()

        time.sleep(3)
    except:
        click.pause('There was an error. Press any key to continue...')


def remove_sync_crontab():
    try:
        p = Popen(["sh", mapper.get('GeneralScripts', 'haSyncDbsSchedulerRemove')], stdout=PIPE, stderr=PIPE)
        for line in p.stdout:
            print(line)
        p.wait()

        time.sleep(3)
    except:
        click.pause('There was an error. Press any key to continue...')


def get_sync_crontab():
    p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'haSyncDbsGetCrontab')], stdout=PIPE,
                         stderr=PIPE)
    crontab = []

    for line in p.stdout:
        crontab.append(line)

    if len(crontab) == 1:
        if crontab[0] == '0 0 * * * /home/akkadianuser/scripts/sync_dbs.sh\n':
            return 'Synchronization is configured to be run once per day during the night'
        elif crontab[0] == '0 * * * * /home/akkadianuser/scripts/sync_dbs.sh\n':
            return 'Synchronization is configured to be run hourly'
        elif crontab[0] != '':
            return 'Synchronization is manually configured: ' + crontab[0]

    elif len(crontab) == 2:
        if crontab[0] == '0 0 * * * /home/akkadianuser/scripts/sync_dbs.sh\n' and crontab[
            1] == '0 12 * * * /home/akkadianuser/scripts/sync_dbs.sh\n':
            return 'Synchronization is configured to be run twice per day during the night and at noon'
        else:
            return 'Synchronization is manually configured: ' + crontab[0] + '\n' + crontab[1]

    elif len(crontab) > 2 and crontab[0] != '':
        print('Synchronization is manually configured\n')
        for i in crontab:
            print(i)

    return 'Synchronization is not configured.'


def get_sync_date(file):
    try:
        p = Popen(["sh", mapper.get('GeneralScripts', 'haSyncDbsGetDate'), file], stdout=PIPE, stderr=PIPE)
        date = ''
        for line in p.stdout:
            date = line

        return date
    except:
        print('There was an error. Press any key to continue...')
        return 'No date'


def get_master():
    try:
        p = Popen(["sh", mapper.get('GeneralScripts', 'haGetMaster')], stdout=PIPE, stderr=PIPE)
        master = ''
        for line in p.stdout:
            master = line

        return master
    except:
        print('There was an error. Press any key to continue...')
        return 'No data'


def get_onlines():
    try:
        p = Popen(["sh", mapper.get('GeneralScripts', 'haGetOnlines')], stdout=PIPE, stderr=PIPE)
        out = ''
        nodes = ''
        for line in p.stdout:
            nodes = line

        nodes_space = nodes.split(" ")

        for node in nodes_space:
            if '[' not in node and ']' not in node:
                out = out + ' ' + node + '\n'

        return out
    except:
        print('There was an error. Press any key to continue...')
        return 'No data'


def get_offlines():
    try:
        p = Popen(["sh", mapper.get('GeneralScripts', 'haGetOfflines')], stdout=PIPE, stderr=PIPE)
        out = ''
        nodes = ''
        for line in p.stdout:
            nodes = line

        nodes_space = nodes.split(" ")

        for node in nodes_space:
            if '[' not in node and ']' not in node:
                out = out + ' ' + node + '\n'

        return out
    except:
        print('There was an error. Press any key to continue...')
        return 'No data'


def add_replication_preconditions():
    try:
        p = Popen(["sh", mapper.get('GeneralScripts', 'dbAddReplicationPreconditions')], stdout=PIPE, stderr=PIPE)

        lines = []
        for line in p.stdout:
            lines.append(line)

        print("Success")

        return
    except Exception as e:
        print(e)
        return


def add_replication_posconditions():
    try:
        p = Popen(["sh", mapper.get('GeneralScripts', 'dbAddReplicationPosconditions')], stdout=PIPE, stderr=PIPE)

        lines = []
        for line in p.stdout:
            lines.append(line)

        print("Success")

        return
    except Exception as e:
        print(e)
        return


def master_replication():
    try:
        print('Running Master Replication Script')
        p = Popen(["sh", mapper.get('GeneralScripts', 'dbRunMasterReplication')], stdout=PIPE, stderr=PIPE)

        for line in p.stdout:
            print(line)
        click.pause("Replication was executed, please press any key to continue...")
        return
    except Exception as e:
        print(e)
        return


def remove_replication_general_configs():
    try:
        click.secho("removing replication general config", fg='green')
        p = Popen(["sh", mapper.get('GeneralScripts', 'removeReplicationGeneralConfigurations')], stdout=PIPE,
                  stderr=PIPE)

        # for line in p.stdout:
        #    print(line)

        return
    except Exception as e:
        print(e)
        return


def remove_replication_db_configs():
    try:
        click.secho("removing replication db configs", fg='green')
        p = Popen(["sh", mapper.get('GeneralScripts', 'removeReplicationDbConfigurations')], stdout=PIPE, stderr=PIPE)

        # for line in p.stdout:
        #    print(line)

        return
    except Exception as e:
        print(e)
        return


def replication_masterslaves_status():
    try:
        print('Getting Replication status')
        p = Popen(["sh", mapper.get('GeneralScripts', 'dbReplicationStatus')], stdout=PIPE, stderr=PIPE)

        for line in p.stdout:
            print(line)
        click.pause('Please press any key to continue...')
        return
    except Exception as e:
        print(e)
        return


def get_masterslaves_replication_status():
    try:
        p = Popen(["sh", mapper.get('GeneralScripts', 'dbReplicationStatusDetailed')], stdout=PIPE, stderr=PIPE)

        lines = []
        for line in p.stdout:
            lines.append(line)

        if len(lines) > 1:
            if "Slave_IO_Running: Yes" in lines[1]:
                return "Status: Database Replication Running \n" + lines[0].strip()
            else:
                return "Status: Database Replication is Not Running"
        else:
            return "Status: Database Replication is Not Running"

    except Exception as e:
        print(e)
        return


def is_replication_masterslaves_enable():
    try:
        p = Popen(["sh", mapper.get('GeneralScripts', 'dbReplicationStatusDetailed')], stdout=PIPE, stderr=PIPE)

        lines = []
        for line in p.stdout:
            lines.append(line)

        if len(lines) > 1:
            if "Slave_IO_Running: Yes" in lines[1]:
                return True
            else:
                return False

        else:
            return False

    except Exception as e:
        print(e)
        return


def determine_master_and_run_replication():
    try:
        p = Popen(["sh", mapper.get('GeneralScripts', 'dbDetermineMasterAndRunMasterReplication')], stdout=PIPE,
                  stderr=PIPE)

        lines = []
        for line in p.stdout:
            lines.append(line)

        print("Success")
        return

    except Exception as e:
        print(e)
        return


def get_simple_hostname():
    p = subprocess.Popen(["sh", mapper.get('NetworkScripts', 'getSimpleHostname')], stdout=PIPE,
                         stderr=PIPE)

    for line in p.stdout:
        return line


def enable_snmp():
    try:
        p = Popen(["sh", mapper.get('GeneralScripts', 'enableSnmp')], stdout=PIPE, stderr=PIPE)

        lines = []
        for line in p.stdout:
            lines.append(line)

        print("Success")
        return

    except Exception as e:
        print(e)
        return


def disable_snmp():
    try:
        p = Popen(["sh", mapper.get('GeneralScripts', 'disableSnmp')], stdout=PIPE, stderr=PIPE)

        lines = []
        for line in p.stdout:
            lines.append(line)

        print("Success")
        return

    except Exception as e:
        print(e)
        return


def is_snmp_enabled():
    try:
        p = Popen(["sh", mapper.get('GeneralScripts', 'isSnmpEnable')], stdout=PIPE, stderr=PIPE)

        for line in p.stdout:
            if 'inactive' in line:
                return False
            else:
                return True

    except Exception as e:
        print(e)
        return False


def reach_ip(new_ip):
    # type: (object) -> object
    p = subprocess.Popen(["sh", mapper.get('NetworkScripts', 'checkIpExist'), new_ip], stdout=PIPE,
                         stderr=PIPE)

    looking4allPackagesArrived = ''

    for line in p.stdout:
        looking4allPackagesArrived = line;

    # if 100% packages sent, 0 lost is not in the string
    if '0' in looking4allPackagesArrived:
        return False  # not reaching
    else:
        return True  # reaching


def add_mongo_replication():
    try:
        print('Adding Replication Configurations, please wait...')
        p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'setMongoReplication')], stdout=PIPE,
                             stderr=PIPE)
        lines = []
        for line in p.stdout:
            lines.append(line)
            print(line)

        print("Adding Mongo Replication -- Success")
        return

    except Exception as e:
        print(e)
    return


def mongo_replication_postconditions():
    try:
        p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'setMongoReplicationPostconditions')], stdout=PIPE,
                             stderr=PIPE)
        lines = []
        for line in p.stdout:
            lines.append(line)
            print(line)

        return

    except Exception as e:
        print(e)
    return


def remove_mongo_replication():
    try:
        print('Removing Replication Configurations, please wait...')
        p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'removeMongoReplication')], stdout=PIPE,
                             stderr=PIPE)
        lines = []
        for line in p.stdout:
            lines.append(line)

        print("Removing Mongo Replication -- Success")
        return

    except Exception as e:
        print(e)
    return


def status_mongo_replication():
    try:
        p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'statusMongoReplication')], stdout=PIPE,
                             stderr=PIPE)
        lines = []
        for line in p.stdout:
            print(line)

        f = open("/home/akkadianuser/scripts/mongo_replica_scripts/status_output", "r")
        contents = f.read()
        print(contents)

        click.pause("Status Mongo Replication, please press any key to continue")
        return

    except Exception as e:
        print(e)
    return


def is_replica_enabled():
    try:
        p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'statusMongoReplication')], stdout=PIPE,
                             stderr=PIPE)
        lines = []
        for line in p.stdout:
            print(line)

        f = open("/home/akkadianuser/scripts/mongo_replica_scripts/status_output", "r")
        contents = f.read()
        if '"ok" : 1' in contents:
            return True
        else:
            return False
    except Exception as e:
        return False


def get_jtapi(cucm_url):
    try:
        p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'getJtapiLibrary'), cucm_url], stdout=PIPE,
                             stderr=PIPE)

        for line in p.stdout:
            print(line)

    except Exception as e:

        print(e)
        return False


############################ REDUNDANCY SUPPORT ###############################

def is_mastermaster_mastersalve_replication_enabled():
    try:
        p = Popen(["sh", mapper.get('GeneralScripts', 'isRedundancyEnabled')], stdout=PIPE, stderr=PIPE)

        lines = []
        for line in p.stdout:
            lines.append(line)

        if len(lines) > 1:
            if "Slave_IO_Running: Yes" in lines[1]:
                return True
            else:
                return False
        else:
            return False

    except Exception as e:
        print(e)
    return False


def enable_redundancy(ha_nodes):
    try:
        click.secho('Adding Master-Master Replication Pre-conditions', fg='green')
        p = subprocess.Popen(
            ["sh", mapper.get('GeneralScripts', 'enableRedundancyPreconditions'), ha_nodes[0], ha_nodes[1]],
            stdout=PIPE, stderr=PIPE)

        time.sleep(5)

        click.secho('Enabling Master-Master Replication', fg='green')
        p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'enableRedundancy')], stdout=PIPE, stderr=PIPE)

        time.sleep(2)
        click.secho('Adding Master-Master Replication Post-conditions', fg='green')
        p = subprocess.Popen(["sh", mapper.get('GeneralScripts', 'enableRedundancyPostconditions')], stdout=PIPE,
                             stderr=PIPE)
        time.sleep(2)
        click.pause(
            "Replication has been initiated, it takes about 1 minute for the changes take effect, press any key to continue...")
        # click.pause("Master-Master Replication script has been executed, please read the output carefully and press any key to continue...")

        return True

    except Exception as e:
        click.pause(e)
        return False


def show_redundancy_status():
    try:
        p = Popen(["sh", mapper.get('GeneralScripts', 'isRedundancyEnabled')], stdout=PIPE, stderr=PIPE)

        lines = []
        for line in p.stdout:
            lines.append(line)

        time.sleep(2)

        p = Popen(["sh", mapper.get('GeneralScripts', 'getNodeList')], stdout=PIPE, stderr=PIPE)

        node_list = []
        for line in p.stdout:
            node_list.append(line)

        if len(lines) > 1:
            if "Slave_IO_Running: Yes" in lines[1]:
                print("Status: Master-Master Database Replication is Running \n Nodes:" + node_list[0])
            else:
                print("Status: Master-Master Database Replication is Not Running")
        else:
            print("Status: Master-Master Database Replication is Not Running")

        click.pause("Press any key to continue...")

    except Exception as e:
        print(e)
        return


def disable_redundancy():
    try:

        if click.confirm("Are you sure you want to disable Master-Master Database Replication?"):
            p = Popen(["sh", mapper.get('GeneralScripts', 'disableRedundancy')], stdout=PIPE, stderr=PIPE)

            for line in p.stdout:
                print(line)

            click.pause("Press any key to continue...")
    except Exception as e:
        print(e)
    return


def get_redundancy_nodelist():
    try:

        p = Popen(["sh", mapper.get('GeneralScripts', 'getNodeList')], stdout=PIPE, stderr=PIPE)
        lines = []
        for line in p.stdout:
            line.replace(" ", "")
            line.replace("\t", "")
            line.replace("\n", "")
            if len(line) > 1:
                lines.append(line)

        if len(lines) > 0:
            return lines[0]
        else:
            return None
    except Exception as e:
        print(e)
    return None


def get_redundancy_offline():
    try:

        p = Popen(["sh", mapper.get('GeneralScripts', 'getOfflineNode')], stdout=PIPE, stderr=PIPE)
        lines = []
        for line in p.stdout:
            lines.append(line)

        if len(lines) > 0:
            second = lines[0]
            if reach_ip(second):
                return None
            else:
                return second
        else:
            return None

    except Exception as e:
        print(e)
    return ""


def get_redundancy_online():
    try:

        p = Popen(["sh", mapper.get('GeneralScripts', 'getOfflineNode')], stdout=PIPE, stderr=PIPE)
        lines = []
        for line in p.stdout:
            lines.append(line)

        second = lines[0]
        node_list = get_redundancy_nodelist()
        if reach_ip(second):
            return node_list
        else:
            return node_list.replace(second, "")

    except Exception as e:
        print(e)
    return ""


def get_virtual_ip():
    try:

        p = Popen(["sh", mapper.get('GeneralScripts', 'getVirtualIp')], stdout=PIPE, stderr=PIPE)
        lines = []
        for line in p.stdout:
            lines.append(line)

        result = lines[0]

        result = result.split('=')

        return result[1]

    except Exception as e:
        print(e)
    return ""


def is_cli_update_available():
    try:
        p = Popen(["sh", mapper.get('GeneralScripts', 'isCliUpdateAvailable')], stdout=PIPE, stderr=PIPE)
        lines = []
        for line in p.stdout:
            lines.append(line)

        result = lines[0]

        if "true" in result:
            return True
        else:
            return False

    except Exception as e:
        print(e)
    return False


def see_ldap_settings():
    try:
        p = Popen(["sh", mapper.get('GeneralScripts', 'seeOpenLDAPSettings')], stdout=PIPE, stderr=PIPE)
        lines = []
        for line in p.stdout:
            lines.append(line)
            print(line)

        click.pause("Please press any key to continue")


    except Exception as e:
        print(e)
    return False


def change_ldap_basedn(new_base_dn):
    try:
        p = Popen(["sh", mapper.get('GeneralScripts', 'changeOpenLDAPBaseDN'), new_base_dn], stdout=PIPE, stderr=PIPE)
        lines = []
        for line in p.stdout:
            lines.append(line)
            print(line)

        click.pause("Please press any key to continue")

    except Exception as e:
        print(e)

    return

def getUpdate_name():
    try:
        p = Popen(["sh", mapper.get('GeneralScripts', 'getUpdateName')], stdout=PIPE, stderr=PIPE)
        lines = []
        for line in p.stdout:
            lines.append(line)

        return lines[0]

    except Exception as e:
        print(e)

    return ""

def ping(host):
    try:
        p = Popen(["sh", mapper.get('GeneralScripts', 'ping'), host], stdout=PIPE, stderr=PIPE)

        for line in p.stdout:
            print(line)
        for line in p.stderr:
            print(line)

        click.pause('Please, press any key to continue...')

    except Exception as e:
        print(e)

    return

def set_olcSizeLimit(limit):
    try:
        p = Popen(["sh", mapper.get('GeneralScripts', 'ldapOrcSizeLimit'), limit], stdout=PIPE, stderr=PIPE)

        for line in p.stdout:
            print(line)
        for line in p.stderr:
            print(line)

        click.pause('OpenLdap Size Limit changed, press any key to continue...')

    except Exception as e:
        print(e)

    return

def supervisor_stop():

    click.echo('Stopping...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'supervisorStop')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Supervisor Could not be Stopped', fg="red")
    else:
        click.secho('[OK] Supervisor Stopped Successfully', fg="yellow")

    time.sleep(3)

def supervisor_start():

    click.echo('Starting...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'supervisorStart')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Supervisor Could not be Started', fg="red")
    else:
        click.secho('[OK] Supervisor Stopped Started', fg="yellow")

    time.sleep(3)

def supervisor_restart():

    click.echo('Restarting...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'supervisorRestart')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Supervisor Could not be restarted', fg="red")
    else:
        click.secho('[OK] Supervisor Stopped restarted', fg="yellow")

    time.sleep(3)

def supervisor_status():

    p = Popen(["sh", mapper.get('GeneralScripts', 'supervisorStatus')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    click.pause('Please, press any key to continue...')

def is_encryption_enabled():
    try:
        p = Popen(["sh", mapper.get('GeneralScripts', 'isEncryptionEnabled')], stdout=PIPE, stderr=PIPE)

        for line in p.stdout:
            if 'yes' in line:
                return True
            else:
                return False

    except Exception as e:
        print(e)
        return False

    return False

def disable_encryption_mode():
    p = Popen(["sh", mapper.get('GeneralScripts', 'disableEncryption')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    click.pause('Please, press any key to continue...')

def enable_encryption_mode():
    p = Popen(["sh", mapper.get('GeneralScripts', 'enableEncryption')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    click.pause('Please, press any key to continue...')

def run_needed_scripts():
    p = Popen(["sh", mapper.get('GeneralScripts', 'runNeededScripts')], stdout=PIPE, stderr=PIPE)

def generate_aco_certificate():
    if click.confirm('This action can modify the behavior of your server, Are you sure you want to continue?'):
        p = Popen(["sh", mapper.get('GeneralScripts', 'generateAcoCertificates')], stdout=PIPE, stderr=PIPE)
        for line in p.stdout:
            print(line)
        p.wait()

        click.pause('Certificate Generated Correctly, please press any key to continue...')

def generate_nonaco_certificate():
    if click.confirm('This action can modify the behavior of your server, Are you sure you want to continue?'):

        p = Popen(["sh", mapper.get('GeneralScripts', 'generateNonAcoCertificates')], stdout=PIPE, stderr=PIPE)
        for line in p.stdout:
            print(line)
        p.wait()

        click.pause('Certificate Generated Correctly, please press any key to continue...')

def force_master():
    if click.confirm('This action can affect external Load Balancer, Are you sure you want to continue?'):

        p = Popen(["sh", mapper.get('GeneralScripts', 'forceMaster')], stdout=PIPE, stderr=PIPE)
        for line in p.stdout:
            print(line)
        p.wait()

        click.pause('Master Node Set Correctly, please press any key to continue...')


def enable_snmpv3():
    p = Popen(["sh", mapper.get('NetworkScripts', 'snmpd_stop')], stdout=PIPE, stderr=PIPE)

    for line in p.stdout:
        print(line)
    p.wait()

    click.secho('stopping snmp...', fg='green')

    time.sleep(3)

    p = subprocess.call(["net-snmp-create-v3-user"])

    click.secho('starting snmp...', fg='green')
    p = Popen(["sh", mapper.get('GeneralScripts', 'chkconfigSNMPv3')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    click.pause('SNMP V3 enabled...')

def installed_app_vs2():
    try:
        p = Popen(["sh", mapper.get('GeneralScripts', 'installedApp')], stdout=PIPE, stderr=PIPE)

        for line in p.stdout:
            if 'aco' in line:
                return 'aco'
            elif 'pme' in line:
                return 'pme'
            elif 'acm' in line:
                return 'acm'

    except Exception as e:
        print(e)
        return 'none'

    return 'none'

def is_snmpv3_enable():
    try:
        p = Popen(["sh", mapper.get('GeneralScripts', 'isSnmpv3Enable')], stdout=PIPE, stderr=PIPE)

        for line in p.stdout:
            if 'enable' in line:
                return True
            else:
                return False

    except Exception as e:
        print(e)
        return False

    return False

def stop_akkadian_executor():
    click.echo('Stopping...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'executorStop')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Akkadian Executor Could not be Stopped', fg="red")
    else:
        click.secho('[OK] Akkadian Executor Stopped Successfully', fg="yellow")

    time.sleep(3)

def start_akkadian_executor():
    click.echo('Starting...')
    p = Popen(["sh", mapper.get('GeneralScripts', 'executorStart')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    if p.returncode != 0:
        click.secho('[FAIL] Akkadian Executor Could not be Started', fg="red")
    else:
        click.secho('[OK] Akkadian Executor Stopped Started', fg="yellow")

    time.sleep(3)

def status_akkadian_executor():
    p = Popen(["sh", mapper.get('GeneralScripts', 'executorStatus')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    click.pause('Please, press any key to continue...')

def enable_auu_in_pme():
    p = Popen(["sh", mapper.get('GeneralScripts', 'enableAuuInPme')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    click.pause('Please, press any key to continue...')

def disable_auu_in_pme():
    p = Popen(["sh", mapper.get('GeneralScripts', 'disableAuuInPme')], stdout=PIPE, stderr=PIPE)
    for line in p.stdout:
        print(line)
    p.wait()

    click.pause('Please, press any key to continue...')