/*
    ngMessages 1.0.0 - user messages for AngularJS
*/
angular.module('ngCustomMessages.provider', [])
    .provider('ngCustomMessages', function () {
        'use strict';
        //Default values for provider
        this.autoCloseTime = 3000;
        this.autoCloseTimeOut;
        this.message = '';
        this.$get = ['$document',
            '$window',
            '$compile',
            '$rootScope', function ($document, $window, $compile, $rootScope) {
            var message = this.message,
                autoCloseTime = this.autoCloseTime,
                autoCloseTimeOut = this.autoCloseTimeOut,
                $scope = $rootScope,
                $body = $document.find('body');

            // hide message
            function hideMessage(){
                $('#ngMessages-container').removeClass('showing')
                    .find('.message').text('').end().find('.close-message').hide();
               
                clearTimeout(autoCloseTimeOut);
            }

            // The ID for the interval controlling start()
            return {
                hide: function () {
                    hideMessage();
                },
                show: function (text, type, autoClose) {
                    if(!text || text === '') return;
                    var messageWrapper = $('#ngMessages-container');
                    messageWrapper.css('width', 450 + "px");
                    messageWrapper.find('#ngMessages').removeAttr('class').addClass(type || 'success');
                    messageWrapper.addClass('showing').find('.message').text(text);
                    messageWrapper.find('.close-message').show();
                    messageWrapper.find('.close-message').on('click', function(e){
                        e.preventDefault();
                        hideMessage();
                    })

                    // scroll to top in order to see the message.
                    // $('html, body').animate({scrollTop: 0}, 500);

                    if(autoClose){
                        autoCloseTimeOut = setTimeout(function(){
                            hideMessage();
                        }, autoCloseTime)
                    }

                },
                showCustomHW: function (text, type, autoClose, width) {
                    if(!text || text === '') return;
                    var messageWrapper = $('#ngMessages-container');
                    messageWrapper.css('width', width + "px");
                    messageWrapper.find('#ngMessages').removeAttr('class').addClass(type || 'success');
                    messageWrapper.addClass('showing').find('.message').text(text);
                    messageWrapper.find('.close-message').show();
                    messageWrapper.find('.close-message').on('click', function(e){
                        e.preventDefault();
                        hideMessage();
                    })

                    // scroll to top in order to see the message.
                    // $('html, body').animate({scrollTop: 0}, 500);

                    if(autoClose){
                        autoCloseTimeOut = setTimeout(function(){
                            hideMessage();
                        }, autoCloseTime)
                    }

                },
                showMulti: function (list, type, autoClose) {
                    if (!list || list.length == 0) return;
                    var messageWrapper = $('#ngMessages-container');
                    messageWrapper.find('#ngMessages').removeAttr('class').addClass(type || 'success');
                    var messageCollector = "";
                    angular.forEach(list, function (value) {
                        messageCollector = messageCollector + value.message + "<br>";
                    });
                    messageWrapper.addClass('showing').find('.message').html(messageCollector);
                    var determineHeight = list.length * 30;
                    messageWrapper.css('height', determineHeight + "px");
                    messageWrapper.find('.close-message').show();
                    messageWrapper.find('.close-message').on('click', function (e) {
                        e.preventDefault();
                        hideMessage();
                    })

                    // scroll to top in order to see the message.
                    // $('html, body').animate({scrollTop: 0}, 500);

                    if (autoClose) {
                        autoCloseTimeOut = setTimeout(function () {
                            hideMessage();
                        }, autoCloseTime)
                    }

                },
                css: function (args) {
                    return messageWrapperElement.children().css(args);
                },//custom messages
                displayError: function(form) {
                    angular.forEach(form.$error, function (errors) {
                        angular.forEach(errors, function (value) {
                            value.$setDirty();
                            console.log("field:" + value.$name);
                        });
                    });
                },

                displayErrorForField: function (field) {
                    field.$error.duplicated = true;
                },
                displayErrorFormat: function (field) {
                    if(field.$error.format){
                        field.$error.format = true;
                    }
                },
                displayErrorForFieldType: function (field, type) {
                    if (type == 'datanotfound') {
                        field.$error.datanotfound = true;
                    }
                    if (type == 'duplicated') {
                        field.$error.duplicated = true;
                    }
                    if (type == 'invalid') {
                        field.$error.invalid = true;
                    }
                    if (type == 'pattern') {
                        field.$error.pattern = true;
                        field.$setDirty();
                    }
                    if (type == 'required') {
                        field.$error.required = true;
                        field.$setDirty();
                    }

                }
            }
        }];
    });


angular.module('ngCustomMessages', ['ngCustomMessages.provider']);
