#!/bin/bash

# To run: sh new_centos_machine.sh url:acoserver.tar.gz url:acow-webapp.war url:tui.tar.gz

ROOT=/root/installers


echo $'\n' "WELCOME TO THE OVA CREATION SCRIPT. THE INSTALLATION IS STARTING!" $'\n'

echo $'\n' "Installing necessary dependencies..." $'\n'
yum -y install wget # -y flag is used to force installation without confirmation
yum -y install dos2unix
yum -y install zip
yum -y install unzip

echo $'\n' "STARTING ACO-SERVER INSTALLATION..."
########################################### Starting aCOServer installation ############################################
echo $'\n' "Creating necessary directories..."
if [[ ! -e /opt/akkadian/ ]]; then
    mkdir -p /opt/akkadian/data
else
    echo "ERROR: /opt/akkadian/ directory already exists. Please try manually!"; exit;
fi

if [[ ! -e /opt/akkadian/aco-server ]]; then
    mkdir /opt/akkadian/aco-server
else
    echo "ERROR: /opt/akkadian/aco-server directory already exists. Please try manually!"; exit;
fi


echo $'\n' "Copping aco-server directory..."
tar -xvzf $ROOT/acoserver.tar.gz -C /opt/akkadian/aco-server/ --strip-components 1
chown -R root:root /opt/akkadian/aco-server/
echo " aco-server files copied successfully!" $'\n'

echo $'\n' "Converting dos 2 unix to prevent issues with jenkins windows repo..."
dos2unix /opt/akkadian/aco-server/scripts/*
dos2unix /opt/akkadian/aco-server/configs/*

# TODO: remove license and web???
for i in backups db license log published restore template tmp web updates 
do
    if [[ ! -e /opt/akkadian/data/$i ]]; then
        mkdir /opt/akkadian/data/$i
    else
        echo "ERROR: /opt/akkadian/data/"$i "directory already exists. Please try manually!"; exit;
    fi
done

if [[ ! -e /opt/akkadian/data/log/mongodb ]]; then
    mkdir -p /opt/akkadian/data/log/mongodb
else
    echo "ERROR: /opt/akkadian/data/log/mongodb directory already exists. Please try manually!"; exit;
fi

if [[ ! -e /opt/akkadian/data/published/csv ]]; then
    mkdir -p /opt/akkadian/data/published/csv
else
    echo "ERROR: /opt/akkadian/data/published/csv directory already exists. Please try manually!"; exit;
fi

# Change folder permissions
chmod -R 765 /opt/akkadian/
echo " Necessary directories created successfully!" $'\n'


echo $'\n' "Installing nginx..." $'\n'
# Reference page: https://www.digitalocean.com/community/tutorials/how-to-install-nginx-on-centos-7
yum -y install epel-release
yum -y install nginx

echo $'\n' "Configuring nginx..." $'\n'
systemctl enable nginx.service

cp /opt/akkadian/aco-server/configs/nginx.conf /etc/nginx/
if [[ ! -e /etc/nginx/nginx.conf ]]; then
    echo "ERROR: Couldn't copy nginx.conf. Please try manually!"; exit;
fi

systemctl start nginx.service
if [ ! -e /var/run/nginx.pid ]; then
    echo "ERROR: nginx is not running. Please check mannually"; exit;
fi
echo " Nginx installed and configured successfully!" $'\n'


echo $'\n' "Installing mongo database..."
https://repo.mongodb.org/yum/redhat/7/mongodb-org/4.0/x86_64/RPMS/mongodb-org-server-4.0.10-1.el7.x86_64.rpm

wget https://fastdl.mongodb.org/linux/mongodb-linux-x86_64-rhel70-3.6.6.tgz -O $ROOT/mongo.tar.gz
if [[ ! -e $ROOT/mongo.tar.gz ]]; then
     echo "ERROR: Couldn't download mongo.tar.gz. Please try manually!"; exit;
fi
#
tar -xvzf $ROOT/mongo.tar.gz -C $ROOT/
if [[ ! -e $ROOT/mongodb-linux-x86_64-rhel70-3.6.6 ]]; then
   echo "ERROR: Couldn't uncompress mongo.tar.gz. Please try manually!"; exit;
fi
#
cp $ROOT/mongodb-linux-x86_64-rhel70-3.6.6/bin/* /bin/

echo $'\n' "Creating database..." $'\n'

mongod --fork --logpath /opt/akkadian/data/log/mongodb/mongod.log --port 27017 --dbpath /opt/akkadian/data/db/
echo "Creating mongo user"
mongo admin /opt/akkadian/aco-server/configs/user.js;
sleep 2
kill -9 `pgrep -f mongod`
echo " MongoDB installed and configured successfully!" $'\n'
sleep 4
rm -Rf /opt/akkadian/data/db/mongod.lock

cp /opt/akkadian/aco-server/configs/mongodb.service /etc/systemd/system/
if [[ ! -e /etc/systemd/system/mongodb.service ]]; then
     echo "ERROR: Couldn't copy mongodb.service. Please try manually!"; exit;
fi

systemctl enable mongodb.service
systemctl start mongodb.service

# TODO: verify how to get pid.

sleep 5

echo $'\n' "Installing netcore runtime..."
# Getting and installing dotnet-host
wget https://packages.microsoft.com/rhel/7/prod/dotnet-host-2.1.1-x64.rpm -O $ROOT/dotnet-host.rpm
if [[ ! -e $ROOT/dotnet-host.rpm ]]; then
    echo "ERROR: Couldn't download dotnet-host.rpm. Please try manually!"; exit;
fi
rpm -i $ROOT/dotnet-host.rpm

# Getting and installing dotnet-hostfxr
wget https://packages.microsoft.com/rhel/7/prod/dotnet-hostfxr-2.1.1-x64.rpm -O $ROOT/dotnet-hostfxr.rpm
if [[ ! -e $ROOT/dotnet-hostfxr.rpm ]]; then
    echo "ERROR: Couldn't download dotnet-hostfxr.rpm. Please try manually!"; exit;
fi
rpm -i $ROOT/dotnet-hostfxr.rpm

# Getting and installing dotnet-runtime-deps
wget https://packages.microsoft.com/rhel/7/prod/dotnet-runtime-deps-2.1.1-rhel.7-x64.rpm -O $ROOT/dotnet-runtime-deps.rpm
if [[ ! -e $ROOT/dotnet-runtime-deps.rpm ]]; then
    echo "ERROR: Couldn't download dotnet-runtime-deps.rpm. Please try manually!"; exit;
fi
rpm -i $ROOT/dotnet-runtime-deps.rpm

# Getting and installing dotnet-runtime
wget https://packages.microsoft.com/rhel/7/prod/dotnet-runtime-2.1.1-x64.rpm -O $ROOT/dotnet-runtime.rpm
if [[ ! -e $ROOT/dotnet-runtime.rpm ]]; then
    echo "ERROR: Couldn't download dotnet-runtime.rpm. Please try manually!"; exit;
fi
rpm -i $ROOT/dotnet-runtime.rpm
echo " Netcore runtime installed successfully!" $'\n'


echo $'\n' "Setting selinux..."
setenforce permissive
cp -f /opt/akkadian/aco-server/configs/selinux /etc/sysconfig/
echo "Setting selinux successfully!" $'\n'


echo $'\n' "Creating kestrel service..."
# Reference page: https://docs.microsoft.com/en-us/aspnet/core/host-and-deploy/linux-nginx?view=aspnetcore-2.1&tabs=aspnetcore2x#create-the-service-file
cp /opt/akkadian/aco-server/configs/aco-server.service /etc/systemd/system/

systemctl enable aco-server.service

systemctl start aco-server.service
# TODO: Now is running but we need check that automatically. We need search the correct file!
# if [ ! -e /var/run/aco-server.pid ]; then
#     echo "ERROR: kestrel is not running. Please check mannually!"; exit;
# fi
echo " Kestrel service created and running!" $'\n'
############################################ Ending aCOServer installation #############################################


############################################# Starting aCOWeb installation #############################################
echo $'\n' "STARTING ACO-WEB INSTALLATION..."


echo $'\n' "Installing JDK..."
# Reference page: https://tecadmin.net/install-java-8-on-centos-rhel-and-fedora/
wget -c --header "Cookie: oraclelicense=accept-securebackup-cookie" http://download.oracle.com/otn-pub/java/jdk/8u181-b13/96a7b8442fe848ef90c96a2fad6ed6d1/jdk-8u181-linux-x64.tar.gz -O $ROOT/jdk.tar.gz
if [[ ! -e $ROOT/jdk.tar.gz ]]; then
    echo "ERROR: Couldn't download jdk.tar.gz. Please try manually!"; exit;
fi

if [[ ! -e /opt/jdk ]]; then
    mkdir /opt/jdk
else
    echo "ERROR: /opt/jdk directory already exists. Please try manually!"; exit;
fi

tar -xvzf $ROOT/jdk.tar.gz -C /opt/jdk --strip-components 1

export JAVA_HOME=/opt/jdk
export JRE_HOME=/opt/jdk/jre
export PATH=$PATH:/opt/jdk1/bin:/opt/jdk/jre/bin
echo " JDK installed successfully!" $'\n'


echo $'\n' "Installing MySql..."
# Reference page: https://www.digitalocean.com/community/tutorials/how-to-install-mysql-on-centos-7
wget https://dev.mysql.com/get/mysql57-community-release-el7-9.noarch.rpm -O $ROOT/my-sql.rpm
if [[ ! -e $ROOT/my-sql.rpm ]]; then
    echo "ERROR: Couldn't download my-sql.rpm. Please try manually!"; exit;
fi

rpm -ivh $ROOT/my-sql.rpm
yum -y install mysql-server

systemctl enable mysqld

systemctl start mysqld
if [ ! -e /var/run/mysqld/mysqld.pid ]; then
    echo "ERROR: mysql is not running. Please check mannually!"; exit;
fi

pwd=$(awk -F ': ' '{print $2}' <<< $(grep 'temporary password' /var/log/mysqld.log))
mysqladmin -u root --password=${pwd} password 'aCOAkk4di4n!'
mysql -uroot -p'aCOAkk4di4n!' -e "CREATE DATABASE fp;"
echo " Mysql installed and configured successfully!" $'\n'


echo $'\n' "Installing Tomcat..."
# Reference page: https://linuxize.com/post/how-to-install-tomcat-8-5-on-centos-7/
useradd -m -U -d /opt/tomcat -s /bin/false tomcat

wget http://apache.dattatec.com/tomcat/tomcat-8/v8.5.34/bin/apache-tomcat-8.5.34.tar.gz -O $ROOT/tomcat.tar.gz
if [[ ! -e $ROOT/tomcat.tar.gz ]]; then
    echo "ERROR: Couldn't download tomcat.tar.gz. Please try manually!"; exit;
fi

mkdir /opt/tomcat
tar -xvzf $ROOT/tomcat.tar.gz -C /opt/tomcat --strip-components 1

chown -R tomcat:tomcat /opt/tomcat
chmod +x /opt/tomcat/bin/*.sh

cp /opt/akkadian/aco-server/configs/tomcat.service /etc/systemd/system/
systemctl enable tomcat

systemctl start tomcat
# if [ ! -e /var/run/tomcat.pid ]; then
#     echo "ERROR: tomcat is not running. Please check mannually!"; exit;
# fi

echo $'\n' "Copping necessary aCO Web files..."
systemctl stop tomcat.service
# if [ -e /var/run/tomcat.pid ]; then
#     echo "ERROR: tomcat is not running. Please check mannually!"; exit;
# fi

cp /opt/akkadian/aco-server/acow-installer/fp-akkadian-platform.properties /opt/tomcat/conf/
cp /opt/akkadian/aco-server/acow-installer/jtapi-9.1.jar /opt/tomcat/lib/
cp /opt/akkadian/aco-server/acow-installer/mysql-connector-java-5.1.39-bin.jar /opt/tomcat/lib/
cp /opt/akkadian/aco-server/acow-installer/sqljdbc4.jar /opt/tomcat/lib/
cp $ROOT/acow-webapp.war /opt/tomcat/webapps/

systemctl start tomcat.service
echo " Necessary files were copied successfully!" $'\n'


echo $'\n' "Openning firewall ports..."
creation=$(firewall-cmd --add-port=443/tcp --permanent)
if [ "$creation" != "success" ]; then
    echo "ERROR: Can't open 443 port. Please try manually!"; exit;
fi

creation=$(firewall-cmd --add-port=80/tcp --permanent)
if [ "$creation" != "success" ]; then
    echo "ERROR: Can't open 443 port. Please try manually!"; exit;
fi

reload=$(firewall-cmd --reload)
if [ "$reload" != "success" ]; then
    echo "ERROR: Can't reload firewall. Please try manually!"; exit;
fi
echo " Firewall ports were opened successfully!" $'\n'
############################################## Ending aCOWeb installation ##############################################


echo $'\n' "STARTING CLI INSTALLATION..."
############################################## Starting CLI installation ###############################################
echo $'\n' "Creating akkadian user..."
adduser akkadianuser
echo "akkadianpassword" | passwd --stdin akkadianuser
gpasswd -a akkadianuser wheel

echo $'\n' "# Akkadian user configuration" >> /etc/sudoers
echo "akkadianuser ALL=(ALL) ALL" >> /etc/sudoers
echo "%akkadianuser   ALL=(ALL) NOPASSWD: ALL" >> /etc/sudoers

echo "sudo akkadianAppManager menu" >> /home/akkadianuser/.bashrc
echo " Akkadian user created successfully!" $'\n'


echo $'\n' "Instaling cli..."

tar -xvzf $ROOT/tui.tar.gz -C /home/akkadianuser/

dos2unix /home/akkadianuser/*
dos2unix /home/akkadianuser/netifaces-0.10.4/build/temp.linux-x86_64-2.7/*
dos2unix /home/akkadianuser/netifaces-0.10.4/dist/*
dos2unix /home/akkadianuser/netifaces-0.10.4/netifaces.egg-info/*

echo $'\n' "Installing necessary dependencies"
curl https://bootstrap.pypa.io/get-pip.py -o /home/akkadianuser/get-pip.py
python2.7 /home/akkadianuser/get-pip.py

yum -y install gcc
yum -y install python-devel

# Installing netifaces library
cd /home/akkadianuser/netifaces-0.10.4/
python2.7 setup.py install
cd /

# Changing script permissions
cp /home/akkadianuser/centos7_scripts/* /home/akkadianuser/scripts/
chmod +x /home/akkadianuser/scripts/*

pip uninstall -y setuptools && pip install setuptools==0.9.8

echo $'\n' "Installing akkadianAppManager"
cd /home/akkadianuser/
python2.7 setup.py install
cd /

dos2unix /home/akkadianuser/scripts/*
############################################### Ending CLI installation ################################################


##################################################### Remove files #####################################################
# rm -rf $ROOT
# rm new_centOS_machine.sh
#

echo "Setting ca-bundle.pem permissions"
chmod 766 /etc/pki/ca-trust/extracted/pem/tls-ca-bundle.pem

######### Adding needed configurations #########
sudo yes | cp -rf /opt/akkadian/aco-server/configs/sysctl.conf /etc/sysctl.conf
sudo yes | cp -rf /opt/akkadian/aco-server/configs/limits.conf /etc/security/limits.conf
sudo yes | cp -rf /opt/akkadian/aco-server/configs/supervisord.conf /etc/supervisord.conf

echo $'\n' "THAT'S ALL. THANK YOU!" $'\n'
echo $'\n Good bye! ' $'\n'

