db.getCollection('ConsoleEvent').aggregate([
    { "$group": {
        "_id": { "eventName": "$eventName", "callId":"$callId", "monitoredNumber":"$monitoredNumber", 
            "operatorId":"$operatorId", "type":"$type"},
        "dups": { "$push": "$_id" },
        "count": { "$sum": 1 }
    }},
    { "$match": { "count": { "$gt": 1 }}}
],{ allowDiskUse: true } ).forEach(function(doc) {
    doc.dups.shift();
    db.getCollection('ConsoleEvent').remove({$and: [{ "_id": {"$in": doc.dups }},{"type" : "CALL"}]});
});

db.getCollection('ConsoleEventWeb').aggregate([
    { "$group": {
        "_id": { "eventName": "$eventName", "ciscoCallId":"$ciscoCallId", "operatorId":"$operatorId" },
        "dups": { "$push": "$_id" },
        "count": { "$sum": 1 }
    }},
    { "$match": { "count": { "$gt": 1 } }}
],{ allowDiskUse: true } ).forEach(function(doc) {
    doc.dups.shift();
    db.getCollection('ConsoleEventWeb').remove({ "_id": {"$in": doc.dups }});
});